/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class GemLegs
extends GemArmorBase {
    private final Map<Integer, Long> lastJumpTracker = new HashMap<Integer, Long>();

    public GemLegs(Item.Properties props) {
        super(EquipmentSlot.LEGS, props);
        MinecraftForge.EVENT_BUS.addListener(this::onJump);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltips, @Nonnull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.GEM_LORE_LEGS.translate(new Object[0]));
    }

    private void onJump(LivingEvent.LivingJumpEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_20193_().f_46443_) {
                this.lastJumpTracker.put(player.m_142049_(), player.m_20193_().m_46467_());
            }
        }
    }

    private boolean jumpedRecently(Player player) {
        return this.lastJumpTracker.containsKey(player.m_142049_()) && player.m_20193_().m_46467_() - this.lastJumpTracker.get(player.m_142049_()) < 5L;
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (level.f_46443_ && player.m_6144_() && !player.m_20096_() && player.m_20184_().m_7098_() > -8.0 && !this.jumpedRecently(player)) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, (double)-0.32f, 0.0));
        }
        if (player.m_6144_()) {
            AABB box = new AABB(player.m_20185_() - 3.5, player.m_20186_() - 3.5, player.m_20189_() - 3.5, player.m_20185_() + 3.5, player.m_20186_() + 3.5, player.m_20189_() + 3.5);
            WorldHelper.repelEntitiesSWRG(level, box, player);
            if (!level.f_46443_ && player.m_20184_().m_7098_() < -0.08) {
                List entities = player.m_20193_().m_6249_((Entity)player, player.m_142469_().m_82383_(player.m_20184_()).m_82400_(2.0), entity -> entity instanceof LivingEntity);
                for (Entity e : entities) {
                    if (!e.m_6087_()) continue;
                    e.m_6469_(DamageSource.m_19344_((Player)player), (float)(-player.m_20184_().m_7098_()) * 6.0f);
                }
            }
        }
    }
}

