/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IAlchBagItem;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.AlchBagItemCapabilityWrapper;
import moze_intel.projecte.capability.AlchChestItemCapabilityWrapper;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.handlers.InternalTimers;
import moze_intel.projecte.integration.IntegrationHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RepairTalisman
extends ItemPE
implements IAlchBagItem,
IAlchChestItem,
IPedestalItem {
    private static final Predicate<ItemStack> CAN_REPAIR_ITEM = stack -> !stack.m_41619_() && !stack.getCapability(PECapabilities.MODE_CHANGER_ITEM_CAPABILITY).isPresent() && ItemHelper.isRepairableDamagedItem(stack);

    public RepairTalisman(Item.Properties props) {
        super(props);
        this.addItemCapability(AlchBagItemCapabilityWrapper::new);
        this.addItemCapability(AlchChestItemCapabilityWrapper::new);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
        this.addItemCapability("curios", IntegrationHelper.CURIO_CAP_SUPPLIER);
    }

    public void m_6883_(@Nonnull ItemStack stack, Level level, @Nonnull Entity entity, int invSlot, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(InternalTimers.CAPABILITY).ifPresent(timers -> {
                timers.activateRepair();
                if (timers.canRepair()) {
                    RepairTalisman.repairAllItems(player);
                }
            });
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                level.m_45976_(ServerPlayer.class, ((IDMPedestal)pedestal).getEffectBounds()).forEach(RepairTalisman::repairAllItems);
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.repair.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.repair.get() != -1) {
            list.add((Component)PELang.PEDESTAL_REPAIR_TALISMAN_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_REPAIR_TALISMAN_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.repair.get())));
        }
        return list;
    }

    @Override
    public boolean updateInAlchChest(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
        EmcBlockEntity chest;
        if (!level.f_46443_ && (chest = WorldHelper.getBlockEntity(EmcBlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            CompoundTag nbt = stack.m_41784_();
            byte coolDown = nbt.m_128445_("Cooldown");
            if (coolDown > 0) {
                nbt.m_128344_("Cooldown", (byte)(coolDown - 1));
            } else {
                chest.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                    if (RepairTalisman.repairAllItems(inv, CAN_REPAIR_ITEM)) {
                        nbt.m_128344_("Cooldown", (byte)19);
                        chest.markDirty(false);
                    }
                });
            }
        }
        return false;
    }

    @Override
    public boolean updateInAlchBag(@Nonnull IItemHandler inv, @Nonnull Player player, @Nonnull ItemStack stack) {
        if (player.m_20193_().f_46443_) {
            return false;
        }
        CompoundTag nbt = stack.m_41784_();
        byte coolDown = nbt.m_128445_("Cooldown");
        if (coolDown > 0) {
            nbt.m_128344_("Cooldown", (byte)(coolDown - 1));
        } else if (RepairTalisman.repairAllItems(inv, CAN_REPAIR_ITEM)) {
            nbt.m_128344_("Cooldown", (byte)19);
            return true;
        }
        return false;
    }

    private static void repairAllItems(Player player) {
        Predicate<ItemStack> canRepairPlayerItem = CAN_REPAIR_ITEM.and(stack -> stack != player.m_21205_() || !player.f_20911_);
        player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> RepairTalisman.repairAllItems(inv, canRepairPlayerItem));
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            RepairTalisman.repairAllItems(curios, canRepairPlayerItem);
        }
    }

    private static boolean repairAllItems(IItemHandler inv, Predicate<ItemStack> canRepairStack) {
        boolean hasAction = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack invStack = inv.getStackInSlot(i);
            if (!canRepairStack.test(invStack)) continue;
            invStack.m_41721_(invStack.m_41773_() - 1);
            if (hasAction) continue;
            hasAction = true;
        }
        return hasAction;
    }
}

