/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import moze_intel.projecte.capability.ItemCapability;
import moze_intel.projecte.capability.ItemCapabilityWrapper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class ItemPE
extends Item {
    private final List<Supplier<ItemCapability<?>>> supportedCapabilities = new ArrayList();

    public ItemPE(Item.Properties props) {
        super(props);
    }

    protected void addItemCapability(Supplier<ItemCapability<?>> capabilitySupplier) {
        this.supportedCapabilities.add(capabilitySupplier);
    }

    protected void addItemCapability(String modid, Supplier<Supplier<ItemCapability<?>>> capabilitySupplier) {
        if (ModList.get().isLoaded(modid)) {
            this.supportedCapabilities.add(capabilitySupplier.get());
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() != newStack.m_41720_()) {
            return true;
        }
        if (oldStack.m_41782_() && newStack.m_41782_()) {
            CompoundTag newTag = newStack.m_41784_();
            CompoundTag oldTag = oldStack.m_41784_();
            boolean diffActive = oldTag.m_128441_("Active") && newTag.m_128441_("Active") && !oldTag.m_128423_("Active").equals(newTag.m_128423_("Active"));
            boolean diffMode = oldTag.m_128441_("Mode") && newTag.m_128441_("Mode") && !oldTag.m_128423_("Mode").equals(newTag.m_128423_("Mode"));
            return diffActive || diffMode;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        if (this.supportedCapabilities.isEmpty()) {
            return super.initCapabilities(stack, nbt);
        }
        return new ItemCapabilityWrapper(stack, this.supportedCapabilities);
    }

    public static long getEmc(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_().m_128454_("StoredEMC") : 0L;
    }

    public static void setEmc(ItemStack stack, long amount) {
        stack.m_41784_().m_128356_("StoredEMC", amount);
    }

    public static void addEmcToStack(ItemStack stack, long amount) {
        ItemPE.setEmc(stack, ItemPE.getEmc(stack) + amount);
    }

    public static void removeEmc(ItemStack stack, long amount) {
        long result = ItemPE.getEmc(stack) - amount;
        if (result < 0L) {
            result = 0L;
        }
        ItemPE.setEmc(stack, result);
    }

    public static boolean consumeFuel(Player player, ItemStack stack, long amount, boolean shouldRemove) {
        if (amount <= 0L) {
            return true;
        }
        long current = ItemPE.getEmc(stack);
        if (current < amount) {
            long consume = EMCHelper.consumePlayerFuel(player, amount - current);
            if (consume == -1L) {
                return false;
            }
            ItemPE.addEmcToStack(stack, consume);
        }
        if (shouldRemove) {
            ItemPE.removeEmc(stack, amount);
        }
        return true;
    }
}

