/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface IItemMode
extends IModeChanger {
    public ILangEntry[] getModeLangEntries();

    default public byte getModeCount() {
        return (byte)this.getModeLangEntries().length;
    }

    default public ILangEntry getModeLangEntry(ItemStack stack) {
        ILangEntry[] langEntries = this.getModeLangEntries();
        byte mode = this.getMode(stack);
        if (mode < 0 || mode >= langEntries.length) {
            return PELang.INVALID_MODE;
        }
        return langEntries[mode];
    }

    @Override
    default public byte getMode(@Nonnull ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_128445_("Mode") : (byte)0;
    }

    @Override
    default public boolean changeMode(@Nonnull Player player, @Nonnull ItemStack stack, InteractionHand hand) {
        byte numModes = this.getModeCount();
        if (numModes < 2) {
            return false;
        }
        stack.m_41784_().m_128344_("Mode", (byte)((this.getMode(stack) + 1) % numModes));
        player.m_6352_((Component)this.getModeSwitchEntry().translate(this.getModeLangEntry(stack)), Util.f_137441_);
        return true;
    }

    default public ILangEntry getModeSwitchEntry() {
        return PELang.MODE_SWITCH;
    }

    default public Component getToolTip(ItemStack stack) {
        return PELang.CURRENT_MODE.translate(ChatFormatting.AQUA, this.getModeLangEntry(stack));
    }
}

