/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.capability.ChargeItemCapabilityWrapper;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.IBarHelper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DestructionCatalyst
extends ItemPE
implements IItemCharge,
IBarHelper {
    public DestructionCatalyst(Item.Properties props) {
        super(props);
        this.addItemCapability(ChargeItemCapabilityWrapper::new);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = ctx.m_43722_();
        int numRows = this.calculateDepthFromCharge(stack);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(WorldHelper.getDeepBox(ctx.m_8083_(), ctx.m_43719_(), --numRows))) {
            BlockState state;
            float hardness;
            if (level.m_46859_(pos) || (hardness = (state = level.m_8055_(pos)).m_60800_((BlockGetter)level, pos)) == -1.0f || hardness >= 50.0f) continue;
            if (!DestructionCatalyst.consumeFuel(player, stack, 8L, true)) break;
            hasAction = true;
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, pos = pos.m_7949_())) continue;
            List list = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, pos), (Entity)player, (ItemStack)stack);
            drops.addAll(list);
            level.m_7471_(pos, false);
            if (level.f_46441_.nextInt(8) != 0) continue;
            ((ServerLevel)level).m_8767_((ParticleOptions)(level.f_46441_.nextBoolean() ? ParticleTypes.f_123759_ : ParticleTypes.f_123755_), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.05);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, ctx.m_8083_());
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private int calculateDepthFromCharge(ItemStack stack) {
        int charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + 8 * charge;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 3;
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public float getWidthForBar(ItemStack stack) {
        return 1.0f - this.getChargePercent(stack);
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        return this.getScaledBarWidth(stack);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return this.getColorForBar(stack);
    }
}

