/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.container;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.gameObjs.block_entities.CondenserBlockEntity;
import moze_intel.projecte.gameObjs.blocks.Condenser;
import moze_intel.projecte.gameObjs.container.EmcChestBlockEntityContainer;
import moze_intel.projecte.gameObjs.container.PEContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotCondenserLock;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.container.slots.ValidatedSlot;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import moze_intel.projecte.gameObjs.registration.impl.ContainerTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.gameObjs.registries.PEContainerTypes;
import moze_intel.projecte.network.packets.to_client.UpdateCondenserLockPKT;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserContainer
extends EmcChestBlockEntityContainer<CondenserBlockEntity> {
    public final PEContainer.BoxedLong displayEmc = new PEContainer.BoxedLong();
    public final PEContainer.BoxedLong requiredEmc = new PEContainer.BoxedLong();
    @Nullable
    private ItemInfo lastLockInfo;

    public CondenserContainer(int windowId, Inventory playerInv, CondenserBlockEntity condenser) {
        this(PEContainerTypes.CONDENSER_CONTAINER, windowId, playerInv, condenser);
    }

    protected CondenserContainer(ContainerTypeRegistryObject<? extends CondenserContainer> type, int windowId, Inventory playerInv, CondenserBlockEntity condenser) {
        super(type, windowId, playerInv, condenser);
        this.longFields.add(this.displayEmc);
        this.longFields.add(this.requiredEmc);
        this.initSlots();
    }

    protected void initSlots() {
        this.m_38897_(new SlotCondenserLock(((CondenserBlockEntity)this.blockEntity)::getLockInfo, 0, 12, 6));
        Predicate<ItemStack> validator = s -> SlotPredicates.HAS_EMC.test((ItemStack)s) && !((CondenserBlockEntity)this.blockEntity).isStackEqualToLock((ItemStack)s);
        ItemStackHandler handler = ((CondenserBlockEntity)this.blockEntity).getInput();
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.m_38897_((Slot)new ValidatedSlot((IItemHandler)handler, j + i * 13, 12 + j * 18, 26 + i * 18, validator));
            }
        }
        this.addPlayerInventory(48, 154);
    }

    @Override
    protected void broadcastPE(boolean all) {
        this.displayEmc.set(((CondenserBlockEntity)this.blockEntity).displayEmc);
        this.requiredEmc.set(((CondenserBlockEntity)this.blockEntity).requiredEmc);
        ItemInfo lockInfo = ((CondenserBlockEntity)this.blockEntity).getLockInfo();
        if (all || !Objects.equals(lockInfo, this.lastLockInfo)) {
            this.lastLockInfo = lockInfo;
            this.syncDataChange(new UpdateCondenserLockPKT((short)this.f_38840_, lockInfo));
        }
        super.broadcastPE(all);
    }

    protected BlockRegistryObject<? extends Condenser, ?> getValidBlock() {
        return PEBlocks.CONDENSER;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return CondenserContainer.stillValid(player, this.blockEntity, this.getValidBlock());
    }

    public void m_150399_(int slot, int button, @Nonnull ClickType flag, @Nonnull Player player) {
        if (slot == 0) {
            if (((CondenserBlockEntity)this.blockEntity).attemptCondenserSet(player)) {
                this.m_38946_();
            }
        } else {
            super.m_150399_(slot, button, flag, player);
        }
    }

    public int getProgressScaled() {
        if (this.requiredEmc.get() == 0L) {
            return 0;
        }
        if (this.displayEmc.get() >= this.requiredEmc.get()) {
            return 102;
        }
        return (int)(102.0 * ((double)this.displayEmc.get() / (double)this.requiredEmc.get()));
    }

    public void updateLockInfo(@Nullable ItemInfo lockInfo) {
        ((CondenserBlockEntity)this.blockEntity).setLockInfoFromPacket(lockInfo);
    }
}

