/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.block_entities.DMPedestalBlockEntity;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Pedestal
extends Block
implements SimpleWaterloggedBlock,
PEEntityBlock<DMPedestalBlockEntity>,
IMatterBlock {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (VoxelShape)Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)));

    public Pedestal(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> props) {
        super.m_7926_(props);
        props.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Deprecated
    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        return SHAPE;
    }

    private boolean dropItem(Level level, BlockPos pos) {
        ItemStack stack;
        DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (pedestal != null && !(stack = pedestal.getInventory().getStackInSlot(0)).m_41619_()) {
            pedestal.getInventory().setStackInSlot(0, ItemStack.f_41583_);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.8, (double)pos.m_123343_(), stack));
            return true;
        }
        return false;
    }

    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropItem(level, pos);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void m_6256_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        if (!level.f_46443_) {
            this.dropItem(level, pos);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.m_7500_() && this.dropItem(level, pos)) {
            level.m_7260_(pos, state, state, 8);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult rtr) {
        if (!level.f_46443_) {
            DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos, true);
            if (pedestal == null) {
                return InteractionResult.FAIL;
            }
            ItemStack item = pedestal.getInventory().getStackInSlot(0);
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && !item.m_41619_()) {
                item.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY).ifPresent(pedestalItem -> {
                    pedestal.setActive(!pedestal.getActive());
                    level.m_7260_(pos, state, state, 8);
                });
            } else if (!stack.m_41619_() && item.m_41619_()) {
                pedestal.getInventory().setStackInSlot(0, stack.m_41620_(1));
                if (stack.m_41613_() <= 0) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6861_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Block neighbor, @Nonnull BlockPos neighborPos, boolean isMoving) {
        boolean hasSignal = level.m_46753_(pos);
        DMPedestalBlockEntity ped = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (ped != null && ped.previousRedstoneState != hasSignal) {
            ItemStack stack;
            if (hasSignal && !(stack = ped.getInventory().getStackInSlot(0)).m_41619_() && stack.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY).isPresent()) {
                ped.setActive(!ped.getActive());
                level.m_7260_(pos, state, state, 11);
            }
            ped.previousRedstoneState = hasSignal;
            ped.markDirty(false);
        }
    }

    @Deprecated
    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        ItemStack stack;
        DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (pedestal != null && !(stack = pedestal.getInventory().getStackInSlot(0)).m_41619_()) {
            if (stack.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY).isPresent()) {
                return pedestal.getActive() ? 15 : 10;
            }
            return 5;
        }
        return 0;
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<DMPedestalBlockEntity> getType() {
        return PEBlockEntityTypes.DARK_MATTER_PEDESTAL;
    }

    @Deprecated
    public boolean m_8133_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        return this.triggerBlockEntityEvent(state, level, pos, id, param);
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flags) {
        super.m_5871_(stack, level, tooltip, flags);
        tooltip.add((Component)PELang.PEDESTAL_TOOLTIP1.translate(new Object[0]));
        tooltip.add((Component)PELang.PEDESTAL_TOOLTIP2.translate(new Object[0]));
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public EnumMatterType getMatterType() {
        return EnumMatterType.DARK_MATTER;
    }
}

