/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.block_entities.DMFurnaceBlockEntity;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class MatterFurnace
extends AbstractFurnaceBlock
implements IMatterBlock,
PEEntityBlock<DMFurnaceBlockEntity> {
    private final EnumMatterType matterType;

    public MatterFurnace(BlockBehaviour.Properties props, EnumMatterType type) {
        super(props);
        this.matterType = type;
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<? extends DMFurnaceBlockEntity> getType() {
        return this.matterType == EnumMatterType.RED_MATTER ? PEBlockEntityTypes.RED_MATTER_FURNACE : PEBlockEntityTypes.DARK_MATTER_FURNACE;
    }

    protected void m_7137_(Level level, @Nonnull BlockPos pos, @Nonnull Player player) {
        DMFurnaceBlockEntity furnace;
        if (!level.f_46443_ && (furnace = WorldHelper.getBlockEntity(DMFurnaceBlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)furnace, (BlockPos)pos);
        }
    }

    @Deprecated
    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity furnace = WorldHelper.getBlockEntity((BlockGetter)level, pos);
            if (furnace != null) {
                furnace.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> WorldHelper.dropInventory(inv, level, pos));
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public int m_6782_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos) {
        BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, pos);
        if (blockEntity != null) {
            return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
        }
        return 0;
    }

    @Override
    public EnumMatterType getMatterType() {
        return this.matterType;
    }
}

