/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptCondenserSetEvent;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcChestBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class CondenserBlockEntity
extends EmcChestBlockEntity {
    protected final ItemStackHandler inputInventory = this.createInput();
    private final ItemStackHandler outputInventory = this.createOutput();
    @Nullable
    private ItemInfo lockInfo;
    private boolean isAcceptingEmc;
    public long displayEmc;
    public long requiredEmc;

    public CondenserBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityTypeRegistryObject<? extends CondenserBlockEntity>)PEBlockEntityTypes.CONDENSER, pos, state);
    }

    protected CondenserBlockEntity(BlockEntityTypeRegistryObject<? extends CondenserBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityTypeRegistryObject<? extends EmcChestBlockEntity>)type, pos, state);
        this.itemHandlerResolver = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)this::createAutomationInventory));
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.isAcceptingEmc;
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Nullable
    public ItemInfo getLockInfo() {
        return this.lockInfo;
    }

    public ItemStackHandler getInput() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutput() {
        return this.outputInventory;
    }

    protected ItemStackHandler createInput() {
        return new EmcBlockEntity.StackHandler(this, 91);
    }

    protected ItemStackHandler createOutput() {
        return this.inputInventory;
    }

    @Nonnull
    protected IItemHandler createAutomationInventory() {
        return new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserBlockEntity.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @Nonnull
            public ItemStack extractItem(int slot, int max, boolean simulate) {
                if (!this.getStackInSlot(slot).m_41619_() && CondenserBlockEntity.this.isStackEqualToLock(this.getStackInSlot(slot))) {
                    return super.extractItem(slot, max, simulate);
                }
                return ItemStack.f_41583_;
            }
        };
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, CondenserBlockEntity condenser) {
        condenser.checkLockAndUpdate();
        condenser.displayEmc = condenser.getStoredEmc();
        if (condenser.lockInfo != null && condenser.requiredEmc != 0L) {
            condenser.condense();
        }
        condenser.updateComparators();
    }

    private void checkLockAndUpdate() {
        if (this.lockInfo == null) {
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
            return;
        }
        long lockEmc = EMCHelper.getEmcValue(this.lockInfo);
        if (lockEmc > 0L) {
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
        } else {
            this.lockInfo = null;
            this.displayEmc = 0L;
            this.requiredEmc = 0L;
            this.isAcceptingEmc = false;
        }
    }

    protected void condense() {
        for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
            ItemStack stack = this.inputInventory.getStackInSlot(i);
            if (stack.m_41619_() || this.isStackEqualToLock(stack)) continue;
            this.inputInventory.extractItem(i, 1, false);
            this.forceInsertEmc(EMCHelper.getEmcSellValue(stack), IEmcStorage.EmcAction.EXECUTE);
            break;
        }
        if (this.getStoredEmc() >= this.requiredEmc && this.hasSpace()) {
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
            this.pushStack();
        }
    }

    protected void pushStack() {
        if (this.lockInfo != null) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)this.lockInfo.createStack(), (boolean)false);
        }
    }

    protected boolean hasSpace() {
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack stack = this.outputInventory.getStackInSlot(i);
            if (!stack.m_41619_() && (!this.isStackEqualToLock(stack) || stack.m_41613_() >= stack.m_41741_())) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEqualToLock(ItemStack stack) {
        if (this.lockInfo == null || stack.m_41619_()) {
            return false;
        }
        return this.lockInfo.equals(NBTManager.getPersistentInfo(ItemInfo.fromStack(stack)));
    }

    public void setLockInfoFromPacket(@Nullable ItemInfo lockInfo) {
        this.lockInfo = lockInfo;
    }

    public boolean attemptCondenserSet(Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        if (this.lockInfo == null) {
            ItemInfo reducedInfo;
            ItemInfo sourceInfo;
            ItemStack stack = player.f_36096_.m_142621_();
            if (!stack.m_41619_() && !MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptCondenserSetEvent(player, sourceInfo = ItemInfo.fromStack(stack), reducedInfo = NBTManager.getPersistentInfo(sourceInfo)))) {
                this.lockInfo = reducedInfo;
                this.markDirty(false);
                return true;
            }
            return false;
        }
        this.lockInfo = null;
        this.markDirty(false);
        return true;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inputInventory.deserializeNBT(nbt.m_128469_("Input"));
        this.lockInfo = ItemInfo.read(nbt.m_128469_("LockInfo"));
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Input", (Tag)this.inputInventory.serializeNBT());
        if (this.lockInfo != null) {
            tag.m_128365_("LockInfo", (Tag)this.lockInfo.write(new CompoundTag()));
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerIn) {
        return new CondenserContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public Component m_5446_() {
        return TextComponentUtil.build(PEBlocks.CONDENSER);
    }
}

