/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.emc.IngredientMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public abstract class BaseRecipeTypeMapper
implements IRecipeTypeMapper {
    @Override
    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> recipe, INSSFakeGroupManager fakeGroupManager) {
        ItemStack recipeOutput = recipe.m_8043_();
        if (recipeOutput.m_41619_()) {
            return false;
        }
        Collection<Ingredient> ingredientsChecked = this.getIngredientsChecked(recipe);
        if (ingredientsChecked == null) {
            return true;
        }
        ResourceLocation recipeID = recipe.m_6423_();
        ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> dummyGroupInfos = new ArrayList<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>>();
        IngredientMap<NormalizedSimpleStack> ingredientMap = new IngredientMap<NormalizedSimpleStack>();
        for (Ingredient recipeItem : ingredientsChecked) {
            ItemStack[] matches = this.getMatchingStacks(recipeItem, recipeID);
            if (matches == null) {
                return this.addConversionsAndReturn(mapper, dummyGroupInfos, true);
            }
            if (matches.length == 1) {
                if (matches[0].m_41619_()) {
                    return this.addConversionsAndReturn(mapper, dummyGroupInfos, false);
                }
                if (!this.addIngredient(ingredientMap, matches[0].m_41777_(), recipeID)) continue;
                return this.addConversionsAndReturn(mapper, dummyGroupInfos, true);
            }
            if (matches.length <= 0) continue;
            HashSet<NormalizedSimpleStack> rawNSSMatches = new HashSet<NormalizedSimpleStack>();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack match : matches) {
                if (match.m_41619_()) continue;
                rawNSSMatches.add(NSSItem.createItem(match));
                stacks.add(match);
            }
            int count = stacks.size();
            if (count == 0) {
                return this.addConversionsAndReturn(mapper, dummyGroupInfos, false);
            }
            if (count == 1) {
                if (!this.addIngredient(ingredientMap, ((ItemStack)stacks.get(0)).m_41777_(), recipeID)) continue;
                return this.addConversionsAndReturn(mapper, dummyGroupInfos, true);
            }
            Tuple<NormalizedSimpleStack, Boolean> group = fakeGroupManager.getOrCreateFakeGroup(rawNSSMatches);
            NormalizedSimpleStack dummy = (NormalizedSimpleStack)group.m_14418_();
            ingredientMap.addIngredient(dummy, 1);
            if (!((Boolean)group.m_14419_()).booleanValue()) continue;
            ArrayList<IngredientMap<NormalizedSimpleStack>> groupIngredientMaps = new ArrayList<IngredientMap<NormalizedSimpleStack>>();
            Iterator iterator = stacks.iterator();
            while (iterator.hasNext()) {
                IngredientMap<NormalizedSimpleStack> groupIngredientMap = new IngredientMap<NormalizedSimpleStack>();
                ItemStack stack = (ItemStack)iterator.next();
                if (this.addIngredient(groupIngredientMap, stack.m_41777_(), recipeID)) {
                    return this.addConversionsAndReturn(mapper, dummyGroupInfos, true);
                }
                groupIngredientMaps.add(groupIngredientMap);
            }
            dummyGroupInfos.add((Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>)new Tuple((Object)dummy, groupIngredientMaps));
        }
        mapper.addConversion(recipeOutput.m_41613_(), (NormalizedSimpleStack)NSSItem.createItem(recipeOutput), ingredientMap.getMap());
        return this.addConversionsAndReturn(mapper, dummyGroupInfos, true);
    }

    private boolean addConversionsAndReturn(IMappingCollector<NormalizedSimpleStack, Long> mapper, List<Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>>> dummyGroupInfos, boolean returnValue) {
        for (Tuple<NormalizedSimpleStack, List<IngredientMap<NormalizedSimpleStack>>> dummyGroupInfo : dummyGroupInfos) {
            for (IngredientMap groupIngredientMap : (List)dummyGroupInfo.m_14419_()) {
                mapper.addConversion(1, (NormalizedSimpleStack)dummyGroupInfo.m_14418_(), groupIngredientMap.getMap());
            }
        }
        return returnValue;
    }

    @Nullable
    private ItemStack[] getMatchingStacks(Ingredient ingredient, ResourceLocation recipeID) {
        try {
            return ingredient.m_43908_();
        }
        catch (Exception e) {
            if (this.isTagException(e)) {
                PECore.LOGGER.fatal("Error mapping recipe {}. Ingredient of type: {} crashed when getting the matching stacks due to not properly deserializing and handling tags. Please report this to the ingredient's creator.", (Object)recipeID, (Object)ingredient.getClass().getName(), (Object)e);
            } else {
                PECore.LOGGER.fatal("Error mapping recipe {}. Ingredient of type: {} crashed when getting the matching stacks. Please report this to the ingredient's creator.", (Object)recipeID, (Object)ingredient.getClass().getName(), (Object)e);
            }
            return null;
        }
    }

    private boolean addIngredient(IngredientMap<NormalizedSimpleStack> ingredientMap, ItemStack stack, ResourceLocation recipeID) {
        Item item = stack.m_41720_();
        boolean hasContainerItem = false;
        try {
            hasContainerItem = item.hasContainerItem(stack);
            if (hasContainerItem) {
                ingredientMap.addIngredient(NSSItem.createItem(item.getContainerItem(stack)), -1);
            }
        }
        catch (Exception e) {
            ResourceLocation itemName = item.getRegistryName();
            if (hasContainerItem) {
                if (this.isTagException(e)) {
                    PECore.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.m_135827_(), (Object)e);
                } else {
                    PECore.LOGGER.fatal("Error mapping recipe {}. Item: {} reported that it has a container item, but errors when trying to get the container item based on the stack in the recipe. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.m_135827_(), (Object)e);
                }
            } else if (this.isTagException(e)) {
                PECore.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack has a container item, due to not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.m_135827_(), (Object)e);
            } else {
                PECore.LOGGER.fatal("Error mapping recipe {}. Item: {} crashed when checking if the stack in the recipe has a container item. Please report this to {}.", (Object)recipeID, (Object)itemName, (Object)itemName.m_135827_(), (Object)e);
            }
            return true;
        }
        ingredientMap.addIngredient(NSSItem.createItem(stack), 1);
        return false;
    }

    private boolean isTagException(Exception e) {
        return e instanceof IllegalStateException && e.getMessage().matches("Tag \\S*:\\S* used before it was bound");
    }

    @Nullable
    private Collection<Ingredient> getIngredientsChecked(Recipe<?> recipe) {
        try {
            return this.getIngredients(recipe);
        }
        catch (Exception e) {
            ResourceLocation recipeID = recipe.m_6423_();
            if (this.isTagException(e)) {
                PECore.LOGGER.fatal("Error mapping recipe {}. Failed to get ingredients due to the recipe not properly deserializing and handling tags. Please report this to {}.", (Object)recipeID, (Object)recipeID.m_135827_(), (Object)e);
            } else {
                PECore.LOGGER.fatal("Error mapping recipe {}. Failed to get ingredients. Please report this to {}.", (Object)recipeID, (Object)recipeID.m_135827_(), (Object)e);
            }
            return null;
        }
    }

    protected Collection<Ingredient> getIngredients(Recipe<?> recipe) {
        return recipe.m_7527_();
    }
}

