/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.mappers;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.mapper.EMCMapper;
import moze_intel.projecte.api.mapper.IEMCMapper;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.nss.NSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import moze_intel.projecte.config.CustomEMCParser;
import net.minecraft.server.ServerResources;
import net.minecraft.server.packs.resources.ResourceManager;

@EMCMapper
public class CustomEMCMapper
implements IEMCMapper<NormalizedSimpleStack, Long> {
    @Override
    public void addMappings(IMappingCollector<NormalizedSimpleStack, Long> mapper, CommentedFileConfig config, ServerResources dataPackRegistries, ResourceManager resourceManager) {
        for (CustomEMCParser.CustomEMCEntry entry : CustomEMCParser.currentEntries.entries) {
            PECore.debugLog("Adding custom EMC value for {}: {}", entry.item, entry.emc);
            mapper.setValueBefore(entry.item, entry.emc);
            NormalizedSimpleStack normalizedSimpleStack2 = entry.item;
            if (!(normalizedSimpleStack2 instanceof NSSTag)) continue;
            NSSTag nssTag = (NSSTag)normalizedSimpleStack2;
            nssTag.forEachElement(normalizedSimpleStack -> mapper.setValueBefore((NormalizedSimpleStack)normalizedSimpleStack, entry.emc));
        }
    }

    @Override
    public String getName() {
        return "CustomEMCMapper";
    }

    @Override
    public String getDescription() {
        return "Uses the `custom_emc.json` File to add EMC values.";
    }
}

