/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.network.packets.to_client.SyncFuelMapperPKT;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class FuelMapper {
    private static final List<Item> FUEL_MAP = new ArrayList<Item>();
    private static final ResourceLocation FUEL_TAG = PECore.rl("collector_fuel");

    public static void loadMap(TagContainer tagCollectionSupplier) {
        FUEL_MAP.clear();
        Tag collectorFuelTag = tagCollectionSupplier.m_144452_(Registry.f_122904_).m_7689_(FUEL_TAG);
        collectorFuelTag.m_6497_().stream().filter(EMCHelper::doesItemHaveEmc).forEach(FUEL_MAP::add);
        FUEL_MAP.sort(Comparator.comparing(EMCHelper::getEmcValue));
    }

    public static void setFuelMap(List<Item> map) {
        FUEL_MAP.clear();
        FUEL_MAP.addAll(map);
    }

    public static SyncFuelMapperPKT getSyncPacket() {
        return new SyncFuelMapperPKT(FUEL_MAP);
    }

    public static boolean isStackFuel(ItemStack stack) {
        return FUEL_MAP.contains(stack.m_41720_());
    }

    public static boolean isStackMaxFuel(ItemStack stack) {
        return FUEL_MAP.indexOf(stack.m_41720_()) == FUEL_MAP.size() - 1;
    }

    public static ItemStack getFuelUpgrade(ItemStack stack) {
        int index = FUEL_MAP.indexOf(stack.m_41720_());
        if (index == -1) {
            PECore.LOGGER.warn("Tried to upgrade invalid fuel: {}", (Object)stack);
            return ItemStack.f_41583_;
        }
        int nextIndex = index == FUEL_MAP.size() - 1 ? 0 : index + 1;
        return new ItemStack((ItemLike)FUEL_MAP.get(nextIndex));
    }

    public static List<Item> getFuelMap() {
        return Collections.unmodifiableList(FUEL_MAP);
    }
}

