/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.capability.managing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.capability.managing.ICapabilityResolver;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BasicCapabilityResolver<CAPABILITY>
implements ICapabilityResolver<CAPABILITY> {
    private final NonNullSupplier<CAPABILITY> supplier;
    private LazyOptional<CAPABILITY> cachedCapability;

    public static ICapabilityResolver<IItemHandler> getBasicItemHandlerResolver(NonNullSupplier<IItemHandler> supplier) {
        return new BasicCapabilityResolver<IItemHandler>(supplier){

            @Override
            @Nonnull
            public Capability<IItemHandler> getMatchingCapability() {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }
        };
    }

    public static ICapabilityResolver<IItemHandler> getBasicItemHandlerResolver(IItemHandler handler) {
        return new BasicCapabilityResolver<IItemHandler>(handler){

            @Override
            @Nonnull
            public Capability<IItemHandler> getMatchingCapability() {
                return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
            }
        };
    }

    protected BasicCapabilityResolver(CAPABILITY constant) {
        this.supplier = () -> constant;
    }

    protected BasicCapabilityResolver(NonNullSupplier<CAPABILITY> supplier) {
        this.supplier = supplier instanceof NonNullLazy ? supplier : NonNullLazy.of(supplier);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapabilityUnchecked(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.cachedCapability == null || !this.cachedCapability.isPresent()) {
            this.cachedCapability = LazyOptional.of(this.supplier);
        }
        return this.cachedCapability.cast();
    }

    @Override
    public void invalidate(@Nonnull Capability<?> capability, @Nullable Direction side) {
        this.invalidateAll();
    }

    @Override
    public void invalidateAll() {
        if (this.cachedCapability != null && this.cachedCapability.isPresent()) {
            this.cachedCapability.invalidate();
            this.cachedCapability = null;
        }
    }
}

