/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class NSSItem
extends AbstractNBTNSSTag<Item> {
    private NSSItem(@Nonnull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundTag nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        if (stack.m_41763_() && stack.m_41782_() && stack.m_41784_().equals((Object)new ItemStack((ItemLike)stack.m_41720_()).m_41783_())) {
            return NSSItem.createItem((ItemLike)stack.m_41720_(), null);
        }
        return NSSItem.createItem((ItemLike)stack.m_41720_(), stack.m_41783_());
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ItemLike itemProvider) {
        return NSSItem.createItem(itemProvider, null);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ItemLike itemProvider, @Nullable CompoundTag nbt) {
        Item item = itemProvider.m_5456_();
        if (item == Items.f_41852_) {
            throw new IllegalArgumentException("Can't make NSSItem with empty stack");
        }
        return NSSItem.createItem(item.getRegistryName(), nbt);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ResourceLocation itemID) {
        return NSSItem.createItem(itemID, null);
    }

    @Nonnull
    public static NSSItem createItem(@Nonnull ResourceLocation itemID, @Nullable CompoundTag nbt) {
        return new NSSItem(itemID, false, nbt);
    }

    @Nonnull
    public static NSSItem createTag(@Nonnull ResourceLocation tagId) {
        return new NSSItem(tagId, true, null);
    }

    @Nonnull
    public static NSSItem createTag(@Nonnull Tag<Item> tag) {
        ResourceLocation tagLocation = SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_7473_(tag);
        if (tagLocation == null) {
            throw new IllegalArgumentException("Can't make NSSItem with a tag that does not exist");
        }
        return NSSItem.createTag(tagLocation);
    }

    @Override
    protected boolean isInstance(AbstractNSSTag<?> o) {
        return o instanceof NSSItem;
    }

    @Override
    @Nonnull
    public String getJsonPrefix() {
        return "";
    }

    @Override
    @Nonnull
    public String getType() {
        return "Item";
    }

    @Override
    @Nonnull
    protected TagCollection<Item> getTagCollection() {
        return SerializationTags.m_13199_().m_144452_(Registry.f_122904_);
    }

    @Override
    protected Function<Item, NormalizedSimpleStack> createNew() {
        return NSSItem::createItem;
    }
}

