/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.AbstractNBTNSSTag;
import moze_intel.projecte.api.nss.AbstractNSSTag;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public final class NSSFluid
extends AbstractNBTNSSTag<Fluid> {
    private NSSFluid(@Nonnull ResourceLocation resourceLocation, boolean isTag, @Nullable CompoundTag nbt) {
        super(resourceLocation, isTag, nbt);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull FluidStack stack) {
        return NSSFluid.createFluid(stack.getFluid(), stack.getTag());
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull Fluid fluid) {
        return NSSFluid.createFluid(fluid, null);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull Fluid fluid, @Nullable CompoundTag nbt) {
        if (fluid == Fluids.f_76191_) {
            throw new IllegalArgumentException("Can't make NSSFluid with an empty fluid");
        }
        return NSSFluid.createFluid(fluid.getRegistryName(), nbt);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull ResourceLocation fluidID) {
        return NSSFluid.createFluid(fluidID, null);
    }

    @Nonnull
    public static NSSFluid createFluid(@Nonnull ResourceLocation fluidID, @Nullable CompoundTag nbt) {
        return new NSSFluid(fluidID, false, nbt);
    }

    @Nonnull
    public static NSSFluid createTag(@Nonnull ResourceLocation tagId) {
        return new NSSFluid(tagId, true, null);
    }

    @Nonnull
    public static NSSFluid createTag(@Nonnull Tag<Fluid> tag) {
        ResourceLocation tagLocation = SerializationTags.m_13199_().m_144452_(Registry.f_122899_).m_7473_(tag);
        if (tagLocation == null) {
            throw new IllegalArgumentException("Can't make NSSFluid with a tag that does not exist");
        }
        return NSSFluid.createTag(tagLocation);
    }

    @Override
    protected boolean isInstance(AbstractNSSTag<?> o) {
        return o instanceof NSSFluid;
    }

    @Override
    @Nonnull
    public String getJsonPrefix() {
        return "FLUID|";
    }

    @Override
    @Nonnull
    public String getType() {
        return "Fluid";
    }

    @Override
    @Nonnull
    protected TagCollection<Fluid> getTagCollection() {
        return SerializationTags.m_13199_().m_144452_(Registry.f_122899_);
    }

    @Override
    protected Function<Fluid, NormalizedSimpleStack> createNew() {
        return NSSFluid::createFluid;
    }
}

