/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.nss;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;

public final class NSSFake
implements NormalizedSimpleStack {
    private static String currentNamespace = "";
    private final String namespace;
    private final String description;

    private NSSFake(String namespace, String description) {
        this.namespace = namespace;
        this.description = description;
    }

    public static void resetNamespace() {
        NSSFake.setCurrentNamespace("");
    }

    public static void setCurrentNamespace(@Nonnull String ns) {
        currentNamespace = ns;
    }

    @Nonnull
    public static NormalizedSimpleStack create(String description) {
        return new NSSFake(currentNamespace, description);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NSSFake)) return false;
        NSSFake fake = (NSSFake)o;
        if (!this.description.equals(fake.description)) return false;
        if (!this.namespace.equals(fake.namespace)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namespace, this.description});
    }

    @Override
    public String json() {
        return "FAKE|" + this.description;
    }

    @Override
    public String toString() {
        return "NSSFAKE:" + this.namespace + "/" + this.description;
    }
}

