/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.data.ConversionBuilder;
import moze_intel.projecte.api.nss.NSSFake;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
interface ConversionBuilderNSSHelper<BUILDER extends ConversionBuilder<BUILDER>> {
    public BUILDER ingredient(NormalizedSimpleStack var1, int var2);

    default public BUILDER ingredient(NormalizedSimpleStack input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(ItemStack input) {
        return this.ingredient(NSSItem.createItem(input), input.m_41613_());
    }

    default public BUILDER ingredient(ItemLike input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(ItemLike input, int amount) {
        return this.ingredient(NSSItem.createItem(input), amount);
    }

    default public BUILDER ingredient(Tag<Item> input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(Tag<Item> input, int amount) {
        return this.ingredient(NSSItem.createTag(input), amount);
    }

    default public BUILDER ingredient(FluidStack input) {
        return this.ingredient(NSSFluid.createFluid(input), input.getAmount());
    }

    default public BUILDER ingredient(Fluid input) {
        return this.ingredient(input, 1);
    }

    default public BUILDER ingredient(Fluid input, int amount) {
        return this.ingredient(NSSFluid.createFluid(input), amount);
    }

    default public BUILDER ingredientFluid(Tag<Fluid> input) {
        return this.ingredientFluid(input, 1);
    }

    default public BUILDER ingredientFluid(Tag<Fluid> input, int amount) {
        return this.ingredient(NSSFluid.createTag(input), amount);
    }

    default public BUILDER ingredient(String fake) {
        return this.ingredient(fake, 1);
    }

    default public BUILDER ingredient(String fake, int amount) {
        return this.ingredient(NSSFake.create(fake), amount);
    }
}

