/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import moze_intel.projecte.api.nss.NSSItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemInfo {
    @Nonnull
    private final Item item;
    @Nullable
    private final CompoundTag nbt;

    private ItemInfo(@Nonnull Item item, @Nullable CompoundTag nbt) {
        this.item = item;
        this.nbt = nbt != null && nbt.m_128456_() ? null : nbt;
    }

    public static ItemInfo fromItem(@Nonnull Item item, @Nullable CompoundTag nbt) {
        return new ItemInfo(item, nbt);
    }

    public static ItemInfo fromItem(@Nonnull Item item) {
        return ItemInfo.fromItem(item, null);
    }

    public static ItemInfo fromStack(@Nonnull ItemStack stack) {
        return ItemInfo.fromItem(stack.m_41720_(), stack.m_41783_());
    }

    @Nullable
    public static ItemInfo fromNSS(@Nonnull NSSItem stack) {
        if (stack.representsTag()) {
            return null;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(stack.getResourceLocation());
        if (item == null) {
            return null;
        }
        return ItemInfo.fromItem(item, stack.getNBT());
    }

    @Nullable
    public static ItemInfo read(@Nonnull CompoundTag nbt) {
        if (nbt.m_128425_("item", 8)) {
            ResourceLocation registryName = ResourceLocation.m_135820_((String)nbt.m_128461_("item"));
            if (registryName == null) {
                return null;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
            if (item == null) {
                return null;
            }
            if (nbt.m_128425_("nbt", 10)) {
                return ItemInfo.fromItem(item, nbt.m_128469_("nbt"));
            }
            return ItemInfo.fromItem(item, null);
        }
        return null;
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    @Nullable
    public CompoundTag getNBT() {
        return this.nbt == null ? null : this.nbt.m_6426_();
    }

    public boolean hasNBT() {
        return this.nbt != null;
    }

    public ItemStack createStack() {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        CompoundTag nbt = this.getNBT();
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public CompoundTag write(@Nonnull CompoundTag nbt) {
        nbt.m_128359_("item", this.item.getRegistryName().toString());
        if (this.nbt != null) {
            nbt.m_128365_("nbt", (Tag)this.nbt);
        }
        return nbt;
    }

    public int hashCode() {
        int code = this.item.hashCode();
        if (this.nbt != null) {
            code = 31 * code + this.nbt.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ItemInfo) {
            ItemInfo other = (ItemInfo)o;
            return this.item == other.item && Objects.equals(this.nbt, other.nbt);
        }
        return false;
    }

    public String toString() {
        if (this.nbt != null) {
            return this.item.getRegistryName() + " " + this.nbt;
        }
        return this.item.getRegistryName().toString();
    }
}

