/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.common.plugin;

import dev.kikugie.elytratrims.common.ETReference;
import dev.kikugie.elytratrims.common.config.ServerConfigs;
import dev.kikugie.elytratrims.common.plugin.MixinConfigurable;
import dev.kikugie.elytratrims.common.plugin.ModStatus;
import dev.kikugie.elytratrims.common.plugin.RequireMod;
import dev.kikugie.elytratrims.common.plugin.RequirePlatform;
import dev.kikugie.elytratrims.common.plugin.RequireTest;
import dev.kikugie.elytratrims.common.plugin.Tester;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class ETMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        ServerConfigs.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (this.shouldApply(mixinClassName)) {
            return true;
        }
        String shortName = StringUtils.substringAfter((String)mixinClassName, (String)"mixin.");
        if (!shortName.startsWith("compat.")) {
            ETReference.LOGGER.info("Disabled mixin %s".formatted(shortName));
        }
        return false;
    }

    private boolean shouldApply(String mixin) {
        boolean bl;
        boolean testerResult;
        boolean modResult;
        boolean configResult;
        AnnotationNode mixinConfigurable = this.getAnnotation(mixin, MixinConfigurable.class);
        boolean bl2 = configResult = mixinConfigurable == null || !ServerConfigs.getMixinConfig().contains(mixin);
        if (!configResult) {
            return false;
        }
        AnnotationNode modRequirement = this.getAnnotation(mixin, RequireMod.class);
        boolean bl3 = modResult = modRequirement == null || ModStatus.isLoading((String)Annotations.getValue((AnnotationNode)modRequirement));
        if (!modResult) {
            return false;
        }
        AnnotationNode testerRequirement = this.getAnnotation(mixin, RequireTest.class);
        boolean bl4 = testerResult = testerRequirement == null || this.runTester((Type)Annotations.getValue((AnnotationNode)testerRequirement), mixin);
        if (!testerResult) {
            return false;
        }
        AnnotationNode platformRequirement = this.getAnnotation(mixin, RequirePlatform.class);
        if (platformRequirement == null) {
            return true;
        }
        RequirePlatform.Loader loader = (RequirePlatform.Loader)((Object)Annotations.getValue((AnnotationNode)platformRequirement));
        if (loader == RequirePlatform.Loader.FABRIC) {
            bl = true;
        } else {
            if (loader == RequirePlatform.Loader.FORGE) {
                // empty if block
            }
            bl = false;
        }
        return bl;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private boolean runTester(Type type, String mixinClassName) {
        try {
            Class<?> clazz = Class.forName(type.getClassName());
            if (clazz.isInterface()) {
                ETReference.LOGGER.error("Tester class {} should be implemented", (Object)clazz.getName());
                return false;
            }
            Tester tester = (Tester)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            return tester.test(mixinClassName);
        }
        catch (Exception e) {
            ETReference.LOGGER.error("Failed to instantiate tester from class {}: {}", (Object)type.getClassName(), (Object)e);
            return false;
        }
    }

    @Nullable
    private AnnotationNode getAnnotation(String className, Class<? extends Annotation> annotation) {
        try {
            ClassNode classNode = MixinService.getService().getBytecodeProvider().getClassNode(className);
            return Annotations.getVisible((ClassNode)classNode, annotation);
        }
        catch (IOException | ClassNotFoundException e) {
            return null;
        }
    }
}

