/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.kikugie.elytratrims.common.ETReference;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;

public class ConfigLoader {
    public static <T> T load(Path file, Codec<T> codec, Supplier<T> provider) throws IOException {
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            T newConfig = provider.get();
            ConfigLoader.save(file, codec, newConfig);
            return newConfig;
        }
        try {
            JsonElement json = JsonParser.parseReader((Reader)Files.newBufferedReader(file));
            return (T)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(true, $ -> {})).getFirst();
        }
        catch (Exception e) {
            ETReference.LOGGER.warn("Failed to read config: " + e);
            T newConfig = provider.get();
            ConfigLoader.save(file, codec, newConfig);
            return newConfig;
        }
    }

    public static <T> void save(Path file, Codec<T> codec, T instance) {
        try {
            DataResult result = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance);
            Files.writeString(file, (CharSequence)((JsonElement)result.getOrThrow(false, e -> {})).toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e2) {
            ETReference.LOGGER.warn("Failed to save config to %s:\n%s".formatted(file, e2));
        }
    }
}

