/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.resource;

import com.google.common.base.Preconditions;
import dev.kikugie.elytratrims.common.ETReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7958;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageUtils {
    public static <T extends Supplier<class_7764>> Collection<T> transform(Collection<T> contents, UnaryOperator<class_7764> operator) {
        ArrayList<Supplier<class_7764>> result = new ArrayList<Supplier<class_7764>>(contents.size());
        for (Supplier func : contents) {
            if (func == null) continue;
            result.add(() -> ImageUtils.lambda$transform$0(operator, (Supplier)func));
        }
        return result;
    }

    public static class_7764 createContents(class_1011 image, class_2960 id) {
        return new class_7764(id, new class_7771(image.method_4307(), image.method_4323()), image, class_1079.field_21768);
    }

    @Nullable
    public static class_7764 mask(@Nullable class_7764 image, class_7958 mask) {
        if (image == null || ImageUtils.isMissing(image)) {
            return null;
        }
        if (image.method_45818() != null) {
            ETReference.LOGGER.warn("Cannot mask animated texture {}", (Object)image.method_45816());
            return null;
        }
        class_1011 masked = ImageUtils.applyMask(image, mask);
        if (masked == null) {
            return null;
        }
        class_7764 newContents = ImageUtils.createContents(masked, image.method_45816());
        image.close();
        return newContents;
    }

    @Nullable
    private static class_1011 applyMask(class_7764 image, class_7958 mask) {
        try {
            class_3545<class_1011, class_1011> scaled = ImageUtils.matchScale(image.field_40539, ImageUtils.copy(mask.method_47697()), image.method_45816(), mask.field_41416);
            if (scaled == null) {
                return null;
            }
            class_1011 masked = (class_1011)scaled.method_15442();
            class_1011 maskImg = (class_1011)scaled.method_15441();
            for (int y = 0; y < masked.method_4323(); ++y) {
                for (int x = 0; x < masked.method_4307(); ++x) {
                    int alpha = maskImg.method_4315(x, y) >> 24 & 0xFF;
                    if (alpha != 0) continue;
                    masked.method_4305(x, y, 0);
                }
            }
            return masked;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_1011 createSaturationMaskNotClosing(class_7958 sprite) {
        try {
            class_1011 image = sprite.method_47697();
            int maxSaturation = 0;
            for (int y = 0; y < image.method_4323(); ++y) {
                for (int x = 0; x < image.method_4307(); ++x) {
                    int color = image.method_4315(x, y);
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    int alpha = color >> 24 & 0xFF;
                    if (alpha == 0) continue;
                    maxSaturation = Math.max(maxSaturation, Math.max(red, Math.max(green, blue)));
                }
            }
            int saturationDiff = 255 - maxSaturation;
            class_1011 masked = new class_1011(image.method_4307(), image.method_4323(), true);
            for (int y = 0; y < image.method_4323(); ++y) {
                for (int x = 0; x < image.method_4307(); ++x) {
                    int color = image.method_4315(x, y);
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    int saturation = Math.max(red, Math.max(green, blue)) + saturationDiff;
                    masked.method_4305(x, y, color & 0xFF000000 | saturation << 16 | saturation << 8 | saturation);
                }
            }
            return masked;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class_1011 offsetNotClosing(class_1011 source, int dx, int dy, int width, int height) {
        class_1011 offset = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                try {
                    offset.method_4305(x + dx, y + dy, source.method_4315(x, y));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return offset;
    }

    @Nullable
    public static class_3545<class_1011, class_1011> matchScale(class_1011 img1, class_1011 img2, class_2960 id1, class_2960 id2) {
        float xScale = (float)img1.method_4307() / (float)img2.method_4307();
        float yScale = (float)img1.method_4323() / (float)img2.method_4323();
        if (!ImageUtils.isPowerOf2(xScale) || !ImageUtils.isPowerOf2(yScale)) {
            ETReference.LOGGER.error("Image scale ratio is not a power of 2 for image {} and mask {}", (Object)id1, (Object)id2);
            return null;
        }
        if ((int)xScale != (int)yScale) {
            ETReference.LOGGER.error("Image scale ratio is not equal for image {} and mask {}", (Object)id1, (Object)id2);
            return null;
        }
        class_3545 result = xScale == 1.0f ? new class_3545((Object)ImageUtils.copy(img1), (Object)ImageUtils.copy(img2)) : (xScale > 1.0f ? new class_3545((Object)ImageUtils.copy(img1), (Object)ImageUtils.upscale(img2, (int)xScale)) : new class_3545((Object)ImageUtils.upscale(img1, img2.method_4307() / img1.method_4307()), (Object)ImageUtils.copy(img2)));
        img1.close();
        img2.close();
        return result;
    }

    private static class_1011 upscale(@NotNull class_1011 image, int scale) {
        Preconditions.checkArgument((scale > 0 ? 1 : 0) != 0, (Object)"Scale must be greater than 0");
        int width = image.method_4307() * scale;
        int height = image.method_4323() * scale;
        class_1011 scaled = new class_1011(width, height, true);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = image.method_4315(x / scale, y / scale);
                scaled.method_4305(x, y, color);
            }
        }
        image.close();
        return scaled;
    }

    public static class_1011 outlineNotClosing(class_1011 source, int color) {
        class_1011 outline = new class_1011(source.method_4307(), source.method_4323(), true);
        for (int y = 0; y < source.method_4323(); ++y) {
            for (int x = 0; x < source.method_4307(); ++x) {
                int sourceColor = source.method_4315(x, y);
                if ((sourceColor >> 24 & 0xFF) == 0 || ImageUtils.getColorSafe(source, x - 1, y) != 0 && ImageUtils.getColorSafe(source, x + 1, y) != 0 && ImageUtils.getColorSafe(source, x, y - 1) != 0 && ImageUtils.getColorSafe(source, x, y + 1) != 0) continue;
                outline.method_4305(x, y, color);
            }
        }
        return outline;
    }

    private static int getColorSafe(class_1011 image, int x, int y) {
        if (x < 0 || y < 0 || x >= image.method_4307() || y >= image.method_4323()) {
            return 0;
        }
        return image.method_4315(x, y);
    }

    public static class_1011 dims(class_1011 source, int width, int height) {
        class_1011 dims = new class_1011(width, height, true);
        int xMax = Math.min(source.method_4307(), width);
        int yMax = Math.min(source.method_4323(), height);
        for (int y = 0; y < yMax; ++y) {
            for (int x = 0; x < xMax; ++x) {
                dims.method_4305(x, y, source.method_4315(x, y));
            }
        }
        source.close();
        return dims;
    }

    public static class_1011 copy(class_1011 source) {
        class_1011 copy = new class_1011(source.method_4307(), source.method_4323(), true);
        copy.method_4317(source);
        return copy;
    }

    private static boolean isPowerOf2(float n) {
        return Float.floatToIntBits(n) << 9 == 0;
    }

    public static class_7958 loadTexture(class_2960 id, class_3300 resourceManager, int regions) throws FileNotFoundException {
        Optional resource = resourceManager.method_14486(id);
        if (resource.isPresent()) {
            return new class_7958(id, (class_3298)resource.get(), regions);
        }
        ETReference.LOGGER.error("Can't find texture: %s".formatted(id));
        throw new FileNotFoundException();
    }

    public static boolean isMissing(class_7764 sprite) {
        return sprite.method_45816().equals((Object)class_1047.method_4539());
    }

    public static boolean isMissing(class_1058 sprite) {
        return sprite == null || ImageUtils.isMissing(sprite.method_45851());
    }

    private static /* synthetic */ class_7764 lambda$transform$0(UnaryOperator operator, Supplier func) {
        return (class_7764)operator.apply((class_7764)func.get());
    }
}

