/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.resource;

import dev.kikugie.elytratrims.client.access.ElytraSourceAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_7948;
import net.minecraft.class_8066;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ETResourceListener {
    private static TrimEntries trims = new TrimEntries();

    public static void reset() {
        trims = new TrimEntries();
    }

    public static void addTrims(@NotNull List<class_2960> patterns, class_2960 palette, Map<String, class_2960> materials) {
        ArrayList<class_2960> elytraPatterns = new ArrayList<class_2960>(patterns.size());
        for (class_2960 texture : patterns) {
            String path = texture.method_12832();
            if (!path.contains("armor") || path.contains("leggings")) continue;
            elytraPatterns.add(texture.method_45134(it -> it.replaceFirst("armor", "elytra")));
        }
        if (!elytraPatterns.isEmpty()) {
            trims.add(elytraPatterns, palette, materials);
        }
    }

    @NotNull
    public static List<class_7948> getTrims() {
        ArrayList<class_7948> sources = new ArrayList<class_7948>();
        for (class_2960 palette : trims) {
            List<class_2960> textures = trims.getPatterns(palette);
            Map<String, class_2960> materials = trims.getMaterials(palette);
            class_8066 source = new class_8066(textures, palette, materials);
            ((ElytraSourceAccessor)source).elytra_trims$ignoreListener();
            sources.add((class_7948)source);
        }
        return sources;
    }

    private static class TrimEntries
    implements Iterable<class_2960> {
        private final Map<class_2960, Set<class_2960>> paletteToPatterns = new HashMap<class_2960, Set<class_2960>>();
        private final Map<class_2960, Set<Material>> paletteToMaterials = new HashMap<class_2960, Set<Material>>();

        private TrimEntries() {
        }

        public void add(List<class_2960> patterns, class_2960 palette, @NotNull Map<String, class_2960> materials) {
            Set existingPatterns = this.paletteToPatterns.computeIfAbsent(palette, id -> new HashSet());
            existingPatterns.addAll(patterns);
            Set existingMaterials = this.paletteToMaterials.computeIfAbsent(palette, id -> new HashSet());
            materials.forEach((? super K id, ? super V material) -> existingMaterials.add(new Material((String)id, (class_2960)material)));
        }

        @Override
        @NotNull
        public Iterator<class_2960> iterator() {
            return this.paletteToPatterns.keySet().iterator();
        }

        public @Unmodifiable List<class_2960> getPatterns(class_2960 palette) {
            return List.copyOf((Collection)this.paletteToPatterns.get(palette));
        }

        public @Unmodifiable Map<String, class_2960> getMaterials(class_2960 palette) {
            return Map.ofEntries((Map.Entry[])this.paletteToMaterials.get(palette).stream().map(Material::toEntry).toArray(Map.Entry[]::new));
        }
    }

    private record Material(String id, class_2960 path) {
        public Map.Entry<String, class_2960> toEntry() {
            return Map.entry(this.id, this.path);
        }
    }
}

