/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.resource;

import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.client.config.TextureConfig;
import dev.kikugie.elytratrims.client.resource.ETResourceListener;
import dev.kikugie.elytratrims.client.resource.ImageUtils;
import dev.kikugie.elytratrims.client.resource.Textures;
import dev.kikugie.elytratrims.common.ETReference;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1059;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_7654;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7923;
import net.minecraft.class_7947;
import net.minecraft.class_7958;
import org.jetbrains.annotations.NotNull;

public class ETAtlasHolder
implements class_3302 {
    public static final class_2960 TEXTURE = ETReference.id("textures/atlas/elytra_features.png");
    public static final class_2960 ID = ETReference.id("elytra_features");
    private final class_1059 atlas = new class_1059(TEXTURE);
    private boolean ready = false;

    public ETAtlasHolder() {
        class_310.method_1551().method_1531().method_4616(ID, (class_1044)this.atlas);
    }

    public boolean isReady() {
        return this.ready;
    }

    public class_1059 getAtlas() {
        return this.atlas;
    }

    private List<Supplier<class_7764>> getSprites(class_3300 manager) {
        class_7958 elytra;
        try {
            elytra = ImageUtils.loadTexture(Textures.ELYTRA_MODEL, manager, 1);
        }
        catch (FileNotFoundException e) {
            ETReference.LOGGER.error("Failed to load elytra model texture");
            return List.of();
        }
        ArrayList<Supplier<class_7764>> sprites = new ArrayList<Supplier<class_7764>>(this.getTrims(manager, elytra));
        sprites.addAll(this.getPatterns(manager, elytra));
        sprites.add(this.getOverlay(elytra));
        sprites.add(class_1047::method_45805);
        elytra.method_47698();
        return sprites;
    }

    private Collection<Supplier<class_7764>> getTrims(class_3300 manager, class_7958 elytra) {
        List preSources;
        List trimSources = preSources = new class_7947(ETResourceListener.getTrims()).method_47667(manager);
        return ETClient.getConfig().texture.cropTrims.get() != false ? ImageUtils.transform(trimSources, it -> ImageUtils.mask(it, elytra)) : trimSources;
    }

    @NotNull
    private Collection<Supplier<class_7764>> getPatterns(class_3300 manager, class_7958 elytraModel) {
        ArrayList<Supplier<class_7764>> patterns = new ArrayList<Supplier<class_7764>>();
        TextureConfig config = ETClient.getConfig().texture;
        class_7654 finder = new class_7654("textures", ".png");
        for (class_5321 key : class_7923.field_41165.method_42021()) {
            patterns.add(() -> {
                class_1011 pattern;
                class_2960 id = class_2582.method_22536((class_5321)key, (boolean)config.useBannerTextures.get());
                class_2960 texture = finder.method_45112(id);
                try {
                    pattern = ImageUtils.loadTexture(texture, manager, 1).method_47697();
                }
                catch (IOException e) {
                    ETReference.LOGGER.error("Failed to load pattern texture: {}", (Object)id);
                    return null;
                }
                pattern = config.useBannerTextures.get() != false ? ImageUtils.dims(pattern, pattern.method_4307() * 2, pattern.method_4323()) : ImageUtils.dims(pattern, pattern.method_4307(), pattern.method_4323() / 2);
                int scale = pattern.method_4307() / 64;
                int xOffset = (int)((config.useBannerTextures.get() != false ? 35.5f : 34.0f) * (float)scale);
                int yOffset = config.useBannerTextures.get() != false ? (int)((float)scale * 1.5f) : 0;
                class_1011 offset = ImageUtils.offsetNotClosing(pattern, xOffset, yOffset, pattern.method_4307(), pattern.method_4323());
                return ImageUtils.mask(ImageUtils.createContents(offset, id), elytraModel);
            });
        }
        return patterns;
    }

    private Supplier<class_7764> getOverlay(class_7958 elytraModel) {
        return () -> ImageUtils.createContents(ImageUtils.createSaturationMaskNotClosing(elytraModel), elytraModel.field_41416.method_45134(path -> path.replace("textures/", "").replace(".png", "")));
    }

    private CompletableFuture<List<class_7764>> transform(List<Supplier<class_7764>> sprites, Executor executor) {
        return class_7766.method_47664(sprites, (Executor)executor);
    }

    CompletableFuture<class_7766.class_7767> load(class_3300 manager, class_3695 ignoredProfiler, Executor executor) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.ready = false;
            this.atlas.method_4601();
            return this.getSprites(manager);
        }, executor).thenCompose(sprites -> this.transform((List<Supplier<class_7764>>)sprites, executor))).thenApply(sprites -> class_7766.method_45837((class_1059)this.atlas).method_47663(sprites, 0, executor))).thenCompose(class_7766.class_7767::method_45845);
    }

    CompletableFuture<Void> apply(class_7766.class_7767 data, class_3300 ignoredManager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            profiler.method_16065();
            profiler.method_15396("upload");
            ETResourceListener.reset();
            ETClient.getRenderer().resetCache();
            this.atlas.method_45848(data);
            this.ready = true;
            profiler.method_15407();
            profiler.method_16066();
        }, executor);
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 helper, class_3300 manager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return ((CompletableFuture)this.load(manager, loadProfiler, loadExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)helper).method_18352(arg_0))).thenCompose(o -> this.apply((class_7766.class_7767)o, manager, applyProfiler, applyExecutor));
    }
}

