/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.render;

import com.mojang.datafixers.util.Pair;
import dev.kikugie.elytratrims.client.ETClient;
import dev.kikugie.elytratrims.client.access.LivingEntityAccessor;
import dev.kikugie.elytratrims.client.compat.AllTheTrimsCompat;
import dev.kikugie.elytratrims.client.compat.StackableTrimsCompat;
import dev.kikugie.elytratrims.client.config.ETClientConfig;
import dev.kikugie.elytratrims.client.config.RenderConfig;
import dev.kikugie.elytratrims.client.resource.ETAtlasHolder;
import dev.kikugie.elytratrims.client.resource.ImageUtils;
import dev.kikugie.elytratrims.client.resource.Textures;
import dev.kikugie.elytratrims.common.ETServer;
import dev.kikugie.elytratrims.common.access.ElytraOverlaysAccessor;
import dev.kikugie.elytratrims.common.plugin.ModStatus;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2582;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4668;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_563;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_918;

public class ETFeatureRenderer {
    public static final Function<class_2960, class_1921> ELYTRA_LAYER = class_156.method_34866(texture -> class_1921.method_24049((String)"elytra_layer", (class_293)class_290.field_1580, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29411).method_34577((class_4668.class_5939)new class_4668.class_4683(texture, false, false)).method_23615(class_4668.field_21370).method_23603(class_4668.field_21345).method_23608(class_4668.field_21383).method_23611(class_4668.field_21385).method_23607(class_4668.field_22241).method_23616(class_4668.field_21350).method_23617(true)));
    private final ETAtlasHolder holder;
    private final class_1059 atlas;
    private final ETClientConfig config = ETClient.getConfig();
    private Function<class_8053, class_1058> trimGetter;
    private Function<class_6880<class_2582>, class_1058> patternGetter;

    public ETFeatureRenderer() {
        this.holder = ETClient.getAtlasHolder();
        this.atlas = this.holder.getAtlas();
        this.resetCache();
    }

    public void resetCache() {
        this.trimGetter = class_156.method_34866(this::trimSpriteGetter);
        this.patternGetter = class_156.method_34866(this::patternSpriteGetter);
    }

    public void render(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        if (!this.holder.isReady()) {
            return;
        }
        if (!this.cancelRender(RenderConfig.RenderType.GLOW, entity) && ETServer.GLOWING.hasGlow(stack)) {
            light = 0xFF00FF;
        }
        if (!this.renderJebElytra(elytra, matrices, provider, entity, stack, light, alpha)) {
            this.renderElytraOverlay(elytra, matrices, provider, entity, stack, light, alpha);
            this.renderElytraPatterns(elytra, matrices, provider, entity, stack, light, alpha);
        }
        this.renderElytraTrims(elytra, matrices, provider, entity, stack, light, alpha);
    }

    private void renderElytraTrims(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        List trims;
        if (this.cancelRender(RenderConfig.RenderType.TRIMS, entity)) {
            return;
        }
        class_1937 world = entity.method_37908();
        if (ModStatus.isLoaded("stacked_trims")) {
            trims = StackableTrimsCompat.getTrims(world.method_30349(), stack);
        } else {
            Optional optional = class_8053.method_48428((class_5455)world.method_30349(), (class_1799)stack);
            trims = optional.map(List::of).orElseGet(List::of);
        }
        for (class_8053 trim : trims) {
            this.renderTrim(elytra, trim, matrices, provider, entity, stack, light, alpha);
        }
    }

    private void renderElytraPatterns(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        if (this.cancelRender(RenderConfig.RenderType.PATTERNS, entity)) {
            return;
        }
        List<Pair<class_6880<class_2582>, class_1767>> patterns = ((ElytraOverlaysAccessor)stack).elytra_trims$getPatterns();
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<class_6880<class_2582>, class_1767> pair = patterns.get(i);
            class_1058 sprite = this.getPatternSprite((class_6880<class_2582>)((class_6880)pair.getFirst()));
            if (ImageUtils.isMissing(sprite)) continue;
            float[] color = ((class_1767)pair.getSecond()).method_7787();
            class_4588 vertexConsumer = sprite.method_24108(class_918.method_29711((class_4597)provider, (class_1921)ELYTRA_LAYER.apply(ETAtlasHolder.ID), (boolean)false, (boolean)stack.method_7958()));
            elytra.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, color[0], color[1], color[2], alpha);
        }
    }

    private void renderElytraOverlay(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        if (this.cancelRender(RenderConfig.RenderType.COLOR, entity)) {
            return;
        }
        int color = ((ElytraOverlaysAccessor)stack).elytra_trims$getColor();
        if (color != 0) {
            this.renderElytraColor(elytra, matrices, provider, entity, stack, light, color, alpha);
        }
    }

    private boolean renderJebElytra(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        if (this.cancelRender(RenderConfig.RenderType.COLOR, entity)) {
            return true;
        }
        if (((ElytraOverlaysAccessor)stack).elytra_trims$getPatterns().isEmpty() && stack.method_7964().getString().equals("jeb_")) {
            long tick = class_310.method_1551().method_47600() % 360L;
            int color = class_3532.method_15369((float)((float)tick / 360.0f), (float)1.0f, (float)1.0f);
            this.renderElytraColor(elytra, matrices, provider, entity, stack, light, color, alpha);
            return true;
        }
        return false;
    }

    private void renderElytraColor(class_563<?> elytra, class_4587 matrices, class_4597 provider, class_1309 ignoredEntity, class_1799 stack, int light, int color, float alpha) {
        class_1058 sprite = this.getOverlaySprite();
        if (ImageUtils.isMissing(sprite)) {
            return;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        class_4588 vertexConsumer = sprite.method_24108(class_918.method_29711((class_4597)provider, (class_1921)ELYTRA_LAYER.apply(ETAtlasHolder.ID), (boolean)false, (boolean)stack.method_7958()));
        elytra.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, red, green, blue, alpha);
    }

    private void renderTrim(class_563<?> elytra, class_8053 trim, class_4587 matrices, class_4597 provider, class_1309 entity, class_1799 stack, int light, float alpha) {
        if (trim == null) {
            return;
        }
        class_1058 sprite = this.getTrimSprite(trim);
        if (ImageUtils.isMissing(sprite)) {
            if (ModStatus.isLoaded("allthetrims")) {
                AllTheTrimsCompat.renderTrim(this.atlas, elytra, trim, stack, matrices, provider, light, alpha);
                return;
            }
            if (!ETFeatureRenderer.renderMissingTexture(entity)) {
                return;
            }
        }
        class_4588 vertexConsumer = sprite.method_24108(class_918.method_29711((class_4597)provider, (class_1921)ELYTRA_LAYER.apply(ETAtlasHolder.ID), (boolean)false, (boolean)stack.method_7958()));
        elytra.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, alpha);
    }

    public boolean cancelRender(RenderConfig.RenderType type, class_1309 entity) {
        RenderConfig.RenderMode mode = this.config.render.getEffective(type);
        class_746 player = class_310.method_1551().field_1724;
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case RenderConfig.RenderMode.ALL -> false;
            case RenderConfig.RenderMode.NONE -> true;
            case RenderConfig.RenderMode.SELF -> {
                if (entity != player && !ETFeatureRenderer.renderMissingTexture(entity)) {
                    yield true;
                }
                yield false;
            }
            case RenderConfig.RenderMode.OTHERS -> entity == player || ETFeatureRenderer.renderMissingTexture(entity);
        };
    }

    private class_1058 trimSpriteGetter(class_8053 trim) {
        class_1058 darker;
        String material = ((class_8054)trim.method_48431().comp_349()).comp_1208();
        class_2960 identifier = ((class_8056)trim.method_48424().comp_349()).comp_1213().method_45134(path -> "trims/models/elytra/%s_%s".formatted(path, material));
        if (this.config.texture.useDarkerTrim.get().booleanValue() && !ImageUtils.isMissing(darker = this.atlas.method_4608(identifier.method_48331("_darker")))) {
            return darker;
        }
        return this.atlas.method_4608(identifier);
    }

    private class_1058 patternSpriteGetter(class_6880<class_2582> pattern) {
        Optional optional = pattern.method_40230();
        if (optional.isEmpty()) {
            return this.atlas.method_4608(null);
        }
        class_4730 shieldSprite = this.config.texture.useBannerTextures.get() != false ? class_4722.method_33081((class_5321)((class_5321)optional.get())) : class_4722.method_33083((class_5321)((class_5321)optional.get()));
        return this.atlas.method_4608(shieldSprite.method_24147());
    }

    public static boolean renderMissingTexture(class_1309 entity) {
        return ((LivingEntityAccessor)entity).elytra_trims$isGui();
    }

    private class_1058 getTrimSprite(class_8053 trim) {
        return this.trimGetter.apply(trim);
    }

    private class_1058 getPatternSprite(class_6880<class_2582> pattern) {
        return this.patternGetter.apply(pattern);
    }

    private class_1058 getOverlaySprite() {
        return this.atlas.method_4608(Textures.COLOR_OVERLAY);
    }
}

