/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.client.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.kikugie.elytratrims.client.config.option.RenderModeOption;
import net.minecraft.class_2561;
import net.minecraft.class_3542;

public class RenderConfig {
    public static final class_2561 GROUP = class_2561.method_43471((String)"elytratrims.config.category.render");
    public static final Codec<RenderConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RenderMode.CODEC.fieldOf("color").forGetter(it -> it.color.get()), (App)RenderMode.CODEC.fieldOf("patterns").forGetter(it -> it.patterns.get()), (App)RenderMode.CODEC.fieldOf("trims").forGetter(it -> it.trims.get()), (App)RenderMode.CODEC.fieldOf("cape").forGetter(it -> it.cape.get()), (App)RenderMode.CODEC.fieldOf("glow").forGetter(it -> it.glow.get()), (App)RenderMode.CODEC.fieldOf("global").forGetter(it -> it.global.get())).apply((Applicative)instance, RenderConfig::new));
    private final RenderModeOption color;
    private final RenderModeOption patterns;
    private final RenderModeOption trims;
    private final RenderModeOption cape;
    private final RenderModeOption glow;
    private final RenderModeOption global;

    private RenderConfig(RenderMode color, RenderMode patterns, RenderMode trims, RenderMode cape, RenderMode glow, RenderMode global) {
        this.color = new RenderModeOption("type", "color", color);
        this.patterns = new RenderModeOption("type", "patterns", patterns);
        this.trims = new RenderModeOption("type", "trims", trims);
        this.cape = new RenderModeOption("type", "cape", cape);
        this.glow = new RenderModeOption("type", "glow", glow);
        this.global = new RenderModeOption("type", "global", global);
    }

    static RenderConfig create() {
        return new RenderConfig(RenderMode.ALL, RenderMode.ALL, RenderMode.ALL, RenderMode.ALL, RenderMode.ALL, RenderMode.ALL);
    }

    public RenderModeOption get(RenderType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RenderType.COLOR -> this.color;
            case RenderType.PATTERNS -> this.patterns;
            case RenderType.TRIMS -> this.trims;
            case RenderType.CAPE -> this.cape;
            case RenderType.GLOW -> this.glow;
            case RenderType.GLOBAL -> this.global;
        };
    }

    public RenderMode getEffective(RenderType type) {
        RenderMode mode = this.get(type).get();
        return mode.weight < this.global.get().weight ? mode : this.global.get();
    }

    public void set(RenderType type, RenderMode mode) {
        switch (type) {
            case COLOR: {
                this.color.set(mode);
                break;
            }
            case PATTERNS: {
                this.patterns.set(mode);
                break;
            }
            case TRIMS: {
                this.trims.set(mode);
                break;
            }
            case CAPE: {
                this.cape.set(mode);
                break;
            }
            case GLOW: {
                this.glow.set(mode);
                break;
            }
            case GLOBAL: {
                this.global.set(mode);
            }
        }
    }

    public static enum RenderMode implements class_3542
    {
        NONE(0),
        SELF(1),
        OTHERS(1),
        ALL(2);

        public static final Codec<RenderMode> CODEC;
        public final int weight;
        private final String translation;

        private RenderMode(int weight) {
            this.weight = weight;
            this.translation = "elytratrims.config.mode." + this.method_15434();
        }

        public class_2561 getName() {
            return class_2561.method_43471((String)this.translation);
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = class_3542.method_28140(RenderMode::values);
        }
    }

    public static enum RenderType implements class_3542
    {
        COLOR,
        PATTERNS,
        TRIMS,
        CAPE,
        GLOW,
        GLOBAL;


        public String method_15434() {
            return this.name().toLowerCase();
        }
    }
}

