/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import dev.worldgen.tectonic.ConfigHandler;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod(value="tectonic")
public class TectonicForge {
    public TectonicForge() {
        ConfigHandler.load(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::registerDatapack);
    }

    private void registerDatapack(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            String pack = ModList.get().isLoaded("terralith") ? "Terratonic" : "Tectonic";
            Path baseResourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + pack.toLowerCase()});
            Pack baseDataPack = Pack.m_245429_((String)("tectonic/" + pack.toLowerCase()), (Component)Component.m_237113_((String)pack), (boolean)false, path -> new PathPackResources(path, baseResourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            event.addRepositorySource(packConsumer -> packConsumer.accept(baseDataPack));
            if (ConfigHandler.getConfig().legacyMode()) {
                Path legacyResourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/legacy"});
                Pack legacyDataPack = Pack.m_245429_((String)"tectonic/legacy", (Component)Component.m_237113_((String)"legacy"), (boolean)false, path -> new PathPackResources(path, legacyResourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                event.addRepositorySource(packConsumer -> packConsumer.accept(legacyDataPack));
            }
        }
    }
}

