/*
 * Decompiled with CFR 0.152.
 */
package net.guavy.gravestones;

import java.util.ArrayList;
import java.util.Collection;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.loader.api.FabricLoader;
import net.guavy.gravestones.api.GravestonesApi;
import net.guavy.gravestones.block.GravestoneBlock;
import net.guavy.gravestones.block.entity.GravestoneBlockEntity;
import net.guavy.gravestones.compat.TrinketsCompat;
import net.guavy.gravestones.config.GravestoneRetrievalType;
import net.guavy.gravestones.config.GravestonesConfig;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class Gravestones
implements ModInitializer {
    public static final GravestoneBlock GRAVESTONE = new GravestoneBlock((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10253).strength(0.8f, -1.0f));
    public static class_2591<GravestoneBlockEntity> GRAVESTONE_BLOCK_ENTITY;
    public static final ArrayList<GravestonesApi> apiMods;

    public void onInitialize() {
        class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)new class_2960("gravestones", "gravestone"), (Object)((Object)GRAVESTONE));
        GRAVESTONE_BLOCK_ENTITY = (class_2591)class_2378.method_10226((class_2378)class_7923.field_41181, (String)"gravestones:gravestone", (Object)FabricBlockEntityTypeBuilder.create(GravestoneBlockEntity::new, (class_2248[])new class_2248[]{GRAVESTONE}).build(null));
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)new class_2960("gravestones", "gravestone"), (Object)new class_1747((class_2248)GRAVESTONE, new class_1792.class_1793()));
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(entries -> entries.method_45421((class_1935)GRAVESTONE));
        AutoConfig.register(GravestonesConfig.class, GsonConfigSerializer::new);
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            apiMods.add(new TrinketsCompat());
        }
        apiMods.addAll(FabricLoader.getInstance().getEntrypoints("gravestones", GravestonesApi.class));
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, entity) -> {
            if (entity instanceof GravestoneBlockEntity) {
                GravestoneBlockEntity gravestoneBlockEntity = (GravestoneBlockEntity)entity;
                if (player.method_5687(GravestonesConfig.getConfig().mainSettings.minimumOpLevelToLoot) && gravestoneBlockEntity.getGraveOwner() != null && !gravestoneBlockEntity.getGraveOwner().getId().equals(player.method_7334().getId())) {
                    return true;
                }
                if (GravestonesConfig.getConfig().mainSettings.retrievalType != GravestoneRetrievalType.ON_BREAK && gravestoneBlockEntity.getGraveOwner() != null) {
                    return false;
                }
                if (gravestoneBlockEntity.getGraveOwner() != null && GravestonesConfig.getConfig().mainSettings.retrievalType == GravestoneRetrievalType.ON_BREAK && !gravestoneBlockEntity.getGraveOwner().getId().equals(player.method_7334().getId()) && !GravestonesConfig.getConfig().mainSettings.enableGraveLooting) {
                    return false;
                }
            }
            return true;
        });
    }

    public static void placeGrave(class_1937 world, class_243 pos, class_1657 player) {
        if (world.field_9236) {
            return;
        }
        class_2338 blockPos = class_2338.method_49637((double)pos.field_1352, (double)(pos.field_1351 - 1.0), (double)pos.field_1350);
        if (blockPos.method_10264() <= world.method_8597().comp_651()) {
            blockPos = new class_2338(blockPos.method_10263(), world.method_8597().comp_651(), blockPos.method_10260());
        }
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        class_2371 combinedInventory = class_2371.method_10211();
        combinedInventory.addAll((Collection)player.method_31548().field_7547);
        combinedInventory.addAll((Collection)player.method_31548().field_7548);
        combinedInventory.addAll((Collection)player.method_31548().field_7544);
        for (GravestonesApi gravestonesApi : apiMods) {
            combinedInventory.addAll(gravestonesApi.getInventory(player));
        }
        boolean placed = false;
        for (class_2338 gravePos : class_2338.method_25996((class_2338)blockPos.method_10081(new class_2382(0, 1, 0)), (int)5, (int)5, (int)5)) {
            if (!Gravestones.canPlaceGravestone(world, block, gravePos)) continue;
            class_2680 graveState = (class_2680)GRAVESTONE.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)player.method_5735());
            placed = world.method_8501(gravePos, graveState);
            GravestoneBlockEntity gravestoneBlockEntity = new GravestoneBlockEntity(gravePos, graveState);
            gravestoneBlockEntity.setItems((class_2371<class_1799>)combinedInventory);
            gravestoneBlockEntity.setGraveOwner(player.method_7334());
            gravestoneBlockEntity.setXp(player.field_7495);
            world.method_8438((class_2586)gravestoneBlockEntity);
            gravestoneBlockEntity.method_5431();
            block.method_9576(world, blockPos, blockState, player);
            if (GravestonesConfig.getConfig().mainSettings.sendGraveCoordinates) {
                player.method_7353((class_2561)class_2561.method_43469((String)"text.gravestones.grave_coordinates", (Object[])new Object[]{gravePos.method_10263(), gravePos.method_10264(), gravePos.method_10260()}), false);
            }
            System.out.println("[Gravestones] Gravestone spawned at: " + gravePos.method_10263() + ", " + gravePos.method_10264() + ", " + gravePos.method_10260());
            break;
        }
        player.field_7495 = 0;
        player.field_7510 = 0.0f;
        player.field_7520 = 0;
        if (!placed) {
            player.method_31548().method_7388();
        }
    }

    private static boolean canPlaceGravestone(class_1937 world, class_2248 block, class_2338 blockPos) {
        class_2586 blockEntity = world.method_8321(blockPos);
        if (blockEntity != null) {
            return false;
        }
        return blockPos.method_10264() >= world.method_8597().comp_651() && blockPos.method_10264() <= world.method_8597().comp_652() - world.method_8597().comp_651();
    }

    static {
        apiMods = new ArrayList();
    }
}

