/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.ponder;

import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchTileEntity;
import com.railwayteam.railways.mixin_interfaces.IStandardBogeyTEVirtualCoupling;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.ParrotElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.ponder.instruction.PonderInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import java.util.Optional;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2269;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

public class TrainScenes {
    public static void signaling(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("train_semaphore", "Visualizing Signal states using Semaphores");
        scene.configureBasePlate(1, 0, 15);
        scene.scaleSceneView(0.5f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        for (int i = 16; i >= 0; --i) {
            scene.world.showSection(util.select.position(i, 1, 7), class_2350.field_11033);
            scene.world.showSection(util.select.position(i, 1, 15 - i), class_2350.field_11033);
            scene.idle(1);
        }
        scene.world.toggleControls(util.grid.at(13, 3, 7));
        scene.world.toggleControls(util.grid.at(13, 3, 1));
        scene.world.toggleControls(util.grid.at(13, 3, 4));
        class_2338 signal1 = new class_2338(12, 1, 10);
        class_2338 signal2 = new class_2338(9, 1, 2);
        class_2338 signal3 = new class_2338(7, 1, 12);
        class_2338 signal4 = new class_2338(4, 1, 4);
        class_2338 semaphore1a = new class_2338(12, 4, 10);
        class_2338 semaphore1b = new class_2338(12, 6, 10);
        class_2338 semaphore2a = new class_2338(9, 4, 2);
        class_2338 semaphore2b = new class_2338(9, 6, 2);
        class_2338 semaphore3 = new class_2338(7, 2, 12);
        class_2338 semaphore4 = new class_2338(4, 4, 4);
        Selection train1 = util.select.fromTo(11, 2, 6, 15, 3, 8);
        Selection train2 = util.select.fromTo(15, 2, 3, 11, 3, 5);
        Selection train3 = util.select.fromTo(11, 2, 0, 15, 3, 2);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal1), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal2), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal3), class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(util.select.position(signal4), class_2350.field_11033);
        scene.world.replaceBlocks(util.select.position(semaphore1a.method_10084()), class_2246.field_10124.method_9564(), false);
        scene.idle(15);
        scene.world.showSection(util.select.fromTo(signal1.method_10069(0, 1, 0), signal1.method_10069(0, 2, 0)), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore1a), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(60).pointAt(util.vector.topOf(semaphore1a)).attachKeyFrame().placeNearTarget().text("Semaphores are placed on poles above Train Signals");
        scene.idle(65);
        scene.world.showSection(util.select.fromTo(signal4.method_10069(0, 1, 0), signal4.method_10069(0, 2, 0)), class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(60).pointAt(util.vector.topOf(semaphore4.method_10074())).attachKeyFrame().placeNearTarget().text("Semaphore poles can be made of different materials");
        scene.idle(50);
        scene.world.showSection(util.select.position(semaphore4), class_2350.field_11033);
        scene.idle(10);
        scene.world.replaceBlocks(util.select.position(semaphore2a.method_10084()), class_2246.field_10124.method_9564(), false);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(signal2.method_10069(0, 1, 0), signal2.method_10069(0, 2, 0)), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(semaphore2a), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(signal3.method_10069(0, 1, 0), signal3.method_10069(0, 1, 0)), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(semaphore3), class_2350.field_11033);
        scene.idle(10);
        scene.special.movePointOfInterest(new class_243(0.0, 3.0, 8.0));
        ElementLink trainElement = scene.world.showIndependentSection(train1, null);
        ElementLink birb1 = scene.special.createBirb(util.vector.centerOf(18, 3, 7), ParrotElement.FacePointOfInterestPose::new);
        scene.world.moveSection(trainElement, util.vector.of(4.0, 0.0, 0.0), 0);
        scene.world.moveSection(trainElement, util.vector.of(-9.0, 0.0, 0.0), 30);
        scene.world.animateBogey(util.grid.at(13, 2, 7), 9.0f, 30);
        scene.special.moveParrot(birb1, util.vector.of(-9.0, 0.0, 0.0), 30);
        scene.idle(10);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.effects.indicateRedstone(semaphore1a);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.effects.indicateRedstone(semaphore2a);
        scene.idle(35);
        ElementLink trainElement2 = scene.world.showIndependentSection(train3, null);
        ElementLink birb2 = scene.special.createBirb(util.vector.centerOf(18, 3, 7), ParrotElement.FacePointOfInterestPose::new);
        scene.world.moveSection(trainElement2, util.vector.of(4.0, 0.0, 6.0), 0);
        scene.world.moveSection(trainElement2, util.vector.of(-3.5, 0.0, 0.0), 25);
        scene.world.animateBogey(util.grid.at(13, 2, 1), 3.5f, 25);
        scene.special.moveParrot(birb2, util.vector.of(-3.5, 0.0, 0.0), 25);
        scene.idle(30);
        scene.special.movePointOfInterest(semaphore1a);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Semaphores show the current state of the signal below the pole");
        scene.idle(80);
        scene.special.movePointOfInterest(new class_243(-3.0, 3.0, 8.0));
        scene.idle(5);
        scene.world.moveSection(trainElement, util.vector.of(-10.0, 0.0, 0.0), 35);
        scene.world.animateBogey(util.grid.at(13, 2, 7), 10.0f, 35);
        scene.special.moveParrot(birb1, util.vector.of(-10.0, 0.0, 0.0), 35);
        scene.idle(5);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.RED);
        scene.idle(5);
        scene.world.hideIndependentSection(trainElement, null);
        scene.special.hideElement(birb1, null);
        scene.idle(10);
        scene.world.moveSection(trainElement2, util.vector.of(-11.5, 0.0, 0.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 1), 11.5f, 40);
        scene.special.moveParrot(birb2, util.vector.of(-11.5, 0.0, 0.0), 40);
        scene.idle(3);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.idle(5);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.GREEN);
        scene.idle(20);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal4, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.special.movePointOfInterest(signal1);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(signal1, class_2350.field_11034), Pointing.RIGHT).rightClick().withWrench(), 40);
        scene.idle(6);
        scene.world.cycleBlockProperty(signal1, (class_2769)SignalBlock.TYPE);
        scene.idle(15);
        float pY = 0.1875f;
        scene.overlay.showText(60).pointAt(util.vector.blockSurface(signal1, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("If a brass signal has multiple valid exit paths...");
        scene.idle(70);
        class_243 m1 = util.vector.topOf(12, 0, 7).method_1031(0.0, (double)pY, 0.0);
        class_243 m2 = util.vector.topOf(4, 0, 7).method_1031(0.0, (double)pY, 0.0);
        class_243 m3 = util.vector.topOf(12, 0, 3).method_1031(0.0, (double)pY, 0.0);
        class_243 m4 = util.vector.topOf(5, 0, 10).method_1031(0.0, (double)pY, 0.0);
        class_243 c1 = util.vector.topOf(8, 0, 7).method_1031(0.0, (double)pY, 0.0);
        class_238 bb = new class_238(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.method_1009((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        class_238 bb2 = bb.method_989(-0.45, 0.0, 0.0);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.method_1031(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.method_1031(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.method_1031(0.45, 0.0, -0.45), c1, 10);
        scene.idle(20);
        scene.special.movePointOfInterest(semaphore1a);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("... a second semaphore can be placed above the first");
        scene.idle(50);
        scene.world.restoreBlocks(util.select.position(semaphore1a.method_10084()));
        scene.world.showSection(util.select.position(semaphore1b.method_10074()), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore1b), class_2350.field_11033);
        scene.idle(30);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(semaphore1a, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("The bottom semaphore will now close if any of the available paths are blocked");
        scene.idle(70);
        bb2 = new class_238(new class_2338((class_2382)semaphore1a)).method_1009(-0.25, 0.0, -0.25);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new class_238(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.method_1009((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.method_1031(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.method_1031(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.method_1031(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.RED, m2.method_1031(0.45, 0.0, 0.0), m1.method_1031(-0.45, 0.0, 0.0), 30);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.YELLOW);
        scene.special.movePointOfInterest(semaphore1b);
        scene.idle(30);
        scene.overlay.showText(60).pointAt(util.vector.blockSurface(semaphore1b, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("The top semaphore will close if all paths are blocked");
        scene.idle(60);
        bb2 = new class_238(new class_2338((class_2382)semaphore1b)).method_1009(-0.25, 0.0, -0.25);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new class_238(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.method_1009((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.method_1031(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.method_1031(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.method_1031(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.GREEN, c1, m1.method_1031(-0.45, 0.0, 0.0), 30);
        scene.overlay.showBigLine(PonderPalette.GREEN, m4.method_1031(0.45, 0.0, -0.45), c1, 30);
        scene.idle(30);
        ElementLink trainElement3 = scene.world.showIndependentSection(train2, null);
        scene.world.rotateSection(trainElement3, 0.0, 45.0, 0.0, 0);
        scene.world.moveSection(trainElement3, util.vector.of(4.0, 0.0, -6.0), 0);
        scene.world.moveSection(trainElement3, util.vector.of(-14.0, 0.0, 14.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 4), -14.0f, 40);
        ElementLink birb3 = scene.special.createBirb(util.vector.of(18.0, 3.5, -2.0), ParrotElement.FacePointOfInterestPose::new);
        scene.special.moveParrot(birb3, util.vector.of(-14.0, 0.0, 14.0), 40);
        scene.idle(12);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.GREEN);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.YELLOW);
        scene.world.changeSignalState(signal3, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb2, bb2, 30);
        bb = new class_238(m1, m1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, (Object)bb, bb.method_1009((double)0.45f, 0.0, (double)0.45f), 30);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, c1, m1.method_1031(-0.45, 0.0, 0.0), 20);
        scene.idle(10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m2.method_1031(0.45, 0.0, 0.0), c1, 10);
        scene.overlay.showBigLine(PonderPalette.OUTPUT, m4.method_1031(0.45, 0.0, -0.45), c1, 10);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, (Object)bb2, bb2, 30);
        scene.overlay.showBigLine(PonderPalette.RED, m2.method_1031(0.45, 0.0, 0.0), m1.method_1031(-0.45, 0.0, 0.0), 30);
        scene.overlay.showBigLine(PonderPalette.RED, m4.method_1031(0.45, 0.0, -0.45), c1, 30);
        scene.world.changeSignalState(signal1, SignalBlockEntity.SignalState.RED);
        scene.idle(20);
        scene.special.movePointOfInterest(semaphore2b);
        scene.world.restoreBlocks(util.select.position(semaphore2a.method_10084()));
        scene.world.showSection(util.select.position(semaphore2b.method_10074()), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(semaphore2b), class_2350.field_11033);
        scene.idle(30);
        scene.overlay.showText(80).pointAt(util.vector.blockSurface(semaphore2b, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("When 2 semaphores are placed on a non-brass signal, they both close simultaneously");
        scene.idle(80);
        trainElement = scene.world.showIndependentSection(train1, null);
        scene.world.rotateSection(trainElement, 0.0, 45.0, 0.0, 0);
        scene.world.moveSection(trainElement, util.vector.of(4.0, 0.0, -9.0), 0);
        scene.world.moveSection(trainElement, util.vector.of(-9.0, 0.0, 9.0), 40);
        scene.world.animateBogey(util.grid.at(13, 2, 7), -9.0f, 40);
        birb1 = scene.special.createBirb(util.vector.of(18.0, 3.5, -2.0), ParrotElement.FacePointOfInterestPose::new);
        scene.special.moveParrot(birb1, util.vector.of(-9.0, 0.0, 9.0), 40);
        scene.idle(15);
        scene.world.changeSignalState(signal2, SignalBlockEntity.SignalState.RED);
        scene.idle(10);
    }

    public static void trackSwitch(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("train_switch", "Using Track Switches");
        scene.configureBasePlate(0, 0, 15);
        scene.scaleSceneView(0.45f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        class_2338 switchPos = util.grid.at(4, 1, 1);
        class_2338 switchTargetPos = util.grid.at(7, 1, 1);
        class_2338 straightEndPos = util.grid.at(7, 1, 12);
        class_2338 leftButtonPos = util.grid.at(5, 1, 1);
        class_2338 straightButtonPos = util.grid.at(4, 1, 0);
        class_2338 rightButtonPos = util.grid.at(3, 1, 1);
        final class_2338 comparatorPos = util.grid.at(4, 1, 2);
        final class_2338 redstonePos = util.grid.at(4, 1, 3);
        class_2338 targetPos = util.grid.at(3, 1, 3);
        final class_2338 nixiePos = util.grid.at(3, 2, 3);
        class_2338 trackPos = util.grid.at(7, 1, 0);
        class_2338 leftTrackPos = util.grid.at(12, 1, 12);
        class_2338 leftTrack2Pos = util.grid.at(13, 1, 13);
        class_2338 rightTrackPos = util.grid.at(2, 1, 12);
        class_2338 rightTrack2Pos = util.grid.at(1, 1, 13);
        Selection leftTrack = util.select.position(leftTrackPos);
        Selection leftTrack2 = util.select.position(leftTrack2Pos);
        Selection rightTrack = util.select.position(rightTrackPos);
        Selection rightTrack2 = util.select.position(rightTrack2Pos);
        Selection switchSel = util.select.position(switchPos);
        Selection comparator = util.select.position(comparatorPos);
        Selection redstone = util.select.position(redstonePos);
        Selection targetBlock = util.select.position(targetPos);
        Selection nixie = util.select.position(nixiePos);
        Selection leftButton = util.select.position(leftButtonPos);
        Selection straightButton = util.select.position(straightButtonPos);
        Selection rightButton = util.select.position(rightButtonPos);
        scene.world.showSection(leftTrack, class_2350.field_11033);
        scene.world.showSection(rightTrack, class_2350.field_11033);
        for (int i = 0; i < 15; ++i) {
            scene.world.showSection(util.select.position(7, 1, i), class_2350.field_11033);
            if (i == 1) {
                scene.world.showSection(leftTrack2, class_2350.field_11033);
                scene.world.showSection(rightTrack2, class_2350.field_11033);
            }
            scene.idle(1);
        }
        scene.idle(10);
        class_243 target = util.vector.topOf(switchTargetPos.method_10074());
        class_238 bb = new class_238(target, target).method_989(0.0, 0.125, 0.0);
        scene.overlay.showControls(new InputWindowElement(target, Pointing.DOWN).rightClick().withItem(CRBlocks.ANDESITE_SWITCH.asStack()), 40);
        scene.idle(6);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb.method_1009((double)0.45f, 0.0625, (double)0.45f), 60);
        scene.idle(10);
        scene.overlay.showText(50).pointAt(target).placeNearTarget().colored(PonderPalette.GREEN).text("Select a Train Track then place the Switch nearby");
        scene.idle(20);
        scene.world.showSection(switchSel, class_2350.field_11033);
        TrainScenes.initSwitch(scene, switchPos, new TrackSwitchTileEntity.PonderData(util.vector.topOf(switchTargetPos.method_10074()), util.vector.topOf(leftTrackPos.method_10074()), util.vector.topOf(straightEndPos.method_10074()), util.vector.topOf(rightTrackPos.method_10074())));
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, new class_238(switchPos), 20);
        scene.idle(25);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("The Switch will direct any Trains passing over the marker");
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, class_2350.field_11034), Pointing.RIGHT).rightClick(), 60);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Cycle the switch to the right by using it");
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_RIGHT);
        scene.idle(70);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, class_2350.field_11034), Pointing.RIGHT).rightClick().whileSneaking(), 20);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Cycle the switch to the left by using it while sneaking");
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.NORMAL);
        scene.idle(25);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(switchPos, class_2350.field_11034), Pointing.RIGHT).rightClick().whileSneaking(), 40);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_LEFT);
        scene.idle(45);
        scene.idle(20);
        scene.world.modifyBlock(redstonePos, state -> (class_2680)state.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(1)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> n.updateRedstoneStrength(1));
        scene.world.showSection(comparator, class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(redstone, class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(targetBlock, class_2350.field_11033);
        scene.idle(3);
        scene.world.showSection(nixie, class_2350.field_11033);
        scene.idle(5);
        scene.overlay.showText(90).pointAt(util.vector.blockSurface(comparatorPos, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Switches provide a comparator signal based on the direction: 1 for left, 0 for straight, and 2 for right");
        scene.idle(80);
        scene.world.showSection(leftButton, class_2350.field_11033);
        scene.idle(2);
        scene.world.showSection(straightButton, class_2350.field_11033);
        scene.idle(2);
        scene.world.showSection(rightButton, class_2350.field_11033);
        scene.idle(5);
        scene.idle(20);
        scene.overlay.showText(90).pointAt(util.vector.topOf(rightButtonPos).method_1023(0.0, 0.75, 0.0)).attachKeyFrame().placeNearTarget().text("Switch direction can also be set by a redstone signal, and can be locked by powering the bottom");
        scene.idle(15);
        scene.world.toggleRedstonePower(rightButton);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.REVERSE_RIGHT);
        scene.world.modifyBlock(redstonePos, state -> (class_2680)state.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(2)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> {
            n.updateRedstoneStrength(2);
            n.updateDisplayedStrings();
        });
        scene.idle(30);
        scene.world.toggleRedstonePower(rightButton);
        scene.idle(10);
        scene.world.toggleRedstonePower(straightButton);
        TrainScenes.setSwitchState(scene, switchPos, TrackSwitchBlock.SwitchState.NORMAL);
        scene.world.modifyBlock(redstonePos, state -> (class_2680)state.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(0)), false);
        scene.world.modifyBlockEntity(nixiePos, NixieTubeBlockEntity.class, n -> {
            n.updateRedstoneStrength(0);
            n.updateDisplayedStrings();
        });
        scene.world.toggleRedstonePower(comparator);
        scene.idle(30);
        scene.world.toggleRedstonePower(straightButton);
        scene.idle(20);
        for (int i = 0; i < 3; ++i) {
            scene.world.createEntity(level -> new class_1667((class_1937)level, (double)switchPos.method_10263() + 0.5, 30.0, (double)switchPos.method_10260() + 0.5){

                protected void method_24920(@NotNull class_3965 result) {
                    super.method_24920(result);
                    class_2586 class_25862 = this.field_6002.method_8321(result.method_17777());
                    if (class_25862 instanceof TrackSwitchTileEntity) {
                        TrackSwitchTileEntity switchBE = (TrackSwitchTileEntity)class_25862;
                        switchBE.setStatePonder(switchBE.getState().nextStateForPonder(TrackSwitchBlock.SwitchConstraint.NONE));
                        int output = switchBE.getTargetAnalogOutput();
                        this.field_6002.method_8501(comparatorPos, (class_2680)this.field_6002.method_8320(comparatorPos).method_11657((class_2769)class_2286.field_10911, (Comparable)Boolean.valueOf(output != 0)));
                        this.field_6002.method_8501(redstonePos, (class_2680)this.field_6002.method_8320(redstonePos).method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(output)));
                        class_2586 class_25863 = this.field_6002.method_8321(nixiePos);
                        if (class_25863 instanceof NixieTubeBlockEntity) {
                            NixieTubeBlockEntity nixieBE = (NixieTubeBlockEntity)class_25863;
                            nixieBE.updateRedstoneStrength(output);
                            nixieBE.updateDisplayedStrings();
                        }
                        if ((class_25863 = this.field_6002) instanceof PonderWorld) {
                            PonderWorld ponderWorld = (PonderWorld)class_25863;
                            ponderWorld.scene.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
                        }
                    }
                    this.method_31472();
                }
            });
            scene.idle(20);
            if (i != 0) continue;
            scene.overlay.showText(70).pointAt(util.vector.blockSurface(switchPos, class_2350.field_11039)).attachKeyFrame().placeNearTarget().text("Projectiles also cycle switches on impact");
        }
        scene.idle(60);
    }

    private static void initSwitch(SceneBuilder scene, final class_2338 switchPos, final TrackSwitchTileEntity.PonderData data) {
        scene.addInstruction(new PonderInstruction(){

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchTileEntity> getSwitch(PonderScene scene) {
                class_2586 class_25862 = scene.getWorld().method_8321(switchPos);
                if (class_25862 instanceof TrackSwitchTileEntity) {
                    TrackSwitchTileEntity switchBE = (TrackSwitchTileEntity)class_25862;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = data;
                });
            }
        });
    }

    private static void clearSwitch(SceneBuilder scene, final class_2338 switchPos) {
        scene.addInstruction(new PonderInstruction(){

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchTileEntity> getSwitch(PonderScene scene) {
                class_2586 class_25862 = scene.getWorld().method_8321(switchPos);
                if (class_25862 instanceof TrackSwitchTileEntity) {
                    TrackSwitchTileEntity switchBE = (TrackSwitchTileEntity)class_25862;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    switchBE.ponderData = null;
                });
            }
        });
    }

    private static void setSwitchState(SceneBuilder scene, final class_2338 switchPos, final TrackSwitchBlock.SwitchState state) {
        scene.addInstruction(new PonderInstruction(){
            private TrackSwitchBlock.SwitchState prevState = TrackSwitchBlock.SwitchState.NORMAL;

            public boolean isComplete() {
                return true;
            }

            private Optional<TrackSwitchTileEntity> getSwitch(PonderScene scene) {
                class_2586 class_25862 = scene.getWorld().method_8321(switchPos);
                if (class_25862 instanceof TrackSwitchTileEntity) {
                    TrackSwitchTileEntity switchBE = (TrackSwitchTileEntity)class_25862;
                    return Optional.of(switchBE);
                }
                return Optional.empty();
            }

            public void reset(PonderScene scene) {
                super.reset(scene);
                this.getSwitch(scene).ifPresent(switchBE -> switchBE.setStatePonder(this.prevState));
            }

            public void tick(PonderScene scene) {
                this.getSwitch(scene).ifPresent(switchBE -> {
                    this.prevState = switchBE.getState();
                    switchBE.setStatePonder(state);
                });
            }
        });
    }

    public static void coupling(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("train_coupler", "Using a Coupler");
        scene.configureBasePlate(0, 0, 21);
        scene.scaleSceneView(0.45f);
        scene.showBasePlate();
        for (int i2 = 21; i2 >= 0; --i2) {
            scene.world.showSection(util.select.position(i2, 1, 10), class_2350.field_11033);
            scene.idle(1);
        }
        class_2338 locoLeadingBogeyPos = new class_2338(2, 2, 18);
        class_2338 locoTrailingBogeyPos = new class_2338(5, 2, 18);
        class_2338 cargoBogeyPos = new class_2338(17, 2, 18);
        Selection coupler = util.select.position(10, 1, 7);
        Selection redstoneDust = util.select.position(10, 1, 6);
        Selection button = util.select.position(10, 1, 5);
        Selection station = util.select.position(1, 1, 7);
        class_2338 couplerPad1 = new class_2338(12, 1, 10);
        class_2338 couplerPad1Under = new class_2338(12, 0, 10);
        class_2338 couplerPos = new class_2338(10, 1, 7);
        class_2338 redstoneDustPos = new class_2338(10, 1, 6);
        class_2338 buttonPos = new class_2338(10, 1, 5);
        class_2338 stationPos = new class_2338(1, 1, 7);
        Selection train1 = util.select.fromTo(0, 2, 20, 8, 6, 16);
        Selection train2 = util.select.fromTo(14, 2, 20, 20, 4, 16);
        class_243 couplerPad1TopMarker = util.vector.topOf(couplerPad1Under).method_1031(0.0, 0.1875, 0.0);
        class_243 couplerTop = util.vector.topOf(couplerPos);
        class_243 redstoneDustTop = util.vector.topOf(redstoneDustPos);
        class_243 buttonTop = util.vector.topOf(buttonPos);
        class_243 stationTop = util.vector.topOf(stationPos);
        class_238 bb = new class_238(util.vector.topOf(couplerPad1Under), util.vector.topOf(couplerPad1Under)).method_989(0.0, 0.125, 0.0);
        scene.overlay.showControls(new InputWindowElement(couplerPad1TopMarker, Pointing.DOWN).rightClick().withItem(CRBlocks.TRACK_COUPLER.asStack()), 40);
        scene.idle(6);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, bb.method_1009((double)0.45f, 0.0625, (double)0.45f), 100);
        scene.idle(10);
        scene.overlay.showText(70).pointAt(couplerPad1TopMarker).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("Select a Train Track then place the Coupler nearby");
        scene.idle(60);
        scene.world.showSection(coupler, class_2350.field_11033);
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)bb, new class_238(couplerPos), 20);
        scene.idle(25);
        scene.overlay.showText(100).pointAt(couplerTop).placeNearTarget().attachKeyFrame().text("The Train Coupler lets you couple and decouple trains without disassembling them");
        scene.idle(120);
        scene.overlay.showControls(new InputWindowElement(couplerTop, Pointing.DOWN).scroll().withWrench(), 60);
        scene.overlay.showScrollInput(couplerTop, class_2350.field_11033, 60);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(couplerTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("By scrolling with a wrench you can change the gap between the couple/decouple pads");
        scene.idle(80);
        int delta = 0;
        for (i = 0; i < 11; ++i) {
            boolean back = i > 1 && i < 6;
            TrainScenes.movePlate(scene, util, couplerPos, new class_2338(-3 - delta, 0, 3), i < 7 ? 6 : 2);
            delta += back ? -1 : 1;
        }
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(couplerTop, Pointing.DOWN).rightClick().withWrench(), 60);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(couplerTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("By using a wrench you can cycle between coupling, decoupling, and both modes");
        scene.idle(80);
        for (i = 0; i < 3; ++i) {
            scene.world.modifyBlock(couplerPos, s -> (class_2680)s.method_28493(TrackCouplerBlock.MODE), false);
            scene.idle(15);
        }
        scene.world.showSection(station, class_2350.field_11033);
        scene.idle(5);
        scene.overlay.showText(70).pointAt(stationTop).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("Stations can be used to help align trains for coupling");
        scene.idle(80);
        ElementLink trainElement1 = scene.world.showIndependentSection(train1, class_2350.field_11033);
        ElementLink trainElement2 = scene.world.showIndependentSection(train2, class_2350.field_11033);
        scene.world.moveSection(trainElement1, util.vector.of(20.0, 0.0, -8.0), 0);
        scene.world.moveSection(trainElement2, util.vector.of(15.0, 0.0, -8.0), 0);
        TrainScenes.coupleTrain(scene, cargoBogeyPos, 8.0, class_2350.field_11043);
        scene.world.moveSection(trainElement1, util.vector.of(-20.0, 0.0, 0.0), 50);
        scene.world.moveSection(trainElement2, util.vector.of(-20.0, 0.0, 0.0), 50);
        scene.world.animateBogey(locoLeadingBogeyPos, 20.0f, 50);
        scene.world.animateBogey(locoTrailingBogeyPos, 20.0f, 50);
        scene.world.animateBogey(cargoBogeyPos, 20.0f, 50);
        scene.idle(50);
        scene.world.animateTrainStation(stationPos, true);
        scene.rotateCameraY(20.0f);
        scene.idle(10);
        scene.world.showSection(redstoneDust, class_2350.field_11033);
        scene.idle(1);
        scene.world.showSection(button, class_2350.field_11033);
        scene.idle(20);
        scene.overlay.showText(70).pointAt(buttonTop).placeNearTarget().colored(PonderPalette.RED).attachKeyFrame().text("By powering a coupler you can couple/decouple a properly aligned train");
        scene.idle(80);
        scene.world.modifyBlock(buttonPos, s -> (class_2680)s.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(true)), false);
        scene.world.modifyBlock(redstoneDustPos, s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(15)), false);
        TrainScenes.decoupleTrain(scene, cargoBogeyPos);
        scene.idle(20);
        scene.world.modifyBlock(buttonPos, s -> (class_2680)s.method_11657((class_2769)class_2269.field_10729, (Comparable)Boolean.valueOf(false)), false);
        scene.world.modifyBlock(redstoneDustPos, s -> (class_2680)s.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(0)), false);
        scene.idle(5);
        scene.world.moveSection(trainElement1, util.vector.of(-40.0, 0.0, 0.0), 100);
        scene.world.animateBogey(locoLeadingBogeyPos, 40.0f, 100);
        scene.world.animateBogey(locoTrailingBogeyPos, 40.0f, 100);
        scene.world.animateTrainStation(stationPos, false);
        scene.idle(10);
        scene.rotateCameraY(-20.0f);
    }

    public static void movePlate(SceneBuilder scene, SceneBuildingUtil util, class_2338 couplerPos, class_2338 plate, int idleTicks) {
        scene.world.modifyBlockEntityNBT(util.select.position(couplerPos), TrackCouplerBlockEntity.class, nbt -> nbt.method_10566("SecondaryTargetTrack", (class_2520)class_2512.method_10692((class_2338)plate)));
        scene.idle(idleTicks);
    }

    public static void coupleTrain(SceneBuilder scene, class_2338 pos, double distance, class_2350 direction) {
        scene.addInstruction(PonderInstruction.simple(ponderScene -> {
            PonderWorld world = ponderScene.getWorld();
            world.method_35230(pos, (class_2591)AllBlockEntityTypes.BOGEY.get()).ifPresent(sbte -> {
                if (sbte instanceof IStandardBogeyTEVirtualCoupling) {
                    IStandardBogeyTEVirtualCoupling virtualCoupling = (IStandardBogeyTEVirtualCoupling)sbte;
                    virtualCoupling.setCouplingDistance(distance);
                    virtualCoupling.setCouplingDirection(direction);
                }
            });
        }));
    }

    public static void decoupleTrain(SceneBuilder scene, class_2338 pos) {
        scene.addInstruction(PonderInstruction.simple(ponderScene -> {
            PonderWorld world = ponderScene.getWorld();
            world.method_35230(pos, (class_2591)AllBlockEntityTypes.BOGEY.get()).ifPresent(sbte -> {
                if (sbte instanceof IStandardBogeyTEVirtualCoupling) {
                    IStandardBogeyTEVirtualCoupling virtualCoupling = (IStandardBogeyTEVirtualCoupling)sbte;
                    virtualCoupling.setCouplingDistance(-1.0);
                    virtualCoupling.setCouplingDirection(class_2350.field_11036);
                }
            });
        }));
    }
}

