/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.casing;

import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CasingCollisionUtils {
    private static final Map<TrackMaterial.TrackType, Map<TrackShape, Set<class_2338>>> OFFSETS = new HashMap<TrackMaterial.TrackType, Map<TrackShape, Set<class_2338>>>();

    @Contract(value="_ -> new")
    private static SuperBuilder b(@NotNull TrackMaterial.TrackType trackType) {
        return new SuperBuilder(trackType);
    }

    private static void registerStandard(TrackMaterial.TrackType trackType) {
        CasingCollisionUtils.b(trackType).s(TrackShape.XO).o(0, 1).o(0, -1).build().s(TrackShape.ZO).o(1, 0).o(-1, 0).build().s(TrackShape.PD).o(1, 0).o(1, -1).o(0, 1).o(-1, 1).build().s(TrackShape.ND).o(-1, 0).o(-1, -1).o(0, 1).o(1, 1).build().s(TrackShape.TE).o(0, 1).o(0, -1).build().s(TrackShape.TW).o(0, 1).o(0, -1).build().s(TrackShape.TN).o(1, 0).o(-1, 0).build().s(TrackShape.TS).o(1, 0).o(-1, 0).build().s(TrackShape.CR_O).o(-1, 1).o(0, 1).o(1, 1).o(-1, 0).o(1, 0).o(-1, -1).o(0, -1).o(1, -1).build().s(TrackShape.AE).o(0, 1).o(0, -1).build().s(TrackShape.AW).o(0, 1).o(0, -1).build().s(TrackShape.AN).o(1, 0).o(-1, 0).build().s(TrackShape.AS).o(1, 0).o(-1, 0).build();
    }

    private static void registerWide(TrackMaterial.TrackType trackType) {
        Builder cr_o = CasingCollisionUtils.b(trackType).s(TrackShape.XO).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.ZO).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.PD).o(1, 0).o(1, -1).o(2, -1).o(0, 1).o(-1, 1).o(-1, 2).build().s(TrackShape.ND).o(-1, 0).o(-1, -1).o(-2, -1).o(0, 1).o(1, 1).o(1, 2).build().s(TrackShape.TE).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.TW).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.TN).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.TS).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.AE).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.AW).o(0, 2).o(0, 1).o(0, -1).o(0, -2).build().s(TrackShape.AN).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.AS).o(2, 0).o(1, 0).o(-1, 0).o(-2, 0).build().s(TrackShape.CR_O);
        for (int xOff = -2; xOff <= 2; ++xOff) {
            for (int zOff = -2; zOff <= 2; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                cr_o.o(xOff, zOff);
            }
        }
        cr_o.build();
    }

    public static void register() {
        OFFSETS.clear();
        CasingCollisionUtils.registerStandard(TrackMaterial.TrackType.STANDARD);
        CasingCollisionUtils.registerStandard(CRTrackMaterials.CRTrackType.NARROW_GAUGE);
        CasingCollisionUtils.registerWide(CRTrackMaterials.CRTrackType.WIDE_GAUGE);
    }

    public static boolean shouldMakeCollision(TrackBlockEntity be, class_2680 state) {
        TrackShape shape = (TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE);
        if (((IHasTrackCasing)be).isAlternate() || ((IHasTrackCasing)be).getTrackCasing() == null) {
            return false;
        }
        TrackMaterial.TrackType trackType = ((TrackBlock)state.method_26204()).getMaterial().trackType;
        if (!OFFSETS.containsKey(trackType)) {
            return false;
        }
        Map<TrackShape, Set<class_2338>> shapeMap = OFFSETS.get(trackType);
        return shapeMap.containsKey(shape);
    }

    public static void manageTracks(TrackBlockEntity be, boolean remove) {
        TrackShape shape = (TrackShape)be.method_11010().method_11654((class_2769)TrackBlock.SHAPE);
        TrackMaterial.TrackType trackType = ((TrackBlock)be.method_11010().method_26204()).getMaterial().trackType;
        if (!OFFSETS.containsKey(trackType)) {
            return;
        }
        Map<TrackShape, Set<class_2338>> shapeMap = OFFSETS.get(trackType);
        if (!shapeMap.containsKey(shape)) {
            return;
        }
        class_1937 level = be.method_10997();
        if (level == null) {
            return;
        }
        for (class_2338 offset : shapeMap.get(shape)) {
            class_2338 pos = be.method_11016().method_10081((class_2382)offset);
            class_2680 stateAtPos = level.method_8320(pos);
            boolean present = CRBlocks.CASING_COLLISION.has(stateAtPos);
            if (remove) {
                if (!present) continue;
                level.method_8650(pos, false);
                continue;
            }
            class_3610 fluidState = stateAtPos.method_26227();
            if (!fluidState.method_15769() && !fluidState.method_33659((class_3611)class_3612.field_15910)) continue;
            if (!present && stateAtPos.method_45474()) {
                level.method_8652(pos, ProperWaterloggedBlock.withWater((class_1936)level, (class_2680)CRBlocks.CASING_COLLISION.getDefaultState(), (class_2338)pos), 3);
            }
            CasingCollisionBlock.keepAlive((class_1936)level, pos);
        }
    }

    private static class SuperBuilder {
        private final TrackMaterial.TrackType trackType;

        private SuperBuilder(TrackMaterial.TrackType trackType) {
            this.trackType = trackType;
        }

        public Builder s(TrackShape shape) {
            return new Builder(this.trackType, shape).withSuperBuilder(this);
        }
    }

    private static class Builder {
        private final Set<class_2338> offsets = new HashSet<class_2338>();
        private final TrackMaterial.TrackType trackType;
        private final TrackShape shape;
        private SuperBuilder superBuilder;

        private Builder(TrackMaterial.TrackType trackType, TrackShape shape) {
            this.trackType = trackType;
            this.shape = shape;
        }

        public SuperBuilder build() {
            if (!OFFSETS.containsKey(this.trackType)) {
                OFFSETS.put(this.trackType, new HashMap());
            }
            OFFSETS.get(this.trackType).put(this.shape, this.offsets);
            if (this.superBuilder == null) {
                return new SuperBuilder(this.trackType);
            }
            return this.superBuilder;
        }

        public Builder o(int x, int y, int z) {
            this.offsets.add(new class_2338(x, y, z));
            return this;
        }

        public Builder o(int x, int z) {
            return this.o(x, 0, z);
        }

        public Builder withSuperBuilder(SuperBuilder superBuilder) {
            this.superBuilder = superBuilder;
            return this;
        }
    }
}

