/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.railwayteam.railways.content.coupling.coupler.SecondaryTrackTargetingBehaviour;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.mixin.AccessorTrackTargetingBehavior;
import com.railwayteam.railways.mixin_interfaces.IOccupiedCouplers;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.TrackCouplerClientInfoPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TrackCouplerBlockEntity
extends SmartBlockEntity
implements ITransformableBlockEntity,
IHaveGoggleInformation {
    private class_2680 cachedTrackState = null;
    private class_2680 cachedSecondaryTrackState = null;
    private boolean edgePointsOk = false;
    private boolean lastReportedPower = false;
    private int lastAnalogOutput = 0;
    protected int edgeSpacing = 5;
    private int lastEdgeSpacing = 5;
    private class_5250 error = null;
    private class_5250 error2 = null;
    private ClientInfo clientInfo;
    public TrackTargetingBehaviour<TrackCoupler> edgePoint;
    public TrackTargetingBehaviour<TrackCoupler> secondEdgePoint;
    protected ScrollValueBehaviour edgeSpacingScroll;

    public TrackCouplerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("EdgePointsOk", this.edgePointsOk);
        tag.method_10556("Power", this.lastReportedPower);
        tag.method_10569("AnalogOutput", this.lastAnalogOutput);
        tag.method_10569("EdgeSpacing", this.edgeSpacing);
        tag.method_10569("LastEdgeSpacing", this.lastEdgeSpacing);
    }

    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.edgePointsOk = tag.method_10577("EdgePointsOk");
        this.lastReportedPower = tag.method_10577("Power");
        this.lastAnalogOutput = tag.method_10550("AnalogOutput");
        this.edgeSpacing = tag.method_10550("EdgeSpacing");
        this.lastEdgeSpacing = tag.method_10550("LastEdgeSpacing");
        this.edgeSpacingScroll.setValue(this.edgeSpacing);
        this.invalidateRenderBoundingBox();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, CREdgePointTypes.COUPLER);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
        this.secondEdgePoint = new SecondaryTrackTargetingBehaviour<TrackCoupler>(this, CREdgePointTypes.COUPLER);
        behaviours.add((BlockEntityBehaviour)this.secondEdgePoint);
        this.edgeSpacingScroll = new ScrollValueBehaviour((class_2561)Components.translatable((String)"railways.coupler.edge_spacing"), (SmartBlockEntity)this, (ValueBoxTransform)new TrackCouplerValueBoxTransform(true));
        this.edgeSpacingScroll.between(3, 15);
        this.edgeSpacingScroll.withFormatter(i -> String.valueOf(Components.translatable((String)"railways.coupler.edge_spacing.meters")));
        this.edgeSpacingScroll.withFormatter(i -> i + "m");
        this.edgeSpacingScroll.withCallback(i -> {
            this.edgeSpacing = i;
        });
        this.edgeSpacingScroll.requiresWrench();
        behaviours.add((BlockEntityBehaviour)this.edgeSpacingScroll);
    }

    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        blockState.method_28500((class_2769)SignalBlock.POWERED).ifPresent(powered -> {
            if (this.lastReportedPower == powered) {
                return;
            }
            this.lastReportedPower = powered;
            if (powered.booleanValue()) {
                this.onPowered();
            } else {
                this.onUnpowered();
            }
            this.notifyUpdate();
        });
        if (this.getTargetAnalogOutput() != this.lastAnalogOutput) {
            this.lastAnalogOutput = this.getTargetAnalogOutput();
            this.field_11863.method_8455(this.method_11016(), this.method_11010().method_26204());
        }
    }

    protected void onPowered() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        OperationInfo info = this.getOperationInfo();
        switch (info.mode) {
            case DECOUPLING: {
                Train train = info.frontCarriage.train;
                int numberOffEnd = train.carriages.size() - train.carriages.indexOf(info.backCarriage);
                TrainUtils.splitTrain(train, numberOffEnd);
                break;
            }
            case COUPLING: {
                Train frontTrain = info.frontCarriage.train;
                Train backTrain = info.backCarriage.train;
                if (frontTrain == backTrain) break;
                TrainUtils.combineTrains(frontTrain, backTrain, this.method_11016().method_10084(), this.field_11863, this.getEdgeSpacing());
                break;
            }
        }
    }

    protected void onUnpowered() {
    }

    public boolean getReportedPower() {
        return this.lastReportedPower;
    }

    public int getEdgeSpacing() {
        return this.edgeSpacing;
    }

    private Optional<class_2338> getDesiredSecondaryEdgePos() {
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        if (!trackState.method_28498((class_2769)TrackBlock.SHAPE)) {
            return Optional.empty();
        }
        double distance = -this.getEdgeSpacing() * this.edgePoint.getTargetDirection().method_10181();
        class_243 offset = ((class_243)((TrackShape)trackState.method_11654((class_2769)TrackBlock.SHAPE)).getAxes().get(0)).method_1021(distance);
        return Optional.of(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().method_10069(class_3532.method_15357((double)offset.field_1352), class_3532.method_15357((double)offset.field_1351), class_3532.method_15357((double)offset.field_1350)));
    }

    @Nullable
    private class_2680 getSecondaryTrackState() {
        return this.getDesiredSecondaryEdgePos().map(pos -> this.edgePoint.getWorld().method_8320(pos.method_10081((class_2382)this.method_11016()))).orElse(null);
    }

    private void setError(class_2561 component) {
        this.error = Components.empty().method_10852(component);
    }

    private void setError2(class_2561 component) {
        this.error2 = Components.empty().method_10852(component);
    }

    private void clearErrors() {
        this.error = null;
    }

    private void clearError2() {
        this.error2 = null;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_2680 trackState = this.edgePoint.getTrackBlockState();
        class_2680 secondaryTrackState = this.getSecondaryTrackState();
        if (trackState != this.cachedTrackState || secondaryTrackState != this.cachedSecondaryTrackState || this.edgeSpacing != this.lastEdgeSpacing) {
            class_2338 newPos;
            this.invalidateRenderBoundingBox();
            this.cachedTrackState = trackState;
            this.cachedSecondaryTrackState = secondaryTrackState;
            this.lastEdgeSpacing = this.edgeSpacing;
            class_2338 class_23382 = newPos = this.isOkExceptGraph() ? this.getDesiredSecondaryEdgePos().orElse(class_2338.field_10980) : class_2338.field_10980;
            if (!newPos.equals((Object)((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack())) {
                TrackGraphLocation location;
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetTrack(newPos);
                TrackCoupler point = (TrackCoupler)this.secondEdgePoint.getEdgePoint();
                if (point != null && this.secondEdgePoint.hasValidTrack() && (location = this.secondEdgePoint.determineGraphLocation()) != null && location.graph != null) {
                    location.graph.removePoint(CREdgePointTypes.COUPLER, point.id);
                    Create.RAILWAYS.trains.forEach((uuid, train) -> {
                        ((IOccupiedCouplers)train).getOccupiedCouplers().remove(point.id);
                        if (uuid == point.getCurrentTrain() || train.graph == location.graph) {
                            train.updateSignalBlocks = true;
                        }
                    });
                }
                ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setEdgePoint(null);
                if (this.isOkExceptGraph()) {
                    ((AccessorTrackTargetingBehavior)this.secondEdgePoint).setTargetDirection(((AccessorTrackTargetingBehavior)this.edgePoint).getTargetDirection().method_26424());
                }
                this.sendData();
            }
        }
        this.updateOK();
        this.clientInfo = new ClientInfo(this);
        this.clearErrors();
        this.clearError2();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            CRPackets.PACKETS.sendTo(PlayerSelection.tracking(serverLevel, this.method_11016()), (S2CPacket)new TrackCouplerClientInfoPacket(this));
        }
    }

    private boolean isOkExceptGraph() {
        return this.cachedTrackState.method_26204() instanceof ITrackBlock && this.cachedSecondaryTrackState.method_26204() instanceof ITrackBlock && this.cachedTrackState.method_28498((class_2769)TrackBlock.SHAPE) && this.cachedSecondaryTrackState.method_28498((class_2769)TrackBlock.SHAPE) && this.cachedTrackState.method_11654((class_2769)TrackBlock.SHAPE) == this.cachedSecondaryTrackState.method_11654((class_2769)TrackBlock.SHAPE);
    }

    protected void updateOK() {
        if (!this.isOkExceptGraph()) {
            this.setError2((class_2561)Components.literal((String)"Wrong blocks or track shapes"));
            this.edgePointsOk = false;
            return;
        }
        if (((AccessorTrackTargetingBehavior)this.secondEdgePoint).getTargetTrack().equals((Object)class_2338.field_10980) || ((AccessorTrackTargetingBehavior)this.edgePoint).getTargetTrack().equals((Object)class_2338.field_10980)) {
            this.setError2((class_2561)Components.literal((String)"Missing edge point(s)"));
            this.edgePointsOk = false;
            return;
        }
        if (this.edgePoint.determineGraphLocation() == null || this.secondEdgePoint.determineGraphLocation() == null) {
            this.setError2((class_2561)Components.literal((String)"Edge point(s) missing graph location"));
            this.edgePointsOk = false;
            return;
        }
        if (this.edgePoint.determineGraphLocation().graph != this.secondEdgePoint.determineGraphLocation().graph) {
            this.setError2((class_2561)Components.literal((String)"Edge points not on same graph"));
            this.edgePointsOk = false;
            return;
        }
        Couple edgePointLocations = this.edgePoint.determineGraphLocation().edge;
        Couple secondEdgePointLocations = this.secondEdgePoint.determineGraphLocation().edge;
        if (edgePointLocations == null || secondEdgePointLocations == null) {
            this.setError2((class_2561)Components.literal((String)"Edge point(s) missing edge location"));
            this.edgePointsOk = false;
            return;
        }
        if (((Boolean)CRConfigs.server().strictCoupler.get()).booleanValue()) {
            boolean bl = this.edgePointsOk = ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getFirst()).equals(secondEdgePointLocations.getSecond()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getFirst()) || ((TrackNodeLocation)edgePointLocations.getSecond()).equals(secondEdgePointLocations.getSecond());
            if (!this.edgePointsOk) {
                this.setError2((class_2561)Components.literal((String)"Edge points not on same or adjacent edges"));
            }
        } else {
            this.edgePointsOk = true;
        }
    }

    public boolean areEdgePointsOk() {
        return this.field_11863 != null && this.field_11863.field_9236 && this.clientInfo != null ? this.clientInfo.edgePointsOk : this.edgePointsOk;
    }

    @Nullable
    public TrackCoupler getCoupler() {
        return (TrackCoupler)this.edgePoint.getEdgePoint();
    }

    @Nullable
    public TrackCoupler getSecondaryCoupler() {
        return (TrackCoupler)this.secondEdgePoint.getEdgePoint();
    }

    @Nullable
    protected Carriage getCarriageOnPoint(@NotNull Train train, @NotNull TrackCoupler coupler, @NotNull TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        for (Carriage carriage : train.carriages) {
            if (!this.isCarriageWheelOnPoint(carriage, coupler, edgePoint, leading)) continue;
            return carriage;
        }
        return null;
    }

    protected boolean isCarriageWheelOnPoint(Carriage carriage, TrackCoupler coupler, TrackTargetingBehaviour<TrackCoupler> edgePoint, boolean leading) {
        TravellingPoint relevantPoint = leading ? carriage.leadingBogey().leading() : carriage.trailingBogey().trailing();
        TravellingPoint relevantPoint2 = leading ? carriage.leadingBogey().trailing() : carriage.trailingBogey().leading();
        CarriageBogey relevantBogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        boolean upsideDown = relevantBogey.isUpsideDown();
        double couplerPosition = coupler.getLocationOn(relevantPoint.edge);
        class_243 wheelPosition = relevantPoint.getPosition(carriage.train.graph).method_1019(relevantPoint2.getPosition(carriage.train.graph)).method_1021(0.5).method_1031(0.0, upsideDown ? 2.0 : 0.0, 0.0);
        class_243 couplerSpatialPosition = class_243.method_24955((class_2382)edgePoint.getGlobalPosition().method_10084());
        return (coupler.isPrimary(relevantPoint.node1) || coupler.isPrimary(relevantPoint.node2) || coupler.isPrimary(relevantPoint2.node1) || coupler.isPrimary(relevantPoint2.node2)) && wheelPosition.method_1025(couplerSpatialPosition) < 0.6400000000000001;
    }

    public AllowedOperationMode getAllowedOperationMode() {
        return (AllowedOperationMode)((Object)this.method_11010().method_11654(TrackCouplerBlock.MODE));
    }

    public OperationInfo getOperationInfo() {
        this.clearErrors();
        OperationInfo info = this.getOperationInfo(false);
        if (info.mode == OperationMode.NONE) {
            class_5250 backupError = this.error;
            this.clearErrors();
            info = this.getOperationInfo(true);
            if (info.mode == OperationMode.NONE) {
                this.error = backupError;
            }
        }
        if (!info.mode.permitted(this.getAllowedOperationMode())) {
            this.clearErrors();
            this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.mode_not_permitted"));
            return OperationInfo.NONE;
        }
        return info;
    }

    protected OperationInfo getOperationInfo(boolean reversed) {
        TrackTargetingBehaviour<TrackCoupler> edgePoint2;
        TrackCoupler coupler1 = reversed ? this.getSecondaryCoupler() : this.getCoupler();
        TrackCoupler coupler2 = reversed ? this.getCoupler() : this.getSecondaryCoupler();
        TrackTargetingBehaviour<TrackCoupler> edgePoint1 = reversed ? this.secondEdgePoint : this.edgePoint;
        TrackTargetingBehaviour<TrackCoupler> trackTargetingBehaviour = edgePoint2 = reversed ? this.edgePoint : this.secondEdgePoint;
        if (coupler1 != null && coupler2 != null && coupler1.isActivated() && coupler2.isActivated()) {
            Train primaryTrain = (Train)Create.RAILWAYS.trains.get(coupler1.getCurrentTrain());
            Train secondaryTrain = (Train)Create.RAILWAYS.trains.get(coupler2.getCurrentTrain());
            if (primaryTrain != null && primaryTrain == secondaryTrain) {
                Carriage frontCarriage = this.getCarriageOnPoint(primaryTrain, coupler2, edgePoint2, false);
                if (frontCarriage == null) {
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
                if (frontCarriage != null && primaryTrain.carriages.indexOf(frontCarriage) < primaryTrain.carriages.size() - 1) {
                    Carriage backCarriage = (Carriage)primaryTrain.carriages.get(primaryTrain.carriages.indexOf(frontCarriage) + 1);
                    if (this.isCarriageWheelOnPoint(backCarriage, coupler1, edgePoint1, true) && Math.abs(primaryTrain.carriages.indexOf(frontCarriage) - primaryTrain.carriages.indexOf(backCarriage)) == 1) {
                        return new OperationInfo(OperationMode.DECOUPLING, frontCarriage, backCarriage);
                    }
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                } else {
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
            } else if (primaryTrain != null && secondaryTrain != null) {
                Carriage primaryCarriage = this.getCarriageOnPoint(primaryTrain, coupler1, edgePoint1, true);
                Carriage secondaryCarriage = this.getCarriageOnPoint(secondaryTrain, coupler2, edgePoint2, false);
                if (primaryCarriage != null && secondaryCarriage != null && primaryTrain.carriages.indexOf(primaryCarriage) == 0 && secondaryTrain.carriages.indexOf(secondaryCarriage) == secondaryTrain.carriages.size() - 1) {
                    double innerLength;
                    double outerLength = secondaryCarriage.getLeadingPoint().getPosition(secondaryTrain.graph).method_1020(primaryCarriage.getTrailingPoint().getPosition(primaryTrain.graph)).method_1027();
                    if (outerLength < (innerLength = secondaryCarriage.getTrailingPoint().getPosition(secondaryTrain.graph).method_1020(primaryCarriage.getLeadingPoint().getPosition(primaryTrain.graph)).method_1027())) {
                        return OperationInfo.NONE;
                    }
                    return new OperationInfo(OperationMode.COUPLING, secondaryCarriage, primaryCarriage);
                }
                if (primaryCarriage != null && this.getCarriageOnPoint(secondaryTrain, coupler2, edgePoint2, true) != null) {
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_orientation"));
                } else if (secondaryCarriage != null && this.getCarriageOnPoint(primaryTrain, coupler1, edgePoint1, false) != null) {
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_orientation"));
                } else {
                    this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.carriage_alignment"));
                }
            } else {
                this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.missing_train"));
            }
        } else {
            this.setError((class_2561)Components.translatable((String)"railways.tooltip.coupler.error.missing_train"));
        }
        return OperationInfo.NONE;
    }

    public OperationMode getOperationMode() {
        return this.getOperationInfo().mode;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo != null ? this.clientInfo : ClientInfo.FALLBACK;
    }

    public void setClientInfo(ClientInfo info) {
        this.clientInfo = info;
    }

    public int getTargetAnalogOutput() {
        OperationMode mode;
        int out = 0;
        if (this.getCoupler() != null && this.getCoupler().isActivated()) {
            ++out;
        }
        if (this.getSecondaryCoupler() != null && this.getSecondaryCoupler().isActivated()) {
            out += 2;
        }
        if ((mode = this.getOperationMode()) == OperationMode.DECOUPLING) {
            out += 4;
        } else if (mode == OperationMode.COUPLING) {
            out += 8;
        }
        return out;
    }

    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867, this.edgePoint.getGlobalPosition()).method_991(new class_238(this.field_11867, this.secondEdgePoint.getGlobalPosition())).method_1014(2.0);
    }

    public void transform(StructureTransform transform) {
        this.edgePoint.transform(transform);
        this.secondEdgePoint.transform(transform);
    }

    private static LangBuilder b() {
        return Lang.builder((String)"railways");
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.header", new Object[0]).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.mode", new Object[0]).style(class_124.field_1054).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("coupler.mode." + this.getAllowedOperationMode().method_15434(), new Object[0]).style(class_124.field_1054).forGoggles(tooltip);
        String train1 = this.clientInfo == null ? "None" : this.clientInfo.trainName1;
        String train2 = this.clientInfo == null ? "None" : this.clientInfo.trainName2;
        OperationMode operationMode = this.clientInfo == null ? OperationMode.NONE : this.clientInfo.mode;
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.train1", new Object[]{train1}).style(class_124.field_1065).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.train2", new Object[]{train2}).style(class_124.field_1065).forGoggles(tooltip);
        TrackCouplerBlockEntity.b().translate("tooltip.coupler.action." + operationMode.name().toLowerCase(Locale.ROOT), new Object[0]).style(class_124.field_1060).forGoggles(tooltip);
        if (this.clientInfo != null) {
            if (this.clientInfo.error != null) {
                TrackCouplerBlockEntity.b().add(this.clientInfo.error).style(class_124.field_1079).forGoggles(tooltip);
            }
            if (this.clientInfo.error2 != null && ((Boolean)CRConfigs.client().showExtendedCouplerDebug.get()).booleanValue()) {
                TrackCouplerBlockEntity.b().add(this.clientInfo.error2).style(class_124.field_1064).forGoggles(tooltip);
            }
        }
        return true;
    }

    private static class TrackCouplerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public TrackCouplerValueBoxTransform(boolean vertical) {
            super((state, d) -> d.method_10166().method_10178() == vertical);
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }
    }

    public record OperationInfo(OperationMode mode, Carriage frontCarriage, Carriage backCarriage) {
        public static final OperationInfo NONE = new OperationInfo(OperationMode.NONE, null, null);
    }

    public static enum OperationMode {
        NONE,
        COUPLING,
        DECOUPLING;


        public boolean permitted(AllowedOperationMode allowedMode) {
            return this == NONE || allowedMode == AllowedOperationMode.BOTH || allowedMode == AllowedOperationMode.COUPLING && this == COUPLING || allowedMode == AllowedOperationMode.DECOUPLING && this == DECOUPLING;
        }
    }

    public static class ClientInfo {
        public static final ClientInfo FALLBACK = new ClientInfo(OperationMode.NONE, "??", "??", false, Components.literal((String)"??"), Components.literal((String)"??"));
        public OperationMode mode;
        public String trainName1;
        public String trainName2;
        public boolean edgePointsOk;
        public class_5250 error;
        public class_5250 error2;

        private ClientInfo(OperationMode mode, String trainName1, String trainName2, boolean edgePointsOk, class_5250 error, class_5250 error2) {
            this.mode = mode;
            this.trainName1 = trainName1;
            this.trainName2 = trainName2;
            this.edgePointsOk = edgePointsOk;
            this.error = error;
            this.error2 = error2;
        }

        protected ClientInfo(TrackCouplerBlockEntity te) {
            UUID trainId;
            Train train;
            this.mode = te.getOperationMode();
            this.trainName1 = "None";
            this.trainName2 = "None";
            if (te.getCoupler() != null && te.getCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getCoupler().getCurrentTrain())) != null) {
                this.trainName1 = train.name.getString();
            }
            if (te.getSecondaryCoupler() != null && te.getSecondaryCoupler().isActivated() && (train = (Train)Create.RAILWAYS.trains.get(trainId = te.getSecondaryCoupler().getCurrentTrain())) != null) {
                this.trainName2 = train.name.getString();
            }
            this.edgePointsOk = te.edgePointsOk;
            this.error = te.error;
            this.error2 = te.error2;
        }

        public ClientInfo(class_2487 tag) {
            this.mode = (OperationMode)NBTHelper.readEnum((class_2487)tag, (String)"mode", OperationMode.class);
            this.trainName1 = tag.method_10558("trainName1");
            this.trainName2 = tag.method_10558("trainName2");
            this.edgePointsOk = tag.method_10577("edgePointsOk");
            this.error = tag.method_10545("error") ? class_2561.class_2562.method_10877((String)tag.method_10558("error")) : null;
            this.error2 = tag.method_10545("error2") ? class_2561.class_2562.method_10877((String)tag.method_10558("error2")) : null;
        }

        public class_2487 write() {
            class_2487 tag = new class_2487();
            NBTHelper.writeEnum((class_2487)tag, (String)"mode", (Enum)this.mode);
            tag.method_10582("trainName1", this.trainName1);
            tag.method_10582("trainName2", this.trainName2);
            tag.method_10556("edgePointsOk", this.edgePointsOk);
            if (this.error != null) {
                tag.method_10582("error", class_2561.class_2562.method_10867((class_2561)this.error));
            }
            if (this.error2 != null) {
                tag.method_10582("error2", class_2561.class_2562.method_10867((class_2561)this.error2));
            }
            return tag;
        }
    }

    public static enum AllowedOperationMode implements class_3542
    {
        BOTH(true, true),
        COUPLING(true, false),
        DECOUPLING(false, true);

        public final boolean canCouple;
        public final boolean canDecouple;

        private AllowedOperationMode(boolean canCouple, boolean canDecouple) {
            this.canCouple = canCouple;
            this.canDecouple = canDecouple;
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public class_2561 getTranslatedName() {
            return Components.translatable((String)("railways.coupler.mode." + this.method_15434()));
        }
    }
}

