/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.compat.tracks;

import com.google.common.collect.ImmutableSet;
import com.jozufozu.flywheel.core.PartialModel;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.CRTagGen;
import com.railwayteam.railways.compat.Mods;
import com.railwayteam.railways.compat.tracks.CompatTrackBlockStateGenerator;
import com.railwayteam.railways.compat.tracks.GenericTrackCompat;
import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.mixin.AccessorTrackMaterialFactory;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackMaterialFactory;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.SharedProperties;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_7706;
import org.jetbrains.annotations.ApiStatus;

public abstract class TrackCompatUtils {
    public static final Set<String> TRACK_COMPAT_MODS = ImmutableSet.of((Object)"hexcasting", (Object)"byg", (Object)"blue_skies", (Object)"twilightforest", (Object)"biomesoplenty");
    private static final CreateRegistrate REGISTRATE = Railways.registrate();

    public static boolean anyLoaded() {
        if (GenericTrackCompat.isDataGen() || ((Boolean)CRConfigs.common().registerMissingTracks.get()).booleanValue()) {
            return true;
        }
        for (String mod : TRACK_COMPAT_MODS) {
            if (!Mods.valueOf((String)mod.toUpperCase((Locale)Locale.ROOT)).isLoaded) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean mixinIgnoreErrorForMissingItem(class_2960 resourceLocation) {
        if (resourceLocation.method_12836().equals("railways")) {
            for (String compatMod : TRACK_COMPAT_MODS) {
                if (!resourceLocation.method_12832().contains(compatMod)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)CompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, boolean hideInCreativeTabs) {
        return TrackCompatUtils.makeTrack(material, (NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CompatTrackBlockStateGenerator)CompatTrackBlockStateGenerator.create()).generate(arg_0, arg_1)), (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), p -> p, hideInCreativeTabs);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<class_4970.class_2251, class_4970.class_2251> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<class_4970.class_2251, class_4970.class_2251> collectProperties) {
        return TrackCompatUtils.makeTrack(material, blockstateGen, onRegister, collectProperties, false);
    }

    public static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<class_2248, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<class_4970.class_2251, class_4970.class_2251> collectProperties, boolean hideInCreativeTabs) {
        String owningMod = material.id.method_12836();
        String name = "track_" + owningMod + "_" + material.resourceName();
        CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.TRACKS.tag, CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric, class_3481.field_33715);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            CRTagGen.addOptionalTag(Railways.asResource(name), AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block(name, arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(SharedProperties::stone).properties(p -> ((class_4970.class_2251)collectProperties.apply((class_4970.class_2251)p)).method_31710(class_3620.field_16005).method_9632(0.8f).method_9626(class_2498.field_11533).method_22488()).addLayer(() -> class_1921::method_23579).blockstate(blockstateGen).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).onRegister(CRTrackMaterials::addToBlockEntityType)).item(TrackBlockItem::new).removeTab(hideInCreativeTabs ? null : class_7706.field_40200).model((c, p) -> p.generated((NonNullSupplier)c, new class_2960[]{new class_2960(owningMod, "item/track/track_" + material.resourceName())})).build()).register();
    }

    public static TrackMaterial buildCompatModels(TrackMaterialFactory factory) {
        String namespace = ((AccessorTrackMaterialFactory)factory).getId().method_12836();
        String path = ((AccessorTrackMaterialFactory)factory).getId().method_12832();
        String prefix = "block/track/compat/" + namespace + "/" + path + "/";
        return factory.customModels(() -> () -> new PartialModel(Railways.asResource(prefix + "tie")), () -> () -> new PartialModel(Railways.asResource(prefix + "segment_left")), () -> () -> new PartialModel(Railways.asResource(prefix + "segment_right"))).build();
    }
}

