/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.smithingtable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookCategories;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.generic.GenericRecipeBookComponent;
import marsh.town.brb.recipe.BRBSmithingRecipe;
import marsh.town.brb.recipe.smithing.BRBSmithingTransformRecipe;
import marsh.town.brb.recipe.smithing.BRBSmithingTrimRecipe;
import marsh.town.brb.smithingtable.SmithingGhostRecipe;
import marsh.town.brb.smithingtable.SmithingRecipeBookPage;
import marsh.town.brb.smithingtable.SmithingRecipeCollection;
import marsh.town.brb.util.BRBHelper;
import marsh.town.brb.util.ClientInventoryUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_4862;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_8053;
import net.minecraft.class_8059;
import net.minecraft.class_8060;
import net.minecraft.class_8062;

public class SmithingRecipeBookComponent
extends GenericRecipeBookComponent<class_4862, SmithingRecipeCollection, BRBSmithingRecipe> {
    private static final class_5250 ONLY_CRAFTABLES_TOOLTIP = class_2561.method_43471((String)"brb.gui.smithable");

    public void init(int width, int height, class_310 minecraft, boolean widthNarrow, class_4862 menu, Consumer<class_1799> onGhostRecipeUpdate, class_5455 registryAccess, class_1863 recipeManager) {
        super.init(width, height, minecraft, widthNarrow, menu, onGhostRecipeUpdate, registryAccess);
        this.recipeManager = recipeManager;
        this.ghostRecipe = new SmithingGhostRecipe(onGhostRecipeUpdate, registryAccess);
        this.ghostRecipe.setDefaultRenderingPredicate((class_4862)this.menu);
        this.recipesPage = new SmithingRecipeBookPage(registryAccess, () -> BRBBookSettings.isFiltering(this.getRecipeBookType()));
        this.initVisuals();
    }

    @Override
    public class_2561 getRecipeFilterName() {
        return ONLY_CRAFTABLES_TOOLTIP;
    }

    @Override
    public BRBHelper.Book getRecipeBookType() {
        return BetterRecipeBook.SMITHING;
    }

    @Override
    public void handlePlaceRecipe() {
        BRBSmithingRecipe result = (BRBSmithingRecipe)this.recipesPage.getCurrentClickedRecipe();
        SmithingRecipeCollection recipeCollection = (SmithingRecipeCollection)this.recipesPage.getLastClickedRecipeCollection();
        if (result == null || recipeCollection == null) {
            return;
        }
        this.ghostRecipe.clear();
        if (!result.hasMaterials((class_2371<class_1735>)((class_4862)this.menu).field_7761, this.registryAccess)) {
            this.setupGhostRecipe(result, (List<class_1735>)((class_4862)this.menu).field_7761);
            return;
        }
        int slotIndex = 0;
        boolean placedBase = false;
        for (class_1735 slot : ((class_4862)this.menu).field_7761) {
            class_1799 itemStack = slot.method_7677();
            if (result.getTemplate().method_8093(itemStack)) {
                assert (class_310.method_1551().field_1761 != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, ((class_4862)this.menu).method_7611((int)slotIndex).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, 0, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            } else if (!placedBase && class_8053.method_48428((class_5455)this.registryAccess, (class_1799)itemStack).isEmpty() && result.getBase().method_7909().equals(itemStack.method_7909())) {
                assert (class_310.method_1551().field_1761 != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, ((class_4862)this.menu).method_7611((int)slotIndex).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, 1, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                placedBase = true;
            } else if (result.getAddition().method_8093(itemStack)) {
                assert (class_310.method_1551().field_1761 != null);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, ((class_4862)this.menu).method_7611((int)slotIndex).field_7874, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                class_310.method_1551().field_1761.method_2906(((class_4862)this.menu).field_7763, 2, 0, class_1713.field_7790, (class_1657)class_310.method_1551().field_1724);
                ClientInventoryUtil.storeItem(-1, i -> i > 4);
            }
            ++slotIndex;
        }
        this.updateCollections(false);
    }

    public void setupGhostRecipe(BRBSmithingRecipe result, List<class_1735> list) {
        this.ghostRecipe.setRecipe(result);
        this.ghostRecipe.addIngredient(2, result.getAddition(), 44, 48);
        this.ghostRecipe.addIngredient(0, result.getTemplate(), 8, 48);
        this.ghostRecipe.addIngredient(1, class_1856.method_8101((class_1799[])new class_1799[]{result.getBase()}), 26, 48);
    }

    public boolean isShowingGhostRecipe() {
        return this.ghostRecipe != null && this.ghostRecipe.size() > 0;
    }

    @Override
    protected List<SmithingRecipeCollection> getCollectionsForCategory() {
        List recipes = this.recipeManager.method_30027(class_3956.field_25388);
        ArrayList<SmithingRecipeCollection> results = new ArrayList<SmithingRecipeCollection>();
        BRBBookCategories.Category category = this.selectedTab.getCategory();
        for (class_8059 recipe : recipes) {
            if (category == BetterRecipeBook.SMITHING_SEARCH) {
                if (recipe instanceof class_8060) {
                    results.add(new SmithingRecipeCollection(List.of(BRBSmithingTransformRecipe.from((class_8060)recipe, this.registryAccess)), (class_4862)this.menu, this.registryAccess));
                    continue;
                }
                if (!(recipe instanceof class_8062)) continue;
                results.add(new SmithingRecipeCollection((List<? extends BRBSmithingRecipe>)BRBSmithingTrimRecipe.from((class_8062)recipe), (class_4862)this.menu, this.registryAccess));
                continue;
            }
            if (category == BetterRecipeBook.SMITHING_TRANSFORM) {
                if (!(recipe instanceof class_8060)) continue;
                results.add(new SmithingRecipeCollection(List.of(BRBSmithingTransformRecipe.from((class_8060)recipe, this.registryAccess)), (class_4862)this.menu, this.registryAccess));
                continue;
            }
            if (!(recipe instanceof class_8062)) continue;
            results.add(new SmithingRecipeCollection((List<? extends BRBSmithingRecipe>)BRBSmithingTrimRecipe.from((class_8062)recipe), (class_4862)this.menu, this.registryAccess));
        }
        return results;
    }
}

