/*
 * Decompiled with CFR 0.152.
 */
package marsh.town.brb.smithingtable;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import marsh.town.brb.BetterRecipeBook;
import marsh.town.brb.api.BRBBookSettings;
import marsh.town.brb.recipe.BRBSmithingRecipe;
import marsh.town.brb.smithingtable.SmithingRecipeCollection;
import marsh.town.brb.util.BRBTextures;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_5244;
import net.minecraft.class_5455;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class SmithingOverlayRecipeComponent
implements class_4068,
class_364 {
    private final List<OverlayRecipeButton> recipeButtons = Lists.newArrayList();
    private BRBSmithingRecipe lastRecipeClicked;
    private SmithingRecipeCollection collection;
    private boolean isVisible;
    private static final class_2960 OVERLAY_RECIPE_SPRITE = new class_2960("recipe_book/overlay_recipe");
    float time;
    private int y;
    private int x;

    public void init(SmithingRecipeCollection recipeCollection, int x, int y, class_5455 registryAccess) {
        this.collection = recipeCollection;
        List<BRBSmithingRecipe> lockedRecipes = recipeCollection.getDisplayRecipes(true);
        List unlockedRecipes = BRBBookSettings.isFiltering(BetterRecipeBook.SMITHING) ? Collections.emptyList() : recipeCollection.getDisplayRecipes(false);
        int lockedRecipeCount = lockedRecipes.size();
        int totalRecipeCount = lockedRecipeCount + unlockedRecipes.size();
        int columns = totalRecipeCount <= 16 ? 4 : 5;
        this.x = x + 7;
        this.y = y + 26;
        this.isVisible = true;
        this.recipeButtons.clear();
        for (int index = 0; index < totalRecipeCount; ++index) {
            boolean isCraftable = index < lockedRecipeCount;
            BRBSmithingRecipe Recipe = isCraftable ? lockedRecipes.get(index) : (BRBSmithingRecipe)unlockedRecipes.get(index - lockedRecipeCount);
            int buttonX = this.x + 4 + 25 * (index % columns);
            int buttonY = this.y + 5 + 25 * (index / columns);
            this.recipeButtons.add(new OverlayRecipeButton(buttonX, buttonY, Recipe, isCraftable, registryAccess));
        }
        this.lastRecipeClicked = null;
    }

    public boolean method_25402(double d, double e, int i) {
        if (i != 0) {
            return false;
        }
        for (OverlayRecipeButton overlayRecipeButton : this.recipeButtons) {
            if (!overlayRecipeButton.method_25402(d, e, i)) continue;
            this.lastRecipeClicked = overlayRecipeButton.recipe;
            return true;
        }
        return false;
    }

    public boolean method_25405(double d, double e) {
        return false;
    }

    @Nullable
    public BRBSmithingRecipe getLastRecipeClicked() {
        return this.lastRecipeClicked;
    }

    public SmithingRecipeCollection getRecipeCollection() {
        return this.collection;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    public void method_25365(boolean bl) {
    }

    public boolean method_25370() {
        return false;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        if (this.isVisible) {
            guiGraphics.method_51448().method_22909();
            this.time += f;
            RenderSystem.enableBlend();
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
            int k = this.recipeButtons.size() <= 16 ? 4 : 5;
            int l = Math.min(this.recipeButtons.size(), k);
            int m = class_3532.method_15386((float)((float)this.recipeButtons.size() / (float)k));
            guiGraphics.method_48586(BRBTextures.RECIPE_BOOK_BACKGROUND_TEXTURE, this.x, this.y, l * 25 + 8, m * 25 + 8, 4, 32, 32, 82, 208);
            RenderSystem.disableBlend();
            for (OverlayRecipeButton overlayRecipeButton : this.recipeButtons) {
                overlayRecipeButton.method_25394(guiGraphics, i, j, f);
            }
            guiGraphics.method_51448().method_22909();
        }
    }

    public static class OverlayRecipeButton
    extends class_339 {
        final BRBSmithingRecipe recipe;
        private final boolean isCraftable;
        private class_5455 registryAccess;

        public OverlayRecipeButton(int i, int j, BRBSmithingRecipe smithableResult, boolean isCraftable, class_5455 registryAccess) {
            super(i, j, 200, 20, class_5244.field_39003);
            this.field_22758 = 24;
            this.field_22759 = 24;
            this.recipe = smithableResult;
            this.isCraftable = isCraftable;
            this.registryAccess = registryAccess;
        }

        public void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }

        public void method_48579(class_332 guiGraphics, int i, int j, float f) {
            class_2960 resourceLocation = BRBTextures.RECIPE_BOOK_PLAIN_OVERLAY_SPRITE.get(this.isCraftable, this.method_25367());
            guiGraphics.method_25290(resourceLocation, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, 24, 24);
            guiGraphics.method_51448().method_22903();
            int offset = 4;
            guiGraphics.method_51445(this.recipe.getResult(this.registryAccess), this.method_46426() + offset, this.method_46427() + offset);
            guiGraphics.method_51448().method_22909();
        }
    }
}

