/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class DragonTreeFeature
extends DefaultFeature {
    private static final Function<class_2680, Boolean> REPLACE = state -> {
        if (state.method_26204() == EndBlocks.DRAGON_TREE_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((class_2680)state);
    };
    private static final Function<class_2680, Boolean> IGNORE = EndBlocks.DRAGON_TREE::isTreeLog;
    private static final Function<PosInfo, class_2680> POST = info -> {
        if (EndBlocks.DRAGON_TREE.isTreeLog(info.getStateUp()) && EndBlocks.DRAGON_TREE.isTreeLog(info.getStateDown())) {
            return EndBlocks.DRAGON_TREE.getLog().method_9564();
        }
        return info.getState();
    };
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.3f, 0.0f), new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE1 = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE2 = SplineHelper.copySpline(SIDE1);
    private static final List<Vector3f> ROOT;

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (!world.method_8320(pos.method_10074()).method_26164(class_3481.field_21953)) {
            return false;
        }
        float size = MHelper.randRange((int)10, (int)25, (class_5819)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)6);
        SplineHelper.offsetParts((List)spline, (class_5819)random, (float)1.0f, (float)0.0f, (float)1.0f);
        if (!SplineHelper.canGenerate((List)spline, (class_2338)pos, (class_5281)world, REPLACE)) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)AIR);
        Vector3f last = SplineHelper.getPos((List)spline, (float)3.5f);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.method_43055());
        float radius = size * MHelper.randRange((float)0.5f, (float)0.7f, (class_5819)random);
        this.makeCap(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), radius, random, noise);
        last = (Vector3f)spline.get(0);
        this.makeRoots(world, pos.method_10069((int)last.x(), (int)last.y(), (int)last.z()), radius, random);
        radius = MHelper.randRange((float)1.2f, (float)2.3f, (class_5819)random);
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)1.2f, bpos -> EndBlocks.DRAGON_TREE.getBark().method_9564());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        return true;
    }

    private void makeCap(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise) {
        int count = (int)radius;
        int offset = (int)(BRANCH.get(BRANCH.size() - 1).y() * radius);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (class_5819)random);
            List branch = SplineHelper.copySpline(BRANCH);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (class_5281)world, (class_2680)EndBlocks.DRAGON_TREE.getBark().method_9564(), (class_2338)pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE1);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (class_5281)world, (class_2680)EndBlocks.DRAGON_TREE.getBark().method_9564(), (class_2338)pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE2);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (class_5281)world, (class_2680)EndBlocks.DRAGON_TREE.getBark().method_9564(), (class_2338)pos, REPLACE);
        }
        this.leavesBall(world, pos.method_10086(offset), radius * 1.15f + 2.0f, random, noise);
    }

    private void makeRoots(class_5281 world, class_2338 pos, float radius, class_5819 random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (class_5819)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.method_8320(pos.method_10069((int)last.x(), (int)last.y(), (int)last.z())).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (class_5281)world, (class_2680)EndBlocks.DRAGON_TREE.getBark().method_9564(), (class_2338)pos, REPLACE);
        }
    }

    private void leavesBall(class_5281 world, class_2338 pos, float radius, class_5819 random, OpenSimplexNoise noise) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((class_2680)EndBlocks.DRAGON_TREE_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 1.5f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.method_43057() * 3.0f - 1.5f)).setSource((SDF)sphere);
        class_2338.class_2339 mut = new class_2338.class_2339();
        sphere.addPostProcess(info -> {
            if (random.method_43048(5) == 0) {
                for (class_2350 dir : class_2350.values()) {
                    class_2680 state = info.getState(dir, 2);
                    if (!state.method_26215()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.DRAGON_TREE.getBark().method_9564());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.method_33097(x + info.getPos().method_10263());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.method_33099(z + info.getPos().method_10260());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.method_33098(y + info.getPos().method_10264());
                            class_2680 state = info.getState((class_2338)mut);
                            if (!(state.method_26204() instanceof class_2397) || d >= (distance = ((Integer)state.method_11654((class_2769)class_2397.field_11199)).intValue())) continue;
                            info.setState((class_2338)mut, (class_2680)state.method_11657((class_2769)class_2397.field_11199, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((class_5425)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                class_2338 p = pos.method_10069((int)(random.method_43059() * 1.0), (int)(random.method_43059() * 1.0), (int)(random.method_43059() * 1.0));
                boolean place = true;
                for (class_2350 d : class_2350.values()) {
                    class_2680 state = world.method_8320(p.method_10093(d));
                    if (EndBlocks.DRAGON_TREE.isTreeLog(state) || state.method_27852(EndBlocks.DRAGON_TREE_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)p, (class_2248)EndBlocks.DRAGON_TREE.getBark());
            }
        }
        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2248)EndBlocks.DRAGON_TREE.getBark());
    }

    static {
        Vector3f offset1 = new Vector3f(-0.4f, -0.6f, 0.0f);
        Vector3f offset2 = new Vector3f(0.4f, 0.6f, 0.0f);
        SplineHelper.offset(SIDE1, (Vector3f)offset1);
        SplineHelper.offset(SIDE2, (Vector3f)offset1);
        SplineHelper.rotateSpline(SIDE1, (float)0.5f);
        SplineHelper.rotateSpline(SIDE2, (float)-0.5f);
        SplineHelper.offset(SIDE1, (Vector3f)offset2);
        SplineHelper.offset(SIDE2, (Vector3f)offset2);
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

