/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.elytraslot;

import com.illusivesoulworks.elytraslot.client.ElytraRenderResult;
import com.illusivesoulworks.elytraslot.common.IElytraProvider;
import com.illusivesoulworks.elytraslot.common.SimpleCompatibilityProvider;
import com.illusivesoulworks.elytraslot.common.VanillaElytraProvider;
import com.illusivesoulworks.elytraslot.platform.Services;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public class ElytraSlotCommonMod {
    public static final Predicate<class_1799> IS_ELYTRA = new Predicate<class_1799>(){

        @Override
        public boolean test(class_1799 stack) {
            for (IElytraProvider provider : PROVIDERS) {
                if (!provider.matches(stack)) continue;
                return true;
            }
            return false;
        }
    };
    private static final List<IElytraProvider> PROVIDERS = new LinkedList<IElytraProvider>();

    public static void init() {
        PROVIDERS.add(new VanillaElytraProvider());
        PROVIDERS.add(new SimpleCompatibilityProvider());
    }

    public static Optional<ElytraRenderResult> getElytraRender(class_1309 livingEntity) {
        AtomicReference result = new AtomicReference();
        Services.ELYTRA.processSlots(livingEntity, stack -> {
            if (!stack.method_7960()) {
                for (IElytraProvider provider : PROVIDERS) {
                    if (!provider.matches((class_1799)stack)) continue;
                    result.set(provider.getRender((class_1799)stack));
                    return true;
                }
            }
            return false;
        });
        return Optional.ofNullable((ElytraRenderResult)result.get());
    }

    public static boolean canFly(class_1309 livingEntity, boolean doTick) {
        AtomicBoolean result = new AtomicBoolean();
        Services.ELYTRA.processSlots(livingEntity, stack -> {
            if (!stack.method_7960()) {
                for (IElytraProvider provider : PROVIDERS) {
                    if (!provider.matches((class_1799)stack)) continue;
                    result.set(provider.canFly((class_1799)stack, livingEntity, doTick));
                    return true;
                }
            }
            return false;
        });
        return result.get();
    }

    public static boolean isEquipped(class_1309 livingEntity) {
        return Services.ELYTRA.isEquipped(livingEntity);
    }

    public static boolean canEquip(class_1309 livingEntity) {
        return !IS_ELYTRA.test(livingEntity.method_6118(class_1304.field_6174)) && !Services.ELYTRA.isEquipped(livingEntity);
    }
}

