/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.inventory;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionedInventoryWrapper
implements Storage<ItemVariant> {
    public static final AtomicInteger idGenerator = new AtomicInteger();
    private Storage<ItemVariant> inventory;
    private int id = idGenerator.getAndIncrement();

    public VersionedInventoryWrapper(Storage<ItemVariant> inventory) {
        this.inventory = inventory;
    }

    public int getId() {
        return this.id;
    }

    public long getVersion() {
        return this.inventory.getVersion();
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.inventory.insert((Object)resource, maxAmount, transaction);
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        return this.inventory.extract((Object)resource, maxAmount, transaction);
    }

    @NotNull
    public Iterator<StorageView<ItemVariant>> iterator() {
        return this.inventory.iterator();
    }

    public boolean supportsInsertion() {
        return this.inventory.supportsInsertion();
    }

    public long simulateInsert(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.inventory.simulateInsert((Object)resource, maxAmount, transaction);
    }

    public boolean supportsExtraction() {
        return this.inventory.supportsExtraction();
    }

    public long simulateExtract(ItemVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.inventory.simulateExtract((Object)resource, maxAmount, transaction);
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        return this.inventory.exactView((Object)resource);
    }
}

