/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.deployer.BeltDeployerCallbacks;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.kinetics.deployer.DeployerFilterSlot;
import com.simibubi.create.content.kinetics.deployer.DeployerHandler;
import com.simibubi.create.content.kinetics.deployer.DeployerItemHandler;
import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class DeployerBlockEntity
extends KineticBlockEntity
implements SidedStorageBlockEntity {
    protected State state;
    protected Mode mode;
    protected class_1799 heldItem = class_1799.field_8037;
    protected DeployerFakePlayer player;
    protected int timer;
    protected float reach;
    protected boolean fistBump = false;
    protected List<class_1799> overflowItems = new ArrayList<class_1799>();
    protected FilteringBehaviour filtering;
    protected boolean redstoneLocked = false;
    protected UUID owner;
    private DeployerItemHandler invHandler;
    private class_2499 deferredInventoryList;
    private LerpedFloat animatedOffset;
    public BeltProcessingBehaviour processingBehaviour;
    public SnapshotParticipant<List<class_1799>> snapshotParticipant = new SnapshotParticipant<List<class_1799>>(){

        protected List<class_1799> createSnapshot() {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            stacks.add(DeployerBlockEntity.this.player == null ? class_1799.field_8037 : DeployerBlockEntity.this.player.method_6047());
            stacks.addAll(DeployerBlockEntity.this.overflowItems);
            return stacks;
        }

        protected void readSnapshot(List<class_1799> snapshot) {
            class_1799 held = snapshot.remove(0);
            if (DeployerBlockEntity.this.player != null) {
                DeployerBlockEntity.this.player.method_6122(class_1268.field_5808, held);
            }
            DeployerBlockEntity.this.overflowItems = snapshot;
        }
    };
    ItemStackHandlerContainer recipeInv = new ItemStackHandlerContainer(2);
    SandPaperPolishingRecipe.SandPaperInv sandpaperInv = new SandPaperPolishingRecipe.SandPaperInv(class_1799.field_8037);

    public DeployerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = class_1799.field_8037;
        this.animatedOffset = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new DeployerFilterSlot());
        behaviours.add(this.filtering);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltDeployerCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltDeployerCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.TRAIN_CASING, AllAdvancements.ANDESITE_CASING, AllAdvancements.BRASS_CASING, AllAdvancements.COPPER_CASING, AllAdvancements.FIST_BUMP, AllAdvancements.DEPLOYER, AllAdvancements.SELF_DEPLOYING);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    private void initHandler() {
        if (this.invHandler != null) {
            return;
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 sLevel = (class_3218)class_19372;
            this.player = new DeployerFakePlayer(sLevel, this.owner);
            if (this.deferredInventoryList != null) {
                this.player.method_31548().method_7397(this.deferredInventoryList);
                this.deferredInventoryList = null;
                this.heldItem = this.player.method_6047();
                this.sendData();
            }
            class_243 initialPos = VecHelper.getCenterOf((class_2382)this.field_11867.method_10093((class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING)));
            this.player.method_5814(initialPos.field_1352, initialPos.field_1351, initialPos.field_1350);
        }
        this.invHandler = this.createHandler();
    }

    protected void onExtract(class_1799 stack) {
        this.player.method_6122(class_1268.field_5808, stack.method_7972());
        this.sendData();
        this.method_5431();
    }

    protected int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : class_3532.method_15363((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.overflowItems.isEmpty()) {
            this.overflowItems.removeIf(class_1799::method_7960);
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.field_11863.field_9236 && this.player != null && this.player.blockBreakingProgress != null && this.field_11863.method_22347((class_2338)this.player.blockBreakingProgress.getKey())) {
            this.field_11863.method_8517(this.player.method_5628(), (class_2338)this.player.blockBreakingProgress.getKey(), -1);
            this.player.blockBreakingProgress = null;
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.player == null) {
            return;
        }
        class_1799 stack = this.player.method_6047();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            boolean changed = false;
            class_1661 inventory = this.player.method_31548();
            for (int i = 0; i < inventory.method_5439() && this.overflowItems.size() <= 10; ++i) {
                class_1799 item = inventory.method_5438(i);
                if (item.method_7960() || item == stack && this.filtering.test(item)) continue;
                this.overflowItems.add(item);
                inventory.method_5447(i, class_1799.field_8037);
                changed = true;
            }
            if (changed) {
                this.sendData();
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.field_11863, this.field_11867.method_10079(facing, 2), facing)) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.fistBump && this.startFistBump(facing)) {
                return;
            }
            if (this.redstoneLocked) {
                return;
            }
            this.start();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.fistBump) {
                this.triggerFistBump();
            }
            this.activate();
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.sendData();
            return;
        }
    }

    protected void start() {
        this.state = State.EXPANDING;
        class_243 movementVector = this.getMovementVector();
        class_243 rayOrigin = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(movementVector.method_1021(1.5));
        class_243 rayTarget = VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(movementVector.method_1021(2.5));
        class_3959 rayTraceContext = new class_3959(rayOrigin, rayTarget, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)this.player);
        class_3965 result = this.field_11863.method_17742(rayTraceContext);
        this.reach = (float)(0.5 + Math.min(result.method_17784().method_1020(rayOrigin).method_1033(), 0.75));
        this.timer = 1000;
        this.sendData();
    }

    public boolean startFistBump(class_2350 facing) {
        int i = 0;
        KineticBlockEntity partner = null;
        for (i = 2; i < 5; ++i) {
            class_2338 otherDeployer = this.field_11867.method_10079(facing, i);
            if (!this.field_11863.method_8477(otherDeployer)) {
                return false;
            }
            class_2586 other = this.field_11863.method_8321(otherDeployer);
            if (!(other instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)other;
            partner = dpe;
            break;
        }
        if (partner == null) {
            return false;
        }
        if (((class_2350)this.field_11863.method_8320(partner.method_11016()).method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10153() != facing || ((DeployerBlockEntity)partner).mode != Mode.PUNCH) {
            return false;
        }
        if (partner.getSpeed() == 0.0f) {
            return false;
        }
        for (DeployerBlockEntity be : Arrays.asList(this, partner)) {
            be.fistBump = true;
            be.reach = (float)(i - 2) * 0.5f;
            be.timer = 1000;
            be.state = State.EXPANDING;
            be.sendData();
        }
        return true;
    }

    public void triggerFistBump() {
        int i = 0;
        SyncedBlockEntity deployerBlockEntity = null;
        for (i = 2; i < 5; ++i) {
            class_2338 pos = this.field_11867.method_10079((class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING), i);
            if (!this.field_11863.method_8477(pos)) {
                return;
            }
            class_2586 class_25862 = this.field_11863.method_8321(pos);
            if (!(class_25862 instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)class_25862;
            deployerBlockEntity = dpe;
            break;
        }
        if (deployerBlockEntity == null) {
            return;
        }
        if (!((DeployerBlockEntity)deployerBlockEntity).fistBump || ((DeployerBlockEntity)deployerBlockEntity).state != State.EXPANDING) {
            return;
        }
        if (((DeployerBlockEntity)deployerBlockEntity).timer > 0) {
            return;
        }
        this.fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).state = State.RETRACTING;
        ((DeployerBlockEntity)deployerBlockEntity).timer = 1000;
        deployerBlockEntity.sendData();
        this.award(AllAdvancements.FIST_BUMP);
        class_2338 soundLocation = class_2338.method_49638((class_2374)class_243.method_24953((class_2382)this.field_11867).method_1019(class_243.method_24953((class_2382)deployerBlockEntity.method_11016())).method_1021(0.5));
        this.field_11863.method_8396(null, soundLocation, class_3417.field_14914, class_3419.field_15245, 0.75f, 0.75f);
    }

    protected void activate() {
        class_243 movementVector = this.getMovementVector();
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING);
        class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
        class_2338 clickedPos = this.field_11867.method_10079(direction, 2);
        this.player.method_36457(direction == class_2350.field_11036 ? -90.0f : (direction == class_2350.field_11033 ? 90.0f : 0.0f));
        this.player.method_36456(direction.method_10144());
        if (direction == class_2350.field_11033 && BlockEntityBehaviour.get((class_1922)this.field_11863, clickedPos, TransportedItemStackHandlerBehaviour.TYPE) != null) {
            return;
        }
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        this.award(AllAdvancements.DEPLOYER);
        if (this.player != null) {
            this.heldItem = this.player.method_6047();
        }
    }

    protected class_243 getMovementVector() {
        if (!AllBlocks.DEPLOYER.has(this.method_11010())) {
            return class_243.field_1353;
        }
        return class_243.method_24954((class_2382)((class_2350)this.method_11010().method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10163());
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.mode = NBTHelper.readEnum(compound, "Mode", Mode.class);
        this.timer = compound.method_10550("Timer");
        this.redstoneLocked = compound.method_10577("Powered");
        if (compound.method_10545("Owner")) {
            this.owner = compound.method_25926("Owner");
        }
        this.deferredInventoryList = compound.method_10554("Inventory", 10);
        this.overflowItems = NBTHelper.readItemList(compound.method_10554("Overflow", 10));
        if (compound.method_10545("HeldItem")) {
            this.heldItem = class_1799.method_7915((class_2487)compound.method_10562("HeldItem"));
        }
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.fistBump = compound.method_10577("Fistbump");
        this.reach = compound.method_10583("Reach");
        if (compound.method_10545("Particle")) {
            class_1799 particleStack = class_1799.method_7915((class_2487)compound.method_10562("Particle"));
            SandPaperItem.spawnParticles(VecHelper.getCenterOf((class_2382)this.field_11867).method_1019(this.getMovementVector().method_1021((double)(this.reach + 1.0f))), particleStack, this.field_11863);
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        NBTHelper.writeEnum(compound, "Mode", this.mode);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.method_10569("Timer", this.timer);
        compound.method_10556("Powered", this.redstoneLocked);
        if (this.owner != null) {
            compound.method_25927("Owner", this.owner);
        }
        if (this.player != null) {
            class_2499 invNBT = new class_2499();
            this.player.method_31548().method_7384(invNBT);
            compound.method_10566("Inventory", (class_2520)invNBT);
            compound.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)this.player.method_6047()));
            compound.method_10566("Overflow", (class_2520)NBTHelper.writeItemList(this.overflowItems));
        } else if (this.deferredInventoryList != null) {
            compound.method_10566("Inventory", (class_2520)this.deferredInventoryList);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.method_10556("Fistbump", this.fistBump);
        compound.method_10548("Reach", this.reach);
        if (this.player == null) {
            return;
        }
        compound.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)this.player.method_6047()));
        if (this.player.spawnedItemEffects != null) {
            compound.method_10566("Particle", NBTSerializer.serializeNBT((Object)this.player.spawnedItemEffects));
            this.player.spawnedItemEffects = null;
        }
    }

    @Override
    public void writeSafe(class_2487 tag) {
        NBTHelper.writeEnum(tag, "Mode", this.mode);
        super.writeSafe(tag);
    }

    private DeployerItemHandler createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (this.field_11863.field_9236) {
            return;
        }
        boolean blockPowered = this.field_11863.method_49803(this.field_11867);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
    }

    @Environment(value=EnvType.CLIENT)
    public PartialModel getHandPose() {
        return this.mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : (this.heldItem.method_7960() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3.0);
    }

    public void discardPlayer() {
        if (this.player == null) {
            return;
        }
        this.player.method_31548().method_7388();
        this.overflowItems.forEach(itemstack -> this.player.method_7329((class_1799)itemstack, true, false));
        this.player.method_31472();
        this.player = null;
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.method_5431();
        this.sendData();
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        if (this.invHandler == null) {
            this.initHandler();
        }
        return this.invHandler;
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.overflowItems.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.full_deployer", new Object[0]);
        return true;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        Lang.translate("tooltip.deployer.header", new Object[0]).forGoggles(tooltip);
        Lang.translate("tooltip.deployer." + (this.mode == Mode.USE ? "using" : "punching"), new Object[0]).style(class_124.field_1054).forGoggles(tooltip);
        if (!this.heldItem.method_7960()) {
            Lang.translate("tooltip.deployer.contains", Components.translatable(this.heldItem.method_7922()).getString(), this.heldItem.method_7947()).style(class_124.field_1060).forGoggles(tooltip);
        }
        float stressAtBase = this.calculateStressApplied();
        if (IRotate.StressImpact.isEnabled() && !class_3532.method_15347((float)stressAtBase, (float)0.0f)) {
            tooltip.add(Components.immutableEmpty());
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public float getHandOffset(float partialTicks) {
        if (this.isVirtual()) {
            return this.animatedOffset.getValue(partialTicks);
        }
        float progress = 0.0f;
        int timerSpeed = this.getTimerSpeed();
        PartialModel handPose = this.getHandPose();
        if (this.state == State.EXPANDING) {
            progress = 1.0f - ((float)this.timer - partialTicks * (float)timerSpeed) / 1000.0f;
            if (this.fistBump) {
                progress *= progress;
            }
        }
        if (this.state == State.RETRACTING) {
            progress = ((float)this.timer - partialTicks * (float)timerSpeed) / 1000.0f;
        }
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f) * (this.reach + handLength), 1.3125f);
        return distance;
    }

    public void setAnimatedOffset(float offset) {
        this.animatedOffset.setValue(offset);
    }

    @Nullable
    public class_1860<? extends class_1263> getRecipe(class_1799 stack) {
        if (this.player == null || this.field_11863 == null) {
            return null;
        }
        class_1799 heldItemMainhand = this.player.method_6047();
        if (heldItemMainhand.method_7909() instanceof SandPaperItem) {
            this.sandpaperInv.method_5447(0, stack);
            return AllRecipeTypes.SANDPAPER_POLISHING.find(this.sandpaperInv, this.field_11863).orElse(null);
        }
        this.recipeInv.method_5447(0, stack);
        this.recipeInv.method_5447(1, heldItemMainhand);
        DeployerRecipeSearchEvent event = new DeployerRecipeSearchEvent(this, this.recipeInv);
        event.addRecipe(() -> SequencedAssemblyRecipe.getRecipe(this.field_11863, event.getInventory(), AllRecipeTypes.DEPLOYING.getType(), DeployerApplicationRecipe.class), 100);
        event.addRecipe(() -> AllRecipeTypes.DEPLOYING.find(event.getInventory(), this.field_11863), 50);
        event.addRecipe(() -> AllRecipeTypes.ITEM_APPLICATION.find(event.getInventory(), this.field_11863), 50);
        ((DeployerRecipeSearchEvent.DeployerRecipeSearchCallback)DeployerRecipeSearchEvent.EVENT.invoker()).handle(event);
        return event.getRecipe();
    }

    public DeployerFakePlayer getPlayer() {
        return this.player;
    }

    public List<class_1799> getOverflowItems() {
        return this.overflowItems;
    }

    static enum State {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

    }

    static enum Mode {
        PUNCH,
        USE;

    }
}

