/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.BackpackSlot;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.CombinedInvWrapper;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.RangedWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.InventoryUtils;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackInventory
implements ITravelersBackpackInventory {
    private InventoryImproved inventory = this.createInventory(Tiers.LEATHER.getAllSlots());
    private InventoryImproved craftingInventory = this.createInventory(9);
    private InventoryImproved fluidSlots = this.createTemporaryInventory();
    public SingleVariantStorage<FluidVariant> leftTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    public SingleVariantStorage<FluidVariant> rightTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final class_1657 player;
    private class_1799 stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;
    private final String LEFT_TANK = "LeftTank";
    private final String LEFT_TANK_AMOUNT = "LeftTankAmount";
    private final String RIGHT_TANK = "RightTank";
    private final String RIGHT_TANK_AMOUNT = "RightTankAmount";
    private final String COLOR = "Color";
    private final String SLEEPING_BAG_COLOR = "SleepingBagColor";
    private final String ABILITY = "Ability";
    private final String LAST_TIME = "LastTime";

    public TravelersBackpackInventory(@Nullable class_1799 stack, class_1657 player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        if (stack != null) {
            this.readAllData(stack.method_7948());
        }
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    public void readTier(class_2487 compound) {
        if (!compound.method_10545("Tier")) {
            compound.method_10569("Tier", TravelersBackpackConfig.enableTierUpgrades ? Tiers.LEATHER.getOrdinal() : Tiers.DIAMOND.getOrdinal());
        }
        if (compound.method_10573("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.method_10558("Tier"));
            compound.method_10551("Tier");
            compound.method_10569("Tier", tier.getOrdinal());
        }
        this.tier = Tiers.of(compound.method_10550("Tier"));
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public InventoryImproved getFluidSlotsInventory() {
        return this.fluidSlots;
    }

    @Override
    public class_1263 getCombinedInventory() {
        RangedWrapper additional = null;
        if (this.tier != Tiers.LEATHER) {
            additional = new RangedWrapper(this, this.getInventory(), 0, this.tier.getStorageSlots() - 18);
        }
        if (additional != null) {
            return new CombinedInvWrapper(this, additional, new RangedWrapper(this, this.getInventory(), additional.method_5439(), additional.method_5439() + 6), new RangedWrapper(this, this.getCraftingGridInventory(), 0, 3), new RangedWrapper(this, this.getInventory(), additional.method_5439() + 6, additional.method_5439() + 12), new RangedWrapper(this, this.getCraftingGridInventory(), 3, 6), new RangedWrapper(this, this.getInventory(), additional.method_5439() + 12, additional.method_5439() + 18), new RangedWrapper(this, this.getCraftingGridInventory(), 6, 9));
        }
        return new CombinedInvWrapper(this, new RangedWrapper(this, this.getInventory(), 0, 6), new RangedWrapper(this, this.getCraftingGridInventory(), 0, 3), new RangedWrapper(this, this.getInventory(), 6, 12), new RangedWrapper(this, this.getCraftingGridInventory(), 3, 6), new RangedWrapper(this, this.getInventory(), 12, 18), new RangedWrapper(this, this.getCraftingGridInventory(), 6, 9));
    }

    @Override
    public SingleVariantStorage<FluidVariant> getLeftTank() {
        return this.leftTank;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getRightTank() {
        return this.rightTank;
    }

    @Override
    public void writeItems(class_2487 compound) {
        InventoryUtils.writeNbt(compound, this.inventory.getStacks(), true, false);
        InventoryUtils.writeNbt(compound, this.craftingInventory.getStacks(), true, true);
    }

    @Override
    public void readItems(class_2487 compound) {
        this.inventory = this.createInventory(this.tier.getAllSlots());
        this.craftingInventory = this.createInventory(9);
        InventoryUtils.readNbt(compound, this.inventory.getStacks(), false);
        InventoryUtils.readNbt(compound, this.craftingInventory.getStacks(), true);
    }

    @Override
    public void writeTanks(class_2487 compound) {
        compound.method_10566("LeftTank", (class_2520)((FluidVariant)this.getLeftTank().variant).toNbt());
        compound.method_10566("RightTank", (class_2520)((FluidVariant)this.getRightTank().variant).toNbt());
        compound.method_10544("LeftTankAmount", this.getLeftTank().amount);
        compound.method_10544("RightTankAmount", this.getRightTank().amount);
    }

    @Override
    public void readTanks(class_2487 compound) {
        this.leftTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("LeftTank"));
        this.rightTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("RightTank"));
        this.leftTank.amount = compound.method_10537("LeftTankAmount");
        this.rightTank.amount = compound.method_10537("RightTankAmount");
    }

    @Override
    public void writeColor(class_2487 compound) {
    }

    @Override
    public void readColor(class_2487 compound) {
    }

    @Override
    public void writeSleepingBagColor(class_2487 compound) {
    }

    @Override
    public void readSleepingBagColor(class_2487 compound) {
    }

    @Override
    public void writeAbility(class_2487 compound) {
        compound.method_10556("Ability", this.ability);
    }

    @Override
    public void readAbility(class_2487 compound) {
        this.ability = !compound.method_10545("Ability") && TravelersBackpackConfig.forceAbilityEnabled || compound.method_10577("Ability");
    }

    @Override
    public void writeTime(class_2487 compound) {
        compound.method_10569("LastTime", this.lastTime);
    }

    @Override
    public void readTime(class_2487 compound) {
        this.lastTime = compound.method_10550("LastTime");
    }

    @Override
    public void writeAllData(class_2487 compound) {
        this.writeItems(compound);
        this.writeTanks(compound);
        this.writeAbility(compound);
        this.writeTime(compound);
        this.slotManager.writeUnsortableSlots(compound);
        this.slotManager.writeMemorySlots(compound);
        this.settingsManager.writeSettings(compound);
    }

    @Override
    public void readAllData(class_2487 compound) {
        this.readTier(compound);
        this.readItems(compound);
        this.readTanks(compound);
        this.readAbility(compound);
        this.readTime(compound);
        this.slotManager.readUnsortableSlots(compound);
        this.slotManager.readMemorySlots(compound);
        this.settingsManager.readSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_LEFT), this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), this.tier.getSlotIndex(Tiers.SlotType.BUCKET_IN_RIGHT), this.player);
    }

    public void sendPackets() {
        if (this.screenID == 2) {
            ComponentUtils.sync(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.stack.method_7948().method_10545("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.stack.method_7948().method_10550("Color");
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.method_7948().method_10545("SleepingBagColor");
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.stack.method_7948().method_10550("SleepingBagColor");
        }
        return class_1767.field_7964.method_7789();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.enableBackpackAbilities ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().method_7909()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public class_1937 method_10997() {
        return this.player.method_37908();
    }

    @Override
    public class_2338 getPosition() {
        return this.player.method_24515();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack == null ? class_1799.field_8037 : this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable class_1657 player) {
    }

    @Override
    public void markDataDirty(byte ... dataIds) {
        if (this.method_10997().field_9236 || this.stack == null) {
            return;
        }
        for (byte data : dataIds) {
            switch (data) {
                case 0: {
                    InventoryUtils.writeNbt(this.stack.method_7948(), this.inventory.getStacks(), true, false);
                }
                case 1: {
                    InventoryUtils.writeNbt(this.stack.method_7948(), this.craftingInventory.getStacks(), true, true);
                }
                case 2: {
                    this.writeItems(this.stack.method_7948());
                }
                case 3: {
                    this.writeTanks(this.stack.method_7948());
                }
                case 4: {
                    this.writeColor(this.stack.method_7948());
                }
                case 5: {
                    this.writeSleepingBagColor(this.stack.method_7948());
                }
                case 6: {
                    this.writeAbility(this.stack.method_7948());
                }
                case 7: {
                    this.writeTime(this.stack.method_7948());
                }
                case 8: {
                    this.slotManager.writeUnsortableSlots(this.stack.method_7948());
                    this.slotManager.writeMemorySlots(this.stack.method_7948());
                }
                case 9: {
                    this.settingsManager.writeSettings(this.stack.method_7948());
                }
                case 10: {
                    this.writeAllData(this.stack.method_7948());
                }
            }
        }
        this.sendPackets();
    }

    @Override
    public void method_5431() {
    }

    public static void abilityTick(class_1657 player) {
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
            TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
            if (!inv.method_10997().field_9236 && inv.getLastTime() > 0) {
                inv.setLastTime(inv.getLastTime() - 1);
                inv.markDataDirty(7);
            }
            if (inv.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(ComponentUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openHandledScreen(class_1657 player, final class_1799 stack, final byte screenID) {
        if (!player.method_37908().field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.writeByte((int)screenID);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    if (screenID == 2) {
                        return new TravelersBackpackItemScreenHandler(syncId, inv, ComponentUtils.getBackpackInv(player));
                    }
                    return new TravelersBackpackItemScreenHandler(syncId, inv, new TravelersBackpackInventory(stack, player, screenID));
                }
            });
        }
    }

    public InventoryImproved createInventory(int size) {
        return new InventoryImproved(class_2371.method_10213((int)size, (Object)class_1799.field_8037)){

            @Override
            public void method_5431() {
                TravelersBackpackInventory.this.markDataDirty(2);
            }

            @Override
            public boolean method_5437(int slot, class_1799 stack) {
                if (BackpackSlot.BLACKLISTED_ITEMS.contains(stack.method_7909())) {
                    return false;
                }
                return !(stack.method_7909() instanceof TravelersBackpackItem) && !stack.method_31573(ModTags.BLACKLISTED_ITEMS) && (TravelersBackpackConfig.allowShulkerBoxes || stack.method_7909().method_31568());
            }
        };
    }

    public SingleVariantStorage<FluidVariant> createFluidTank(long capacity) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return TravelersBackpackInventory.this.tier.getTankCapacity();
            }

            protected void onFinalCommit() {
                TravelersBackpackInventory.this.markDataDirty(3);
            }
        };
    }
}

