/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.compat.trinkets.TrinketsCompat;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.apache.commons.lang3.tuple.Triple;

public class TravelersBackpackFeature
extends class_3887<class_742, class_591<class_742>> {
    public TravelersBackpackWearableModel<class_742> model;

    public TravelersBackpackFeature(class_3883<class_742, class_591<class_742>> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        TravelersBackpackInventory inv;
        if (TravelersBackpackConfig.disableBackpackRender) {
            return;
        }
        if (ComponentUtils.isWearingBackpack((class_1657)entity) && (inv = ComponentUtils.getBackpackInv((class_1657)entity)) != null && !entity.method_5767()) {
            if (TravelersBackpack.enableTrinkets() && TrinketsCompat.getTravelersBackpackTrinket((class_1657)entity).method_7909() instanceof TravelersBackpackItem) {
                this.renderLayer(matrices, vertexConsumers, light, entity, inv);
            }
            class_1799 stack = entity.method_6118(class_1304.field_6174);
            if (!TravelersBackpackConfig.renderBackpackWithElytra) {
                if (stack.method_7909() instanceof class_1770) {
                    return;
                }
                this.renderLayer(matrices, vertexConsumers, light, entity, inv);
            } else {
                this.renderLayer(matrices, vertexConsumers, light, entity, inv);
            }
        }
    }

    private void renderLayer(class_4587 matrices, class_4597 vertexConsumers, int light, class_742 entity, ITravelersBackpackInventory inv) {
        boolean flag;
        this.model = new TravelersBackpackWearableModel((class_1309)entity, vertexConsumers, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).method_32109());
        boolean bl = flag = inv.getItemStack().method_7909() == ModItems.QUARTZ_TRAVELERS_BACKPACK || inv.getItemStack().method_7909() == ModItems.SNOW_TRAVELERS_BACKPACK;
        if (inv.getItemStack().method_7960()) {
            return;
        }
        class_2960 id = ResourceUtils.getBackpackTexture(inv.getItemStack().method_7909());
        boolean isColorable = false;
        boolean isCustomSleepingBag = false;
        if (inv.getItemStack().method_7969() != null && inv.getItemStack().method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK && BackpackDyeRecipe.hasColor(inv.getItemStack())) {
            isColorable = true;
            id = new class_2960("travelersbackpack", "textures/model/dyed.png");
        }
        if (inv.getItemStack().method_7969() != null && inv.getItemStack().method_7969().method_10545("SleepingBagColor")) {
            isCustomSleepingBag = true;
        }
        class_4588 vertexConsumer = vertexConsumers.getBuffer(flag ? class_1921.method_23689((class_2960)id) : class_1921.method_23572((class_2960)id));
        matrices.method_22903();
        if (entity.method_5715()) {
            matrices.method_22904(0.0, -0.155, 0.025);
        }
        ((class_591)this.method_17165()).method_2818(this.model);
        this.model.setupAngles((class_572<class_742>)((class_572)this.method_17165()));
        matrices.method_22904(0.0, 0.175, 0.325);
        matrices.method_22905(0.85f, 0.85f, 0.85f);
        if (isColorable) {
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(inv.getItemStack()));
            this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            id = new class_2960("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)id));
        }
        this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        id = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(inv.getSleepingBagColor()) : ResourceUtils.getDefaultSleepingBagTexture();
        vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23576((class_2960)id));
        this.model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 0.25f);
        matrices.method_22909();
    }
}

