/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.mixin.leashing;

import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1532;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2740;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1690.class})
public abstract class BoatMixin
implements BoatLeashAccess {
    private static final String LEASH_TAG = "Leash";
    @Nullable
    private class_1297 leashHolder;
    private int delayedLeashHolderId;
    @Nullable
    private class_2487 leashInfoTag;

    private class_1690 self() {
        return (class_1690)this;
    }

    private boolean isClientSide() {
        return this.self().method_37908().method_8608();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickLeash(CallbackInfo ci) {
        if (!this.isClientSide() && (this.self() instanceof Leashable || this.self().getClass().equals(class_1690.class))) {
            this.tickLeash();
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveDataAdditionalShipData(class_2487 compoundTag, CallbackInfo ci) {
        if (this.leashHolder != null) {
            class_2487 leashTag = new class_2487();
            if (this.leashHolder instanceof class_1309) {
                UUID uUID = this.leashHolder.method_5667();
                leashTag.method_25927("UUID", uUID);
            } else if (this.leashHolder instanceof class_1530) {
                class_2338 blockPos = ((class_1530)this.leashHolder).method_6896();
                leashTag.method_10569("X", blockPos.method_10263());
                leashTag.method_10569("Y", blockPos.method_10264());
                leashTag.method_10569("Z", blockPos.method_10260());
            }
            compoundTag.method_10566(LEASH_TAG, (class_2520)leashTag);
        } else if (this.leashInfoTag != null) {
            compoundTag.method_10566(LEASH_TAG, (class_2520)this.leashInfoTag.method_10553());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveDataAdditionalShipData(class_2487 compoundTag, CallbackInfo ci) {
        if (compoundTag.method_10573(LEASH_TAG, 10)) {
            this.leashInfoTag = compoundTag.method_10562(LEASH_TAG);
        }
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactLeashShip(class_1657 player, class_1268 interactionHand, CallbackInfoReturnable<class_1269> cir) {
        if (this.self() instanceof Leashable || this.self().getClass().equals(class_1690.class)) {
            class_1799 itemStack;
            if (this.getLeashHolder() == player) {
                this.dropLeash(true, !player.method_31549().field_7477);
                cir.setReturnValue((Object)class_1269.method_29236((boolean)this.isClientSide()));
            }
            if ((itemStack = player.method_5998(interactionHand)).method_31574(class_1802.field_8719) && this.canBeLeashed()) {
                this.setLeashedTo((class_1297)player, true);
                itemStack.method_7934(1);
                cir.setReturnValue((Object)class_1269.method_29236((boolean)this.isClientSide()));
            }
        }
    }

    protected void tickLeash() {
        class_1297 entity;
        if (this.leashInfoTag != null) {
            this.restoreLeashFromSave();
        }
        if (!(this.leashHolder == null || this.self().method_5805() && this.leashHolder.method_5805())) {
            this.dropLeash(true, true);
        }
        if ((entity = this.getLeashHolder()) != null && entity.method_37908() == this.self().method_37908()) {
            float distanceToHolderEntity = this.self().method_5739(entity);
            if (distanceToHolderEntity > 10.0f) {
                this.dropLeash(true, true);
            } else if (distanceToHolderEntity > 6.0f) {
                double d1 = (entity.method_23317() - this.self().method_23317()) / (double)distanceToHolderEntity;
                double d2 = (entity.method_23318() - this.self().method_23318()) / (double)distanceToHolderEntity;
                double d3 = (entity.method_23321() - this.self().method_23321()) / (double)distanceToHolderEntity;
                double shipWeight = this.self() instanceof Leashable ? (double)(-((Leashable)this.self()).getDefaultShipWeight() / (((Leashable)this.self()).getDefaultShipWeight() + 1.0f) + 1.0f) : (double)0.4f;
                this.self().method_18799(this.self().method_18798().method_1031(Math.copySign(d1 * d1 * shipWeight, d1), Math.copySign(d2 * d2 * shipWeight, d2), Math.copySign(d3 * d3 * shipWeight, d3)));
            }
        }
    }

    @Override
    public void dropLeash(boolean shouldUnlink, boolean shouldDropItem) {
        if (this.leashHolder != null) {
            class_1937 class_19372;
            this.leashHolder = null;
            this.leashInfoTag = null;
            if (!this.isClientSide() && shouldDropItem) {
                this.self().method_5870((class_1935)class_1802.field_8719, 4);
            }
            if (!this.isClientSide() && shouldUnlink && (class_19372 = this.self().method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_14178().method_18754((class_1297)this.self(), (class_2596)new class_2740((class_1297)this.self(), null));
            }
        }
    }

    public boolean canBeLeashed() {
        return !this.isLeashed() && !(this.self().method_31483() instanceof class_1657);
    }

    @Override
    public boolean isLeashed() {
        return this.leashHolder != null;
    }

    @Override
    @Nullable
    public class_1297 getLeashHolder() {
        if (this.leashHolder == null && this.delayedLeashHolderId != 0 && this.isClientSide()) {
            this.leashHolder = this.self().method_37908().method_8469(this.delayedLeashHolderId);
        }
        return this.leashHolder;
    }

    @Override
    public void setLeashedTo(class_1297 entity, boolean shouldLink) {
        class_1937 class_19372;
        this.leashHolder = entity;
        this.leashInfoTag = null;
        if (!this.isClientSide() && shouldLink && (class_19372 = this.self().method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_18754((class_1297)this.self(), (class_2596)new class_2740((class_1297)this.self(), this.leashHolder));
        }
        if (this.self().method_5765()) {
            this.self().method_5848();
        }
    }

    @Override
    public void setDelayedLeashHolderId(int i) {
        this.delayedLeashHolderId = i;
        this.dropLeash(false, false);
    }

    private void restoreLeashFromSave() {
        class_1937 class_19372;
        if (this.leashInfoTag != null && (class_19372 = this.self().method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.leashInfoTag.method_25928("UUID")) {
                UUID uUID = this.leashInfoTag.method_25926("UUID");
                class_1297 entity = serverLevel.method_14190(uUID);
                if (entity != null) {
                    this.setLeashedTo(entity, true);
                    return;
                }
            } else if (this.leashInfoTag.method_10573("X", 99) && this.leashInfoTag.method_10573("Y", 99) && this.leashInfoTag.method_10573("Z", 99)) {
                class_2338 blockPos = class_2512.method_10691((class_2487)this.leashInfoTag);
                this.setLeashedTo((class_1297)class_1532.method_6932((class_1937)this.self().method_37908(), (class_2338)blockPos), true);
                return;
            }
            if (this.self().field_6012 > 100) {
                this.self().method_5870((class_1935)class_1802.field_8719, 4);
                this.leashInfoTag = null;
            }
        }
    }
}

