/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.WorldInit;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6624;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public class DimensionStructure
extends class_3195 {
    public static final Codec<DimensionStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DimensionStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.STRING.fieldOf("dungeon_type").forGetter(structure -> structure.dungeonType)).apply((Applicative)instance, DimensionStructure::new)).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final String dungeonType;

    public DimensionStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, String dungeonType) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.dungeonType = dungeonType;
    }

    private static boolean extraSpawningChecks(class_3195.class_7149 context) {
        class_1923 chunkpos = context.comp_568();
        return context.comp_562().method_18028(chunkpos.method_8326(), chunkpos.method_8328(), class_2902.class_2903.field_13203, context.comp_569(), context.comp_564()) < 150;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (!DimensionStructure.extraSpawningChecks(context)) {
            return Optional.empty();
        }
        int startY = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_1923 chunkPos = context.comp_568();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), startY, chunkPos.method_8328());
        Optional structurePiecesGenerator = class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        return structurePiecesGenerator;
    }

    public void method_38694(class_5281 world, class_5138 structureAccessor, class_2794 chunkGenerator, class_5819 random, class_3341 box, class_1923 chunkPos, class_6624 pieces) {
        ArrayList list = new ArrayList();
        pieces.comp_132().forEach(piece -> {
            for (int i = piece.method_14935().method_35415(); i <= piece.method_14935().method_35418(); ++i) {
                for (int u = piece.method_14935().method_35416(); u <= piece.method_14935().method_35419(); ++u) {
                    for (int o = piece.method_14935().method_35417(); o <= piece.method_14935().method_35420(); ++o) {
                        class_2338 pos = new class_2338(i, u, o);
                        if (world.method_8320(pos).method_26215() || list.contains(pos) || !world.method_8320(pos).method_27852(BlockInit.DUNGEON_PORTAL)) continue;
                        list.add(pos);
                    }
                }
            }
        });
        if (!list.isEmpty()) {
            DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)world.method_8321((class_2338)list.get(0));
            dungeonPortalEntity.setDungeonType(this.dungeonType);
            dungeonPortalEntity.setDifficulty(dungeonPortalEntity.getDungeon().getDifficultyList().get(0));
            dungeonPortalEntity.setMaxGroupSize(dungeonPortalEntity.getDungeon().getMaxGroupSize());
            dungeonPortalEntity.setMinGroupSize(dungeonPortalEntity.getDungeon().getMinGroupSize());
            dungeonPortalEntity.method_5431();
        }
    }

    public class_7151<?> method_41618() {
        return WorldInit.DIMENSION_STRUCTURES;
    }
}

