/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.network;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.dungeonz.access.ClientPlayerAccess;
import net.dungeonz.block.entity.DungeonGateEntity;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.block.screen.DungeonGateOpScreen;
import net.dungeonz.block.screen.DungeonPortalOpScreen;
import net.dungeonz.block.screen.DungeonPortalScreen;
import net.dungeonz.block.screen.DungeonPortalScreenHandler;
import net.dungeonz.item.screen.DungeonCompassScreen;
import net.dungeonz.network.DungeonServerPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DungeonClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DungeonServerPacket.DUNGEON_INFO_PACKET, (client, handler, buf, sender) -> {
            IntList breakableBlockIdList = buf.method_34059();
            IntList placeableBlockIdList = buf.method_34059();
            boolean allowElytra = buf.readBoolean();
            client.execute(() -> DungeonClientPacket.lambda$init$0(client, (List)breakableBlockIdList, (List)placeableBlockIdList, allowElytra));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DungeonServerPacket.SYNC_SCREEN_PACKET, (client, handler, buf, sender) -> {
            class_2338 dungeonPortalPos = buf.method_10811();
            String difficulty = buf.method_19772();
            client.execute(() -> {
                if (client.field_1687.method_8321(dungeonPortalPos) != null && client.field_1687.method_8321(dungeonPortalPos) instanceof DungeonPortalEntity) {
                    DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)client.field_1687.method_8321(dungeonPortalPos);
                    dungeonPortalEntity.setDifficulty(difficulty);
                    if (client.field_1755 instanceof DungeonPortalScreen) {
                        ((DungeonPortalScreen)client.field_1755).difficultyButton.setText((class_2561)class_2561.method_43471((String)("dungeonz.difficulty." + difficulty)));
                    }
                    if (client.field_1724.field_7512 instanceof DungeonPortalScreenHandler) {
                        ((DungeonPortalScreenHandler)client.field_1724.field_7512).getDungeonPortalEntity().setDifficulty(difficulty);
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DungeonServerPacket.OP_SCREEN_PACKET, (client, handler, buf, sender) -> {
            String portalOrGate = buf.method_19772();
            class_2338 portalOrGatePos = buf.method_10811();
            String dungeonTypeOrBlockId = buf.method_19772();
            String difficultyOrParticleId = buf.method_19772();
            String unlockItemId = portalOrGate.equals("gate") ? buf.method_19772() : "";
            client.execute(() -> {
                if (client.field_1687.method_8321(portalOrGatePos) != null) {
                    if (client.field_1687.method_8321(portalOrGatePos) instanceof DungeonPortalEntity) {
                        DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)client.field_1687.method_8321(portalOrGatePos);
                        dungeonPortalEntity.setDungeonType(dungeonTypeOrBlockId);
                        dungeonPortalEntity.setDifficulty(difficultyOrParticleId);
                        client.method_1507((class_437)new DungeonPortalOpScreen(portalOrGatePos));
                    } else if (client.field_1687.method_8321(portalOrGatePos) instanceof DungeonGateEntity) {
                        DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)client.field_1687.method_8321(portalOrGatePos);
                        dungeonGateEntity.setBlockId(new class_2960(dungeonTypeOrBlockId));
                        dungeonGateEntity.setParticleEffectId(difficultyOrParticleId);
                        dungeonGateEntity.setUnlockItemId(unlockItemId);
                        client.method_1507((class_437)new DungeonGateOpScreen(portalOrGatePos));
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DungeonServerPacket.COMPASS_SCREEN_PACKET, (client, handler, buf, sender) -> {
            String dungeonType = buf.method_19772();
            int dungeonCount = buf.readInt();
            ArrayList<String> dungeonIds = new ArrayList<String>();
            for (int i = 0; i < dungeonCount; ++i) {
                dungeonIds.add(buf.method_19772());
            }
            client.execute(() -> client.method_1507((class_437)new DungeonCompassScreen(dungeonType, dungeonIds)));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)DungeonServerPacket.SYNC_GATE_BLOCK_PACKET, (client, handler, buf, sender) -> {
            int posListSize = buf.readInt();
            ArrayList<class_2338> dungeonGatesPosList = new ArrayList<class_2338>();
            for (int i = 0; i < posListSize; ++i) {
                dungeonGatesPosList.add(buf.method_10811());
            }
            String blockId = buf.method_19772();
            String particleId = buf.method_19772();
            String unlockItemId = buf.method_19772();
            client.execute(() -> {
                for (int i = 0; i < dungeonGatesPosList.size(); ++i) {
                    if (client.field_1687.method_8321((class_2338)dungeonGatesPosList.get(i)) == null || !(client.field_1687.method_8321((class_2338)dungeonGatesPosList.get(i)) instanceof DungeonGateEntity)) continue;
                    DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)client.field_1687.method_8321((class_2338)dungeonGatesPosList.get(i));
                    dungeonGateEntity.setBlockId(new class_2960(blockId));
                    dungeonGateEntity.setParticleEffectId(particleId);
                    dungeonGateEntity.setUnlockItemId(unlockItemId);
                }
            });
        });
    }

    public static void writeC2SChangeDifficultyPacket(class_310 client, class_2338 portalBlockPos) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        class_2817 packet = new class_2817(DungeonServerPacket.CHANGE_DUNGEON_DIFFICULTY_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SChangeEffectsPacket(class_310 client, class_2338 portalBlockPos, boolean disableEffects) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        buf.writeBoolean(disableEffects);
        class_2817 packet = new class_2817(DungeonServerPacket.CHANGE_DUNGEON_EFFECTS_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SChangePrivateGroupPacket(class_310 client, class_2338 portalBlockPos, boolean privateGroup) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        buf.writeBoolean(privateGroup);
        class_2817 packet = new class_2817(DungeonServerPacket.CHANGE_DUNGEON_PRIVATE_GROUP_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SDungeonTeleportPacket(class_310 client, class_2338 portalBlockPos, @Nullable UUID requiredMinGroupUuid) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        buf.writeBoolean(requiredMinGroupUuid != null);
        if (requiredMinGroupUuid != null) {
            buf.method_10797(requiredMinGroupUuid);
        }
        class_2817 packet = new class_2817(DungeonServerPacket.DUNGEON_TELEPORT_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SSetDungeonTypePacket(class_310 client, String dungeonType, String defaultDifficulty, class_2338 portalBlockPos) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        buf.method_10814(dungeonType);
        buf.method_10814(defaultDifficulty);
        class_2817 packet = new class_2817(DungeonServerPacket.SET_DUNGEON_TYPE_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SSetGateBlockPacket(class_310 client, String blockId, String particleId, String unlockItemId, class_2338 portalBlockPos) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(portalBlockPos);
        buf.method_10814(blockId);
        buf.method_10814(particleId);
        buf.method_10814(unlockItemId);
        class_2817 packet = new class_2817(DungeonServerPacket.SET_GATE_BLOCK_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    public static void writeC2SSetDungeonCompassPacket(class_310 client, String dungeonType) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(dungeonType);
        class_2817 packet = new class_2817(DungeonServerPacket.SET_DUNGEON_COMPASS_PACKET, buf);
        client.method_1562().method_2883((class_2596)packet);
    }

    private static /* synthetic */ void lambda$init$0(class_310 client, List breakableBlockIdList, List placeableBlockIdList, boolean allowElytra) {
        ((ClientPlayerAccess)client.field_1724).setClientDungeonInfo(breakableBlockIdList, placeableBlockIdList, allowElytra);
    }
}

