/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.dungeon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dungeonz.DungeonzMain;
import net.dungeonz.access.BossEntityAccess;
import net.dungeonz.access.ServerPlayerAccess;
import net.dungeonz.block.DungeonGateBlock;
import net.dungeonz.block.entity.DungeonGateEntity;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.block.entity.DungeonSpawnerEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.TagInit;
import net.dungeonz.util.InventoryHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3730;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.rpgdifficulty.api.MobStrengthener;
import org.jetbrains.annotations.Nullable;

public class DungeonPlacementHandler {
    public static class_5454 enter(class_3222 serverPlayerEntity, class_3218 dungeonWorld, class_3218 oldWorld, DungeonPortalEntity portalEntity, class_2338 portalPos, String difficulty, boolean disableEffects) {
        class_2338.class_2339 playerBlockPos = serverPlayerEntity.method_24515().method_25503();
        if (oldWorld.method_8320((class_2338)playerBlockPos).method_27852(BlockInit.DUNGEON_PORTAL) || oldWorld.method_8320(playerBlockPos.method_10074()).method_27852(BlockInit.DUNGEON_PORTAL)) {
            if (oldWorld.method_8320((class_2338)playerBlockPos).method_27852(BlockInit.DUNGEON_PORTAL)) {
                playerBlockPos = playerBlockPos.method_10084();
            }
            for (int i = 0; i < 4; ++i) {
                if (oldWorld.method_8320(playerBlockPos.method_10079(class_2350.method_10139((int)i), 1).method_10086(0)).method_26215() && oldWorld.method_8320(playerBlockPos.method_10079(class_2350.method_10139((int)i), 1).method_10086(1)).method_26215()) {
                    playerBlockPos = playerBlockPos.method_10079(class_2350.method_10139((int)i), 1);
                    break;
                }
                if (i != 3) continue;
                playerBlockPos = class_2338.method_49638((class_2374)((class_2374)class_1657.method_26091((class_3218)oldWorld.method_8503().method_3847(serverPlayerEntity.method_26281()), (class_2338)((ServerPlayerAccess)serverPlayerEntity).getDungeonSpawnBlockPos(), (float)0.0f, (boolean)true, (boolean)true).get()));
            }
        }
        ((ServerPlayerAccess)serverPlayerEntity).setDungeonInfo(oldWorld, portalPos, (class_2338)playerBlockPos);
        if (disableEffects) {
            serverPlayerEntity.method_6012();
        }
        class_2338 newPos = new class_2338(0, 0, 0).method_10069(portalPos.method_10263() * 16, 100, portalPos.method_10260() * 16);
        if (!portalEntity.isDungeonStructureGenerated()) {
            portalEntity.setDungeonStructureGenerated();
            DungeonPlacementHandler.spawnDungeonStructure((class_1937)dungeonWorld, newPos, portalEntity);
        }
        Dungeon dungeon = portalEntity.getDungeon();
        if (portalEntity.getDungeonPlayerCount() == 0) {
            DungeonPlacementHandler.refreshDungeon(serverPlayerEntity.field_13995, dungeonWorld, portalEntity, dungeon, difficulty, disableEffects);
        }
        portalEntity.joinDungeon(serverPlayerEntity.method_5667());
        return new class_5454(class_243.method_24954((class_2382)newPos).method_1031(0.5, 0.0, 0.5), class_243.field_1353, 0.0f, 0.0f);
    }

    public static class_5454 leave(class_3222 serverPlayerEntity, class_3218 serverWorld) {
        if (serverWorld.method_8321(((ServerPlayerAccess)serverPlayerEntity).getDungeonPortalBlockPos()) != null) {
            ((DungeonPortalEntity)serverWorld.method_8321(((ServerPlayerAccess)serverPlayerEntity).getDungeonPortalBlockPos())).leaveDungeon(serverPlayerEntity.method_5667());
        }
        return new class_5454(class_243.method_24954((class_2382)((ServerPlayerAccess)serverPlayerEntity).getDungeonSpawnBlockPos()).method_1031(0.5, 0.0, 0.5), class_243.field_1353, serverWorld.field_9229.method_43057() * 360.0f, 0.0f);
    }

    private static void spawnDungeonStructure(class_1937 world, class_2338 pos, DungeonPortalEntity portalEntity) {
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41249);
        class_6880.class_6883 registryEntry = registry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)portalEntity.getDungeon().getStructurePoolId()));
        DungeonPlacementHandler.generate((class_3218)world, portalEntity, portalEntity.getDungeon(), (class_6880<class_3785>)registryEntry, new class_2960("dungeonz:spawn"), 64, pos, false);
    }

    private static boolean generate(class_3218 world, DungeonPortalEntity portalEntity, Dungeon dungeon, class_6880<class_3785> structurePool, class_2960 id, int size, class_2338 pos, boolean keepJigsaws) {
        class_2794 chunkGenerator = world.method_14178().method_12129();
        class_3485 structureTemplateManager = world.method_14183();
        class_5138 structureAccessor = world.method_27056();
        class_5819 random = world.method_8409();
        class_3195.class_7149 context = new class_3195.class_7149(world.method_30349(), chunkGenerator, chunkGenerator.method_12098(), world.method_14178().method_41248(), structureTemplateManager, world.method_8412(), new class_1923(pos), (class_5539)world, registryEntry -> true);
        Optional optional = class_3778.method_30419((class_3195.class_7149)context, structurePool, Optional.of(id), (int)size, (class_2338)pos, (boolean)false, Optional.empty(), (int)512);
        if (optional.isPresent()) {
            HashMap<Integer, ArrayList<class_2338>> blockIdPosMap = new HashMap<Integer, ArrayList<class_2338>>();
            ArrayList<class_2338> chestPosList = new ArrayList<class_2338>();
            ArrayList<class_2338> exitPosList = new ArrayList<class_2338>();
            ArrayList<class_2338> gatePosList = new ArrayList<class_2338>();
            HashMap<class_2338, Integer> spawnerPosEntityIdMap = new HashMap<class_2338, Integer>();
            class_2248 exitBlock = (class_2248)class_7923.field_41175.method_10200(dungeon.getExitBlockId());
            class_2248 bossLootBlock = (class_2248)class_7923.field_41175.method_10200(dungeon.getBossLootBlockId());
            class_6626 structurePiecesCollector = ((class_3195.class_7150)optional.get()).method_44019();
            for (class_3443 structurePiece : structurePiecesCollector.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                poolStructurePiece.method_27236((class_5281)world, structureAccessor, chunkGenerator, random, class_3341.method_14665(), pos, keepJigsaws);
                portalEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35415(), poolStructurePiece.method_14935().method_35416(), poolStructurePiece.method_14935().method_35417());
                portalEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35418(), poolStructurePiece.method_14935().method_35419(), poolStructurePiece.method_14935().method_35420());
                for (int i = poolStructurePiece.method_14935().method_35415(); i <= poolStructurePiece.method_14935().method_35418(); ++i) {
                    for (int u = poolStructurePiece.method_14935().method_35416(); u <= poolStructurePiece.method_14935().method_35419(); ++u) {
                        for (int o = poolStructurePiece.method_14935().method_35417(); o <= poolStructurePiece.method_14935().method_35420(); ++o) {
                            class_2338 checkPos = new class_2338(i, u, o);
                            if (world.method_8320(checkPos).method_26215()) continue;
                            int blockId = class_7923.field_41175.method_10206((Object)world.method_8320(checkPos).method_26204());
                            if (dungeon.containsBlockId(blockId)) {
                                if (!blockIdPosMap.containsKey(blockId)) {
                                    ArrayList<class_2338> newList = new ArrayList<class_2338>();
                                    newList.add(checkPos);
                                    blockIdPosMap.put(blockId, newList);
                                    continue;
                                }
                                blockIdPosMap.get(blockId).add(checkPos);
                                continue;
                            }
                            if (dungeon.getBossBlockId() == blockId) {
                                portalEntity.setBossBlockPos(checkPos);
                                continue;
                            }
                            if (world.method_8320(checkPos).method_27852(class_2246.field_10034) || world.method_8320(checkPos).method_27852(class_2246.field_16328)) {
                                chestPosList.add(checkPos);
                                continue;
                            }
                            if (world.method_8320(checkPos).method_27852(exitBlock)) {
                                exitPosList.add(checkPos);
                                continue;
                            }
                            if (world.method_8320(checkPos).method_27852(bossLootBlock)) {
                                portalEntity.setBossLootBlockPos(checkPos);
                                continue;
                            }
                            if (world.method_8320(checkPos).method_27852(BlockInit.DUNGEON_SPAWNER)) {
                                spawnerPosEntityIdMap.put(checkPos, ((DungeonSpawnerEntity)world.method_8321(checkPos)).getLogic().getEntityId());
                                continue;
                            }
                            if (!world.method_8320(checkPos).method_27852(BlockInit.DUNGEON_GATE)) continue;
                            gatePosList.add(checkPos);
                            if (world.method_8321(checkPos) == null || ((DungeonGateEntity)world.method_8321(checkPos)).getUnlockItem() != null) continue;
                            DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)world.method_8321(checkPos);
                            dungeonGateEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35415(), poolStructurePiece.method_14935().method_35416(), poolStructurePiece.method_14935().method_35417());
                            dungeonGateEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35418(), poolStructurePiece.method_14935().method_35419(), poolStructurePiece.method_14935().method_35420());
                            dungeonGateEntity.method_5431();
                        }
                    }
                }
            }
            portalEntity.setChestPosList(chestPosList);
            portalEntity.setExitPosList(exitPosList);
            portalEntity.setBlockMap(blockIdPosMap);
            portalEntity.setSpawnerPosEntityIdMap(spawnerPosEntityIdMap);
            portalEntity.setGatePosList(gatePosList);
            portalEntity.method_5431();
            return true;
        }
        return false;
    }

    private static void refreshDungeon(MinecraftServer server, class_3218 world, DungeonPortalEntity portalEntity, Dungeon dungeon, String difficulty, boolean luck) {
        int i;
        for (int i2 = 0; i2 < portalEntity.getDungeonEdgeList().size() / 6; ++i2) {
            List entities = world.method_8335(null, new class_238((double)portalEntity.getDungeonEdgeList().get(6 * i2).intValue(), (double)portalEntity.getDungeonEdgeList().get(1 + 6 * i2).intValue(), (double)portalEntity.getDungeonEdgeList().get(2 + 6 * i2).intValue(), (double)portalEntity.getDungeonEdgeList().get(3 + 6 * i2).intValue(), (double)portalEntity.getDungeonEdgeList().get(4 + 6 * i2).intValue(), (double)portalEntity.getDungeonEdgeList().get(5 + 6 * i2).intValue()));
            for (int u = 0; u < entities.size(); ++u) {
                ((class_1297)entities.get(u)).method_5650(class_1297.class_5529.field_26999);
            }
        }
        portalEntity.setDifficulty(difficulty);
        portalEntity.getBlockMap().forEach((blockId, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                if (dungeon.getBlockIdBlockReplacementMap().get(blockId) != -1) {
                    if (dungeon.getBlockIdBlockReplacementMap().get(blockId) == 0) {
                        world.method_8650((class_2338)list.get(i), false);
                    } else {
                        world.method_8652((class_2338)list.get(i), ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(blockId).intValue())).method_9564(), 3);
                    }
                }
                if (!(world.method_8409().method_43057() <= dungeon.getBlockIdEntitySpawnChanceMap().get(blockId).get(difficulty).floatValue())) continue;
                class_1308 mobEntity = DungeonPlacementHandler.createMob(world, dungeon.getBlockIdEntityMap().get(blockId).get(world.method_8409().method_43048(dungeon.getBlockIdEntityMap().get(blockId).size())), null);
                mobEntity.method_5943((class_5425)world, world.method_8404((class_2338)list.get(i)), class_3730.field_16474, null, null);
                mobEntity.method_5971();
                DungeonPlacementHandler.strengthenMob(mobEntity, dungeon, difficulty, false);
                dungeon.getBlockIdBlockReplacementMap().get(blockId);
                mobEntity.method_5725((class_2338)list.get(i), 360.0f * world.method_8409().method_43057(), 0.0f);
                world.method_8649((class_1297)mobEntity);
            }
        });
        class_1308 bossEntity = DungeonPlacementHandler.createMob(world, dungeon.getBossEntityType(), dungeon.getBossNbtCompound());
        bossEntity.method_5943((class_5425)world, world.method_8404(portalEntity.getBossBlockPos()), class_3730.field_16474, null, null);
        bossEntity.method_5971();
        ((BossEntityAccess)bossEntity).setBoss(portalEntity.method_11016(), portalEntity.method_10997().method_27983().method_29177().toString());
        DungeonPlacementHandler.strengthenMob(bossEntity, dungeon, difficulty, true);
        if (dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()) != -1) {
            if (dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()) == 0) {
                world.method_8650(portalEntity.getBossBlockPos(), false);
            } else {
                world.method_8652(portalEntity.getBossBlockPos(), ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()).intValue())).method_9564(), 3);
            }
        }
        bossEntity.method_5725(portalEntity.getBossBlockPos(), 360.0f * world.method_8409().method_43057(), 0.0f);
        world.method_8649((class_1297)bossEntity);
        for (i = 0; i < portalEntity.getChestPosList().size(); ++i) {
            String lootTableString = dungeon.getDifficultyLootTableIdMap().get(difficulty).get(world.method_8409().method_43048(dungeon.getDifficultyLootTableIdMap().get(difficulty).size()));
            InventoryHelper.fillInventoryWithLoot(server, world, portalEntity.getChestPosList().get(i), lootTableString, luck);
        }
        for (i = 0; i < portalEntity.getExitPosList().size(); ++i) {
            world.method_8652(portalEntity.getExitPosList().get(i), dungeon.getBlockIdBlockReplacementMap().containsKey(dungeon.getExitBlockId()) && dungeon.getBlockIdBlockReplacementMap().get(dungeon.getExitBlockId()) != -1 ? ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getExitBlockId()).intValue())).method_9564() : ((class_2248)class_7923.field_41175.method_10200(dungeon.getExitBlockId())).method_9564(), 3);
        }
        for (i = 0; i < portalEntity.getGatePosList().size(); ++i) {
            world.method_8501(portalEntity.getGatePosList().get(i), (class_2680)world.method_8320(portalEntity.getGatePosList().get(i)).method_28493((class_2769)DungeonGateBlock.ENABLED));
        }
        world.method_8652(portalEntity.getBossLootBlockPos(), dungeon.getBlockIdBlockReplacementMap().containsKey(dungeon.getBossLootBlockId()) && dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossLootBlockId()) != -1 ? ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossLootBlockId()).intValue())).method_9564() : ((class_2248)class_7923.field_41175.method_10200(dungeon.getBossLootBlockId())).method_9564(), 3);
        for (Map.Entry<class_2338, Integer> entry : portalEntity.getSpawnerPosEntityIdMap().entrySet()) {
            world.method_8652(entry.getKey(), BlockInit.DUNGEON_SPAWNER.method_9564(), 3);
            ((DungeonSpawnerEntity)world.method_8321(entry.getKey())).getLogic().setDungeonInfo(dungeon, difficulty, dungeon.getSpawnerEntityIdMap().containsKey(entry.getValue()) ? dungeon.getSpawnerEntityIdMap().get(entry.getValue()) : 0, (class_1299)class_7923.field_41177.method_10200(entry.getValue().intValue()));
        }
        for (Map.Entry<class_2338, Integer> entry : portalEntity.getReplaceBlockIdMap().entrySet()) {
            world.method_8652(entry.getKey(), ((class_2248)class_7923.field_41175.method_10200(entry.getValue().intValue())).method_9564(), 3);
        }
        portalEntity.getDungeonPlayerUuids().clear();
        portalEntity.getDeadDungeonPlayerUUIDs().clear();
        portalEntity.method_5431();
    }

    @Nullable
    private static class_1308 createMob(class_3218 world, class_1299<?> type, @Nullable class_2487 nbt) {
        class_2487 nbtCompound;
        class_1308 mobEntity;
        try {
            class_1297 entity = type.method_5883((class_1937)world);
            if (!(entity instanceof class_1308)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + class_7923.field_41177.method_10221(type));
            }
            mobEntity = (class_1308)entity;
        }
        catch (Exception exception) {
            DungeonzMain.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
        if (nbt != null) {
            nbtCompound = mobEntity.method_5647(new class_2487());
            nbtCompound.method_10543(nbt);
            mobEntity.method_5651(nbtCompound);
        }
        if (mobEntity.method_5864().method_20210(TagInit.IMMUNE_TO_ZOMBIFICATION)) {
            nbtCompound = mobEntity.method_5647(new class_2487());
            nbtCompound.method_10556("IsImmuneToZombification", true);
            mobEntity.method_5651(nbtCompound);
        }
        return mobEntity;
    }

    public static void strengthenMob(class_1308 mobEntity, Dungeon dungeon, String difficulty, boolean isBossEntity) {
        double mobHealth = mobEntity.method_26825(class_5134.field_23716);
        double mobDamage = 0.0;
        double mobProtection = 0.0;
        boolean hasAttackDamageAttribute = mobEntity.method_6127().method_27306(class_5134.field_23721);
        boolean hasArmorAttribute = mobEntity.method_6127().method_27306(class_5134.field_23724);
        if (hasAttackDamageAttribute) {
            mobDamage = mobEntity.method_26825(class_5134.field_23721);
        }
        if (hasArmorAttribute) {
            mobProtection = mobEntity.method_26825(class_5134.field_23724);
        }
        float strengthFactor = 0.0f;
        strengthFactor = isBossEntity ? dungeon.getDifficultyBossModificatorMap().get(difficulty).floatValue() : dungeon.getDifficultyMobModificatorMap().get(difficulty).floatValue();
        mobHealth *= (double)strengthFactor;
        mobDamage *= (double)strengthFactor;
        mobProtection *= (double)strengthFactor;
        mobHealth = (double)Math.round(mobHealth * 100.0) / 100.0;
        mobDamage = (double)Math.round(mobDamage * 100.0) / 100.0;
        mobProtection = (double)Math.round(mobProtection * 100.0) / 100.0;
        mobEntity.method_5996(class_5134.field_23716).method_6192(mobHealth);
        mobEntity.method_6025(mobEntity.method_6063());
        if (hasAttackDamageAttribute) {
            mobEntity.method_5996(class_5134.field_23721).method_6192(mobDamage);
        }
        if (hasArmorAttribute) {
            mobEntity.method_5996(class_5134.field_23724).method_6192(mobProtection);
        }
        if (DungeonzMain.isRpgDifficultyLoaded) {
            MobStrengthener.setMobHealthMultiplier((class_1308)mobEntity, (float)strengthFactor);
        }
    }
}

