/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.block.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.UUID;
import net.dungeonz.DungeonzMain;
import net.dungeonz.block.screen.DungeonPortalScreenHandler;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.network.DungeonClientPacket;
import net.dungeonz.util.InventoryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.partyaddon.access.GroupManagerAccess;
import net.partyaddon.group.GroupManager;

@Environment(value=EnvType.CLIENT)
public class DungeonPortalScreen
extends class_465<DungeonPortalScreenHandler>
implements class_1712 {
    private static class_2960 TEXTURE = new class_2960("dungeonz:textures/gui/dungeon_portal.png");
    private static final class_2960 ICONS = new class_2960("dungeonz:textures/gui/dungeon_icons.png");
    private static final class_2561 JOIN = class_2561.method_43471((String)"dungeon.task.join");
    private static final class_2561 LEAVE = class_2561.method_43471((String)"dungeon.task.leave");
    public DungeonDifficultyButton difficultyButton;
    private DungeonButton dungeonButton;
    private DungeonSliderButton effectButton;
    private DungeonSliderButton privateButton;
    private final class_1657 playerEntity;

    public DungeonPortalScreen(DungeonPortalScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.playerEntity = inventory.field_7546;
        TEXTURE = handler.getBackgroundId() != null ? handler.getBackgroundId() : TEXTURE;
        this.field_2792 = 256;
        this.field_2779 = 222;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 = this.field_22789 / 2 - this.field_2792 / 2;
        this.field_2800 = this.field_22790 / 2 - this.field_2779 / 2;
        ((DungeonPortalScreenHandler)this.field_2797).method_7596(this);
        boolean playerIsInDungeonWorld = this.playerEntity.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD;
        class_2561 buttonText = playerIsInDungeonWorld ? LEAVE : JOIN;
        this.dungeonButton = (DungeonButton)this.method_37063((class_364)new DungeonButton(this.field_2776 + this.field_2792 / 2 - 26, this.field_2800 + this.field_2779 - 28, buttonText, button -> {
            if (button.field_22763) {
                DungeonClientPacket.writeC2SDungeonTeleportPacket(this.field_22787, ((DungeonPortalScreenHandler)this.field_2797).getPos(), this.playerEntity.method_5667());
                ((DungeonPortalScreenHandler)this.field_2797).setWaitingGroupSize(((DungeonPortalScreenHandler)this.field_2797).getWaitingGroupSize() + 1);
                button.field_22763 = false;
            }
        }));
        this.difficultyButton = (DungeonDifficultyButton)this.method_37063((class_364)new DungeonDifficultyButton(this.field_2776 + 144, this.field_2800 + 36, class_2561.method_30163((String)""), button -> {
            if (button.field_22763) {
                DungeonClientPacket.writeC2SChangeDifficultyPacket(this.field_22787, ((DungeonPortalScreenHandler)this.field_2797).getPos());
            }
        }));
        this.effectButton = (DungeonSliderButton)this.method_37063((class_364)new DungeonSliderButton(this.field_2776 + 144, this.field_2800 + 63, button -> {
            if (button.field_22763) {
                ((DungeonSliderButton)button).cycleEnabled();
                ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().setDisableEffects(((DungeonSliderButton)button).isEnabled());
                DungeonClientPacket.writeC2SChangeEffectsPacket(this.field_22787, ((DungeonPortalScreenHandler)this.field_2797).getPos(), ((DungeonSliderButton)button).isEnabled());
            }
        }));
        this.privateButton = (DungeonSliderButton)this.method_37063((class_364)new DungeonSliderButton(this.field_2776 + 144, this.field_2800 + 79, button -> {
            if (button.field_22763) {
                ((DungeonSliderButton)button).cycleEnabled();
                DungeonClientPacket.writeC2SChangePrivateGroupPacket(this.field_22787, ((DungeonPortalScreenHandler)this.field_2797).getPos(), ((DungeonSliderButton)button).isEnabled());
            }
        }));
        this.effectButton.enabled = !((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDisableEffects();
        this.privateButton.enabled = ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getPrivateGroup();
        if (playerIsInDungeonWorld) {
            this.dungeonButton.field_22763 = true;
            this.difficultyButton.field_22763 = false;
            this.effectButton.field_22763 = false;
            this.privateButton.field_22763 = false;
        } else {
            if (((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() > 0) {
                this.difficultyButton.field_22763 = false;
                this.effectButton.field_22763 = false;
                this.privateButton.field_22763 = false;
            } else {
                this.difficultyButton.field_22763 = true;
                this.effectButton.field_22763 = true;
                this.privateButton.field_22763 = true;
            }
            this.dungeonButton.field_22763 = ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() + ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().size() < ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getMaxGroupSize() && InventoryHelper.hasRequiredItemStacks(this.playerEntity.method_31548(), ((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks()) && !((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().contains(this.playerEntity.method_5667());
            if (this.dungeonButton.field_22763 && this.privateButton.enabled && ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() > 0) {
                if (DungeonzMain.isPartyAddonLoaded) {
                    GroupManager groupManager = ((GroupManagerAccess)this.playerEntity).getGroupManager();
                    if (groupManager.getGroupPlayerIdList().isEmpty() || !groupManager.getGroupPlayerIdList().contains(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().get(0))) {
                        this.dungeonButton.field_22763 = false;
                    }
                } else {
                    this.dungeonButton.field_22763 = false;
                }
            }
        }
        if (((DungeonPortalScreenHandler)this.field_2797).getDifficulties().contains(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty())) {
            this.difficultyButton.setText((class_2561)class_2561.method_43471((String)("dungeonz.difficulty." + ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty())));
        } else {
            this.difficultyButton.setText((class_2561)class_2561.method_43471((String)("dungeonz.difficulty." + ((DungeonPortalScreenHandler)this.field_2797).getDifficulties().get(0))));
        }
    }

    private class_2561 getPlayerName(UUID playerId, int length, int substringLength) {
        if (this.field_22787.method_1562().method_2871(playerId) != null) {
            Object playerName = this.field_22787.method_1562().method_2871(playerId).method_2966().getName();
            if (this.field_22787.field_1772.method_1727((String)playerName) > length && substringLength != 0) {
                playerName = ((String)playerName).substring(0, substringLength) + "..";
            }
            return class_2561.method_30163((String)playerName);
        }
        return class_2561.method_43471((String)"text.dungeonz.empty_name");
    }

    public void method_37432() {
        super.method_37432();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int l;
        this.method_25420(context);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51439(this.field_22793, this.field_22785, this.field_2776 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, this.field_2800 + 8, 0x404040, false);
        int k = this.field_2800 + 37;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"text.dungeonz.player_list", (Object[])new Object[]{((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() + ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().size(), ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getMaxGroupSize()}), this.field_2776 + 8, this.field_2800 + 24, 0x3F3F3F, false);
        for (int i = 0; i < ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() && i < 13; ++i) {
            String playerName = this.getPlayerName(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().get(i), 102, 15).getString();
            if (i == 12) {
                playerName = "...";
                if (this.method_2378(13, k, 16, 7, mouseX, mouseY)) {
                    ArrayList<class_2561> otherPlayerNames = new ArrayList<class_2561>();
                    for (int u = 12; u < ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size(); ++u) {
                        otherPlayerNames.add(this.getPlayerName(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().get(u), 102, 15));
                    }
                    context.method_51434(this.field_22793, otherPlayerNames, mouseX, mouseY);
                }
            }
            context.method_51433(this.field_22793, playerName, this.field_2776 + 13, k, 0xFFFFFF, false);
            k += 13;
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.dungeonz.required"), this.field_2776 + 139, this.field_2800 + 100, 0x3F3F3F, false);
        context.method_25302(ICONS, this.field_2776 + 142 + this.field_22793.method_27525((class_5348)class_2561.method_43471((String)"text.dungeonz.required")), this.field_2800 + 97, 52 + (InventoryHelper.hasRequiredItemStacks(this.playerEntity.method_31548(), ((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks()) ? 0 : 14), 0, 14, 14);
        if (((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks().size() > 0) {
            l = 0;
            for (int i = 0; i < ((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks().size(); ++i) {
                context.method_51427(((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks().get(i), this.field_2776 + 144 + l, this.field_2800 + 112);
                context.method_51431(this.field_22793, ((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks().get(i), this.field_2776 + 144 + l, this.field_2800 + 112);
                if (this.method_2378(144 + l, 112, 16, 16, mouseX, mouseY)) {
                    context.method_51438(this.field_22793, ((DungeonPortalScreenHandler)this.field_2797).getRequiredItemStacks().get(i).method_7964(), mouseX, mouseY);
                }
                l += 18;
            }
        } else {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.dungeonz.nothing_required"), this.field_2776 + 144, this.field_2800 + 112, 0x3F3F3F, false);
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.dungeonz.possible"), this.field_2776 + 139, this.field_2800 + 134, 0x3F3F3F, false);
        if (((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().size() > 0 && ((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().containsKey(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()) && ((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().get(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()).size() > 0) {
            l = 0;
            int o = 0;
            for (int i = 0; i < ((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().get(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()).size() && i < 10; ++i) {
                context.method_51427(((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().get(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()).get(i), this.field_2776 + 144 + l, this.field_2800 + o + 146);
                context.method_51431(this.field_22793, ((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().get(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()).get(i), this.field_2776 + 144 + l, this.field_2800 + o + 146);
                if (this.method_2378(144 + l, o + 146, 16, 16, mouseX, mouseY)) {
                    context.method_51438(this.field_22793, ((DungeonPortalScreenHandler)this.field_2797).getPossibleLootDifficultyItemStackMap().get(((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDifficulty()).get(i).method_7964(), mouseX, mouseY);
                }
                l += 18;
                if (i != 4) continue;
                l = 0;
                o = 18;
            }
        }
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"dungeonz.difficulty"), this.field_2776 + 139, this.field_2800 + 24, 0x3F3F3F, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.dungeonz.effects"), this.field_2776 + 169, this.field_2800 + 65, 0x3F3F3F, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"text.dungeonz.private"), this.field_2776 + 169, this.field_2800 + 81, 0x3F3F3F, false);
        if (((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getDungeonPlayerCount() <= 0 && ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getMinGroupSize() > 1) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"text.dungeonz.waiting_player_list", (Object[])new Object[]{((DungeonPortalScreenHandler)this.field_2797).getWaitingGroupSize(), ((DungeonPortalScreenHandler)this.field_2797).getDungeonPortalEntity().getMinGroupSize()}), this.field_2776 + 159, this.field_2800 + 200, 0x3F3F3F, false);
        }
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_7635(class_1703 var1, int var2, class_1799 var3) {
    }

    public void method_7633(class_1703 var1, int var2, int var3) {
    }

    public class DungeonButton
    extends class_4185 {
        public DungeonButton(int x, int y, class_2561 text, class_4185.class_4241 onPress) {
            super(x, y, 52, 20, text, onPress, field_40754);
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            int j = 20;
            if (!this.field_22763) {
                j = 0;
            } else if (this.method_49606()) {
                j = 40;
            }
            context.method_25302(ICONS, this.method_46426(), this.method_46427(), 0, j, this.field_22758, this.field_22759);
            int o = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            context.method_27534(DungeonPortalScreen.this.field_22793, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, o | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
            if (!this.field_22763 && this.method_49606()) {
                class_5250 text = null;
                if (((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().isOnCooldown((int)((DungeonPortalScreen)DungeonPortalScreen.this).field_22787.field_1687.method_8510())) {
                    int cooldown = (((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getCooldownTime() - (int)((DungeonPortalScreen)DungeonPortalScreen.this).field_22787.field_1687.method_8510()) / 20;
                    int seconds = cooldown % 60;
                    int minutes = cooldown / 60 % 60;
                    int hours = cooldown / 60 / 60;
                    text = class_2561.method_43469((String)"text.dungeonz.dungeon_cooldown_time", (Object[])new Object[]{hours, minutes, seconds});
                } else if (((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getDungeonPlayerUuids().size() + ((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().size() >= ((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getMaxGroupSize()) {
                    text = class_2561.method_43471((String)"text.dungeonz.dungeon_full");
                } else if (((DungeonPortalScreen)DungeonPortalScreen.this).field_22787.field_1724 != null && !((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().isEmpty() && ((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getDungeonPortalEntity().getDeadDungeonPlayerUUIDs().contains(((DungeonPortalScreen)DungeonPortalScreen.this).field_22787.field_1724.method_5667())) {
                    text = class_2561.method_43471((String)"text.dungeonz.dead_player");
                } else if (!InventoryHelper.hasRequiredItemStacks(((DungeonPortalScreen)DungeonPortalScreen.this).field_22787.field_1724.method_31548(), ((DungeonPortalScreenHandler)DungeonPortalScreen.this.field_2797).getRequiredItemStacks())) {
                    text = class_2561.method_43471((String)"text.dungeonz.missing");
                }
                if (text != null) {
                    context.method_51438(DungeonPortalScreen.this.field_22793, (class_2561)text, mouseX, mouseY);
                }
            }
        }
    }

    public class DungeonDifficultyButton
    extends class_4185 {
        private class_2561 text;

        public DungeonDifficultyButton(int x, int y, class_2561 text, class_4185.class_4241 onPress) {
            super(x, y, 60, 20, text, onPress, field_40754);
            this.text = text;
        }

        public void setText(class_2561 text) {
            this.text = text;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            class_310 minecraftClient = class_310.method_1551();
            class_327 textRenderer = minecraftClient.field_1772;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
            int i = this.getTextureY();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            context.method_25302(field_22757, this.method_46426(), this.method_46427(), 0, 46 + i * 20, this.field_22758 / 2, this.field_22759);
            context.method_25302(field_22757, this.method_46426() + this.field_22758 / 2, this.method_46427(), 200 - this.field_22758 / 2, 46 + i * 20, this.field_22758 / 2, this.field_22759);
            int j = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
            context.method_27534(textRenderer, this.text, this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, j | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private int getTextureY() {
            int i = 1;
            if (!this.field_22763) {
                i = 0;
            } else if (this.method_25367()) {
                i = 2;
            }
            return i;
        }
    }

    public class DungeonSliderButton
    extends class_4185 {
        private boolean enabled;

        public DungeonSliderButton(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 20, 12, class_2561.method_30163((String)""), onPress, field_40754);
            this.enabled = false;
        }

        public void cycleEnabled() {
            this.enabled = !this.enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int i = 60;
            if (this.enabled) {
                i = 72;
            }
            int j = 0;
            if (!this.field_22763) {
                j = 40;
            } else if (this.method_49606()) {
                j = 20;
            }
            context.method_25302(ICONS, this.method_46426(), this.method_46427(), j, i, this.field_22758, this.field_22759);
        }
    }
}

