/*
 * Decompiled with CFR 0.152.
 */
package net.xolt.freecam.config;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;

@Config(name="freecam")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static ModConfig INSTANCE;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public MovementConfig movement = new MovementConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public CollisionConfig collision = new CollisionConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public VisualConfig visual = new VisualConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public UtilityConfig utility = new UtilityConfig();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public NotificationConfig notification = new NotificationConfig();

    public static void init() {
        AutoConfig.register(ModConfig.class, JanksonConfigSerializer::new);
        INSTANCE = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
    }

    public static class MovementConfig {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public FlightMode flightMode = FlightMode.DEFAULT;
        @ConfigEntry.Gui.Tooltip
        public double horizontalSpeed = 1.0;
        @ConfigEntry.Gui.Tooltip
        public double verticalSpeed = 1.0;
    }

    public static class CollisionConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean ignoreTransparent = true;
        @ConfigEntry.Gui.Tooltip
        public boolean ignoreOpenable = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean ignoreAll = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean alwaysCheck = false;
    }

    public static class VisualConfig {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public Perspective perspective = Perspective.INSIDE;
        @ConfigEntry.Gui.Tooltip
        public boolean showPlayer = true;
        @ConfigEntry.Gui.Tooltip
        public boolean showHand = false;
        @ConfigEntry.Gui.Tooltip
        public boolean fullBright = false;
        @ConfigEntry.Gui.Tooltip
        public boolean showSubmersion = false;
    }

    public static class UtilityConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean disableOnDamage = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean freezePlayer = false;
        @ConfigEntry.Gui.Tooltip(count=2)
        public boolean allowInteract = false;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public InteractionMode interactionMode = InteractionMode.CAMERA;
    }

    public static class NotificationConfig {
        @ConfigEntry.Gui.Tooltip
        public boolean notifyFreecam = true;
        @ConfigEntry.Gui.Tooltip
        public boolean notifyTripod = true;
    }

    public static enum Perspective implements SelectionListEntry.Translatable
    {
        FIRST_PERSON("text.autoconfig.freecam.option.visual.perspective.firstPerson"),
        THIRD_PERSON("text.autoconfig.freecam.option.visual.perspective.thirdPerson"),
        THIRD_PERSON_MIRROR("text.autoconfig.freecam.option.visual.perspective.thirdPersonMirror"),
        INSIDE("text.autoconfig.freecam.option.visual.perspective.inside");

        private final String name;

        private Perspective(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.name;
        }
    }

    public static enum InteractionMode implements SelectionListEntry.Translatable
    {
        CAMERA("text.autoconfig.freecam.option.utility.interactionMode.camera"),
        PLAYER("text.autoconfig.freecam.option.utility.interactionMode.player");

        private final String name;

        private InteractionMode(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.name;
        }
    }

    public static enum FlightMode implements SelectionListEntry.Translatable
    {
        CREATIVE("text.autoconfig.freecam.option.movement.flightMode.creative"),
        DEFAULT("text.autoconfig.freecam.option.movement.flightMode.default");

        private final String name;

        private FlightMode(String name) {
            this.name = name;
        }

        public String getKey() {
            return this.name;
        }
    }
}

