/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biomeperimeters;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.terraformersmc.biolith.api.biomeperimeters.BiomePerimeters;
import com.terraformersmc.biolith.impl.Biolith;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2355;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomePerimetersImpl
implements BiomePerimeters {
    private static final Hashtable<class_1959, BiomePerimetersImpl> instances = new Hashtable(4);
    private final class_1959 biome;
    private final int cardinalHorizon;
    private final int ordinalHorizon;
    private final int checkDistance;
    public static final int MAX_HORIZON = 256;
    private static final long COMPACTION_TIMER_TICKS = 300L;
    private final LoadingCache<class_1923, CacheRecord> caches = CacheBuilder.newBuilder().maximumSize(4096L).expireAfterAccess(30L, TimeUnit.SECONDS).weakValues().build((CacheLoader)new CacheLoader<class_1923, CacheRecord>(){

        @NotNull
        public CacheRecord load(@NotNull class_1923 key) {
            return new CacheRecord();
        }
    });
    private static final int MAX_THREAD_LOCAL_CACHE_SIZE = 128;
    private final ThreadLocal<Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord>> threadLocalCaches = ThreadLocal.withInitial(Object2ObjectLinkedOpenHashMap::new);

    private CacheRecord getCache(Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord> threadLocal, class_1923 pos) {
        CacheRecord cached = (CacheRecord)threadLocal.getAndMoveToFirst((Object)pos);
        if (cached != null) {
            return cached;
        }
        CacheRecord newOne = (CacheRecord)this.caches.getUnchecked((Object)pos);
        threadLocal.putAndMoveToFirst((Object)pos, (Object)newOne);
        if (threadLocal.size() > 128) {
            threadLocal.removeLast();
        }
        return newOne;
    }

    BiomePerimetersImpl(class_1959 biome) {
        this(biome, 64);
    }

    BiomePerimetersImpl(class_1959 biome, int horizon) {
        if (horizon < 1 || horizon > 256) {
            Biolith.LOGGER.debug("BiomePerimetersImpl horizon must be in the range [1,{}]: {}", (Object)256, (Object)horizon);
            horizon = 256;
        }
        this.biome = biome;
        this.cardinalHorizon = horizon;
        this.ordinalHorizon = (int)((double)horizon / Math.sqrt(2.0));
        this.checkDistance = (int)((float)horizon * 0.89f);
    }

    @Override
    public int getPerimeterDistance(class_4543 biomeAccess, class_2338 pos) {
        int cached;
        float minimum = this.cardinalHorizon + 1;
        Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord> threadLocalCache = this.threadLocalCaches.get();
        for (class_2355 direction : class_2355.values()) {
            if (this.checkBiome(biomeAccess, pos.method_10069(direction.method_42015(), 0, direction.method_42016()), threadLocalCache)) continue;
            return 0;
        }
        CacheRecord cache = this.getCache(threadLocalCache, new class_1923(pos));
        int idx = CacheRecord.getIndex(pos);
        if (cache.biomeCache.containsKey(idx) && (cached = cache.biomeCache.get(idx)) > 0) {
            return cached;
        }
        block1: for (class_2355 direction : class_2355.values()) {
            int horizon = direction.ordinal() % 2 == 0 ? this.cardinalHorizon : this.ordinalHorizon;
            int dx = direction.method_42015();
            int dz = direction.method_42016();
            block2: for (int radius = 0; radius < horizon; ++radius) {
                class_2338 iterPos = pos.method_10069(dx * radius, 0, dz * radius);
                CacheRecord cache2 = this.getCache(threadLocalCache, new class_1923(iterPos));
                if (!cache2.perimeters.containsKey(CacheRecord.getIndex(iterPos)) && this.checkBiome(biomeAccess, iterPos.method_10069(dx, 0, dz), threadLocalCache)) continue;
                int localMinimum = this.checkPerimeter(biomeAccess, pos, iterPos, direction, threadLocalCache);
                if (localMinimum >= 0) {
                    minimum = Math.min(minimum, (float)localMinimum);
                    continue block1;
                }
                ++radius;
                while (radius < horizon) {
                    if (this.checkBiome(biomeAccess, pos.method_10069(dx * radius, 0, dz * radius), threadLocalCache)) {
                        ++radius;
                        continue block2;
                    }
                    ++radius;
                }
            }
        }
        return this.rationalizeDistance(pos, minimum, threadLocalCache);
    }

    private int checkPerimeter(class_4543 biomeAccess, class_2338 centerPos, class_2338 perimeterPos, class_2355 direction, Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord> threadLocalCache) {
        BiomePerimeterPoint prospectPoint;
        class_2338 prospect;
        int rotation;
        int check;
        CacheRecord perimeterPosCache = this.getCache(threadLocalCache, new class_1923(perimeterPos));
        int perimeterPosIndex = CacheRecord.getIndex(perimeterPos);
        BiomePerimeterPoint current = (BiomePerimeterPoint)perimeterPosCache.perimeters.computeIfAbsent(perimeterPosIndex, k -> BiomePerimeterPoint.of(perimeterPos));
        double minimum = current.getDistance(centerPos);
        int localCheckDistance = Math.min(this.checkDistance, (int)(minimum * minimum) - 1);
        class_2355 orientation = direction;
        for (check = 0; check < localCheckDistance; ++check) {
            if (current.left != null) {
                orientation = this.getEightWayRelation(current.left.pos, current.pos);
            } else {
                orientation = this.getEightWayClockwiseRotation(orientation, 5);
                for (rotation = 2; rotation < 8; ++rotation) {
                    if (this.checkBiome(biomeAccess, current.pos.method_10069((orientation = this.getEightWayClockwiseRotation(orientation, 1)).method_42015(), 0, orientation.method_42016()), threadLocalCache)) continue;
                    prospect = current.pos.method_10069((orientation = this.getEightWayClockwiseRotation(orientation, -1)).method_42015(), 0, orientation.method_42016());
                    prospectPoint = (BiomePerimeterPoint)this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)prospect)).perimeters.get(CacheRecord.getIndex(prospect));
                    if (prospectPoint != null) {
                        prospectPoint.setRight(current);
                        current.setLeft(prospectPoint);
                        break;
                    }
                    current.setLeft(BiomePerimeterPoint.leftOf(prospect, current));
                    this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)current.left.pos)).perimeters.put(CacheRecord.getIndex(current.left.pos), (Object)current.left);
                    break;
                }
            }
            if (current.left == null) break;
            if (perimeterPos.method_10265((class_2382)current.left.pos) == 0) {
                if (check < 16) {
                    return -1;
                }
                return (int)minimum;
            }
            current = current.left;
            minimum = Math.min(minimum, current.getDistance(centerPos));
        }
        current = (BiomePerimeterPoint)perimeterPosCache.perimeters.get(perimeterPosIndex);
        orientation = direction;
        for (check = 0; check < localCheckDistance; ++check) {
            if (current.right != null) {
                orientation = this.getEightWayRelation(current.right.pos, current.pos);
            } else {
                orientation = this.getEightWayClockwiseRotation(orientation, 3);
                for (rotation = 2; rotation < 8; ++rotation) {
                    if (this.checkBiome(biomeAccess, current.pos.method_10069((orientation = this.getEightWayClockwiseRotation(orientation, -1)).method_42015(), 0, orientation.method_42016()), threadLocalCache)) continue;
                    prospect = current.pos.method_10069((orientation = this.getEightWayClockwiseRotation(orientation, 1)).method_42015(), 0, orientation.method_42016());
                    prospectPoint = (BiomePerimeterPoint)this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)prospect)).perimeters.get(CacheRecord.getIndex(prospect));
                    if (prospectPoint != null) {
                        if (current.equals(prospectPoint.right)) {
                            prospectPoint.right = null;
                        } else {
                            prospectPoint.setLeft(current);
                        }
                        current.setRight(prospectPoint);
                        break;
                    }
                    current.setRight(BiomePerimeterPoint.rightOf(prospect, current));
                    this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)current.right.pos)).perimeters.put(CacheRecord.getIndex(current.right.pos), (Object)current.right);
                    break;
                }
            }
            if (current.right == null || perimeterPos.method_10265((class_2382)current.right.pos) == 0) break;
            current = current.right;
            minimum = Math.min(minimum, current.getDistance(centerPos));
        }
        return (int)minimum;
    }

    private class_2355 getEightWayClockwiseRotation(class_2355 direction, int increment) {
        assert (increment >= -8);
        return class_2355.values()[(direction.ordinal() + increment + 8) % 8];
    }

    private class_2355 getEightWayRelation(class_2338 posA, class_2338 posB) {
        class_2338 diff = posA.method_10059((class_2382)posB);
        if (diff.method_10263() < 0) {
            if (diff.method_10260() < 0) {
                return class_2355.field_11076;
            }
            if (diff.method_10260() > 0) {
                return class_2355.field_11068;
            }
            return class_2355.field_11072;
        }
        if (diff.method_10263() > 0) {
            if (diff.method_10260() < 0) {
                return class_2355.field_11074;
            }
            if (diff.method_10260() > 0) {
                return class_2355.field_11070;
            }
            return class_2355.field_11075;
        }
        return diff.method_10260() < 0 ? class_2355.field_11069 : class_2355.field_11073;
    }

    private boolean checkBiome(class_4543 biomeAccess, class_2338 pos, Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord> threadLocalCache) {
        return this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)pos)).biomeCache.computeIfAbsent(CacheRecord.getIndex(pos), key -> ((class_1959)biomeAccess.method_22393(pos).comp_349()).equals(this.biome) ? -1 : 0) != 0;
    }

    private int rationalizeDistance(class_2338 pos, float proposed, Object2ObjectLinkedOpenHashMap<class_1923, CacheRecord> threadLocalCache) {
        float lower = 0.0f;
        float upper = 256.0f;
        for (class_2355 direction : class_2355.values()) {
            class_2338 neighborPos = pos.method_10069(direction.method_42015(), 0, direction.method_42016());
            int neighbor = this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)neighborPos)).biomeCache.getOrDefault(CacheRecord.getIndex(neighborPos), -1);
            if (neighbor <= 0) continue;
            upper = Math.min(upper, (float)neighbor + 2.72f);
        }
        int distance = Math.round(class_3532.method_15363((float)proposed, (float)lower, (float)upper));
        this.getCache(threadLocalCache, (class_1923)new class_1923((class_2338)pos)).biomeCache.put(CacheRecord.getIndex(pos), distance);
        return distance;
    }

    @NotNull
    public static synchronized BiomePerimetersImpl getOrCreateInstance(@NotNull class_1959 biome, int horizon) {
        return instances.computeIfAbsent(biome, key -> new BiomePerimetersImpl((class_1959)key, horizon));
    }

    private static final class CacheRecord {
        private final Int2ReferenceMap<BiomePerimeterPoint> perimeters = Int2ReferenceMaps.synchronize((Int2ReferenceMap)new Int2ReferenceOpenHashMap(1024), (Object)this);
        private final Int2IntMap biomeCache = Int2IntMaps.synchronize((Int2IntMap)new Int2IntOpenHashMap(1024), (Object)this);

        private CacheRecord() {
        }

        public void clear() {
            this.perimeters.clear();
            this.biomeCache.clear();
        }

        public static int getIndex(int x, int y, int z) {
            return x & 0xF | (z & 0xF) << 4 | (short)y << 8;
        }

        public static int getIndex(class_2338 pos) {
            return CacheRecord.getIndex(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
    }

    public static final class BiomePerimeterPoint
    implements Cloneable {
        final class_2338 pos;
        BiomePerimeterPoint left;
        BiomePerimeterPoint right;

        public BiomePerimeterPoint(@NotNull class_2338 pos, @Nullable BiomePerimeterPoint left, @Nullable BiomePerimeterPoint right) {
            this.pos = pos.method_10062();
            this.left = left;
            this.right = right;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public static BiomePerimeterPoint of(@NotNull class_2338 pos) {
            return new BiomePerimeterPoint(pos, null, null);
        }

        public static BiomePerimeterPoint rightOf(@NotNull class_2338 pos, BiomePerimeterPoint left) {
            return new BiomePerimeterPoint(pos, left, null);
        }

        public static BiomePerimeterPoint leftOf(@NotNull class_2338 pos, BiomePerimeterPoint right) {
            return new BiomePerimeterPoint(pos, null, right);
        }

        public static BiomePerimeterPoint of(@NotNull class_2338 pos, BiomePerimeterPoint left, BiomePerimeterPoint right) {
            return new BiomePerimeterPoint(pos, left, right);
        }

        public void setLeft(@NotNull BiomePerimeterPoint left) {
            assert (this.left == null);
            this.left = left;
        }

        public void setRight(@NotNull BiomePerimeterPoint right) {
            assert (this.right == null);
            this.right = right;
        }

        @NotNull
        public class_2338 getPos() {
            return this.pos.method_25503();
        }

        @Nullable
        public BiomePerimeterPoint getLeft() {
            try {
                return (BiomePerimeterPoint)this.left.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Nullable
        public BiomePerimeterPoint getRight() {
            try {
                return (BiomePerimeterPoint)this.right.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public double getDistance(@NotNull class_2338 pos) {
            return Math.sqrt(this.pos.method_10262((class_2382)pos));
        }

        public int getTaxicab(@NotNull class_2382 pos) {
            return this.pos.method_19455(pos);
        }
    }
}

