/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.gui.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;
import slimeknights.tmechworks.api.disguisestate.DisguiseState;
import slimeknights.tmechworks.common.blocks.tileentity.RedstoneMachineTileEntity;
import slimeknights.tmechworks.common.network.PacketHandler;
import slimeknights.tmechworks.common.network.packet.UpdateDisguiseStatePacket;

public class DisguiseStateWidget
extends Widget {
    private DisguiseState<?> state;
    private String stateString;
    private String hoveredState;
    private final RedstoneMachineTileEntity te;

    public DisguiseStateWidget(int x, int y, RedstoneMachineTileEntity te) {
        super(x, y, 0, 0, (ITextComponent)new StringTextComponent(""));
        this.te = te;
    }

    public void setState(DisguiseState<?> state, String stateString) {
        this.state = state;
        if (state != null) {
            this.stateString = state.getValueFrom(stateString).toString();
        }
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.state == null) {
            return;
        }
        Collection<?> states = this.state.getAllowedValues();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.state.getIconSheet());
        this.hoveredState = null;
        boolean canHover = true;
        int i = 0;
        for (Object obj : states) {
            String state = obj != null ? obj.toString() : "null";
            int rem = states.size() - i;
            int col = MathHelper.func_76141_d((float)((float)i / 3.0f));
            int row = i % 3;
            int xPos = this.field_230690_l_ + col * 8;
            int yPos = this.field_230691_m_ + row * 8;
            if (row == 0 && rem == 1) {
                yPos += 8;
            } else if (row == 0 && rem == 2) {
                yPos += 4;
            } else if (row == 1 && rem == 1) {
                yPos += 4;
            }
            boolean isActive = state.equals(this.stateString);
            boolean isHovered = false;
            if (canHover && !isActive && DisguiseStateWidget.intersects(xPos, yPos, mouseX, mouseY)) {
                this.hoveredState = state;
                isHovered = true;
                canHover = false;
            } else if (DisguiseStateWidget.intersects(xPos, yPos, mouseX, mouseY)) {
                canHover = false;
            }
            if (isActive) {
                RenderSystem.color4f((float)0.47f, (float)0.36f, (float)0.2f, (float)1.0f);
            } else if (isHovered) {
                RenderSystem.color4f((float)0.17f, (float)0.08f, (float)0.01f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.38f, (float)0.16f, (float)0.05f, (float)1.0f);
            }
            int index = this.state.unsafeGetIconFor(obj);
            int indexX = index % 32;
            int indexY = MathHelper.func_76141_d((float)((float)index / 32.0f));
            this.func_238474_b_(stack, xPos, yPos, indexX * 8, indexY * 8, 8, 8);
            if (++i < 9) continue;
            break;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public int getColumnCount() {
        if (this.state == null) {
            return 0;
        }
        return MathHelper.func_76125_a((int)MathHelper.func_76123_f((float)((float)this.state.getAllowedValues().size() / 3.0f)), (int)0, (int)3);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.state == null) {
            return false;
        }
        if (this.hoveredState != null) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.func_230982_a_(p_mouseClicked_1_, p_mouseClicked_3_);
            return true;
        }
        return false;
    }

    public void func_230982_a_(double p_onClick_1_, double p_onClick_3_) {
        if (this.state == null) {
            return;
        }
        super.func_230982_a_(p_onClick_1_, p_onClick_3_);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new UpdateDisguiseStatePacket(this.te.func_174877_v(), this.hoveredState));
        this.te.setDisguiseState(this.hoveredState);
    }

    private static boolean intersects(int x, int y, int mx, int my) {
        return mx > x && my > y && mx < x + 8 && my < y + 8;
    }
}

