/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tmechworks.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class ArrowWidget
extends Widget {
    public static final ResourceLocation ARROW_WIDGET = new ResourceLocation("tmechworks", "textures/gui/arrows.png");
    public static final String[] LABELS_DEFAULT = new String[]{"tmechworks:widget.arrow.down", "tmechworks:widget.arrow.up", "tmechworks:widget.arrow.front", "tmechworks:widget.arrow.back", "tmechworks:widget.arrow.left", "tmechworks:widget.arrow.right", "tmechworks:widget.arrow.high", "tmechworks:widget.arrow.middle", "tmechworks:widget.arrow.low"};
    private static final int ARROW_SIZE = 20;
    private static final int ARROW_SMALL_SIZE = 6;
    private static final int ARROW_ROWS = 2;
    private String[] labels;
    private ArrowState[] states = new ArrowState[Arrow.values().length];
    private Arrow hoveredArrow;
    private int screenW;
    private int screenH;
    private IArrowPressed onClick;

    public ArrowWidget(int x, int y, int screenW, int screenH, IArrowPressed onClick) {
        this(x, y, screenW, screenH, false, onClick);
    }

    public ArrowWidget(int x, int y, int screenW, int screenH, boolean drawAdditionalArrows, IArrowPressed onClick) {
        super(x, y, 0, 0, (ITextComponent)new StringTextComponent(""));
        this.setLabels(LABELS_DEFAULT);
        Arrays.fill((Object[])this.states, (Object)ArrowState.ENABLED);
        if (!drawAdditionalArrows) {
            for (int i = Arrow.MID_UP.ordinal(); i < Arrow.values().length; ++i) {
                this.states[i] = ArrowState.NO_DRAW;
            }
        }
        this.screenW = screenW;
        this.screenH = screenH;
        this.onClick = onClick;
    }

    public ArrowWidget setLabels(String[] labels) {
        if (labels.length < Arrow.values().length) {
            labels = new String[Arrow.values().length];
            Arrays.fill(this.labels, "");
            for (int i = 0; i < this.labels.length; ++i) {
                if (i >= labels.length) continue;
                this.labels[i] = labels[i];
            }
        } else {
            this.labels = labels;
        }
        return this;
    }

    public ArrowState getState(Arrow arrow) {
        return this.states[arrow.ordinal()];
    }

    public ArrowWidget setState(Arrow arrow, ArrowState state) {
        this.states[arrow.ordinal()] = state;
        return this;
    }

    public Arrow getHoveredArrow() {
        return this.hoveredArrow;
    }

    public void func_230431_b_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        ArrowState state;
        Arrow arrow;
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_230690_l_, (float)this.field_230691_m_, (float)0.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(ARROW_WIDGET);
        this.hoveredArrow = null;
        boolean canHover = true;
        for (i = 0; i < Arrow.values().length; ++i) {
            arrow = Arrow.values()[i];
            state = this.states[i];
            if (state == ArrowState.NO_DRAW) continue;
            if (state != ArrowState.DISABLED && state != ArrowState.SELECTED) {
                if (canHover && this.hoveredArrow == null && arrow.isHovered(this.field_230690_l_, this.field_230691_m_, mouseX, mouseY)) {
                    this.states[i] = ArrowState.HOVER;
                    this.hoveredArrow = arrow;
                    canHover = false;
                    continue;
                }
                this.states[i] = ArrowState.ENABLED;
                continue;
            }
            if (!arrow.isHovered(this.field_230690_l_, this.field_230691_m_, mouseX, mouseY)) continue;
            canHover = false;
        }
        for (i = 0; i < Arrow.values().length; ++i) {
            arrow = Arrow.values()[i];
            state = this.states[i];
            if (state == ArrowState.NO_DRAW) continue;
            int indexX = arrow.indexX * arrow.w + arrow.subX * arrow.subW;
            int indexY = (arrow.indexY + state.ordinal() * 2) * arrow.h + arrow.subY * arrow.subH;
            this.func_238474_b_(stack, arrow.x, arrow.y, indexX, indexY, arrow.subW, arrow.subH);
        }
        RenderSystem.popMatrix();
        if (this.hoveredArrow == null) {
            return;
        }
        if (this.labels != null && this.states[this.hoveredArrow.ordinal()] == ArrowState.HOVER && !this.labels[this.hoveredArrow.ordinal()].trim().isEmpty()) {
            GuiUtils.drawHoveringText((MatrixStack)stack, (List)ImmutableList.of((Object)ITextProperties.func_240652_a_((String)I18n.func_135052_a((String)this.labels[this.hoveredArrow.ordinal()], (Object[])new Object[0]))), (int)mouseX, (int)mouseY, (int)this.screenW, (int)this.screenH, (int)100, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.hoveredArrow != null) {
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            this.func_230982_a_(p_mouseClicked_1_, p_mouseClicked_3_);
            return true;
        }
        return false;
    }

    public void func_230982_a_(double p_onClick_1_, double p_onClick_3_) {
        super.func_230982_a_(p_onClick_1_, p_onClick_3_);
        this.onClick.onPress(this, this.hoveredArrow);
    }

    public static interface IArrowPressed {
        public void onPress(ArrowWidget var1, Arrow var2);
    }

    public static enum ArrowState {
        ENABLED,
        DISABLED,
        HOVER,
        SELECTED,
        NO_DRAW;

    }

    public static enum Arrow {
        MID_DOWN(2, 0, 0, 0, 13, 29),
        MID_UP(2, 0, 0, 0, 13, 13),
        UP(0, 0, 14, 0),
        DOWN(1, 0, 14, 28),
        LEFT(0, 1, 0, 14),
        RIGHT(1, 1, 28, 14),
        SMALL_UP(2, 0, 1, 0, 50, 15),
        SMALL_MID(2, 0, 0, 1, 50, 21),
        SMALL_DOWN(2, 0, 1, 1, 50, 29);

        public final int indexX;
        public final int indexY;
        public final int w;
        public final int h;
        public final int subX;
        public final int subY;
        public final int subW;
        public final int subH;
        public final int x;
        public final int y;

        private Arrow(int indexX, int indexY, int x, int y) {
            this(indexX, indexY, 20, 20, 0, 0, 20, 20, x, y);
        }

        private Arrow(int indexX, int indexY, int subX, int subY, int x, int y) {
            this(indexX, indexY, 20, 20, subX, subY, 6, 6, x, y);
        }

        private Arrow(int indexX, int indexY, int w, int h, int subX, int subY, int subW, int subH, int x, int y) {
            this.indexX = indexX;
            this.indexY = indexY;
            this.w = w;
            this.h = h;
            this.subX = subX;
            this.subY = subY;
            this.subW = subW;
            this.subH = subH;
            this.x = x;
            this.y = y;
        }

        public boolean isHovered(int xPosition, int yPosition, int mouseX, int mouseY) {
            return mouseX > xPosition + this.x && mouseX < xPosition + this.x + this.subW && mouseY > yPosition + this.y && mouseY < yPosition + this.y + this.subH;
        }
    }
}

