/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.PETags;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.tags.ITag;
import net.minecraft.world.World;

public class EntityRandomizerHelper {
    public static MobEntity getRandomEntity(World world, MobEntity toRandomize) {
        EntityType entType = toRandomize.func_200600_R();
        boolean isPeaceful = PETags.Entities.RANDOMIZER_PEACEFUL.func_230235_a_((Object)entType);
        boolean isHostile = PETags.Entities.RANDOMIZER_HOSTILE.func_230235_a_((Object)entType);
        if (isPeaceful && isHostile && toRandomize instanceof RabbitEntity && ((RabbitEntity)toRandomize).func_175531_cl() == 99) {
            isPeaceful = false;
        }
        if (isPeaceful) {
            return EntityRandomizerHelper.createRandomEntity(world, (Entity)toRandomize, PETags.Entities.RANDOMIZER_PEACEFUL);
        }
        if (isHostile) {
            MobEntity ent = EntityRandomizerHelper.createRandomEntity(world, (Entity)toRandomize, PETags.Entities.RANDOMIZER_HOSTILE);
            if (ent instanceof RabbitEntity) {
                ((RabbitEntity)ent).func_175529_r(99);
            }
            return ent;
        }
        if (world.field_73012_v.nextBoolean()) {
            return (MobEntity)EntityType.field_200743_ai.func_200721_a(world);
        }
        return (MobEntity)EntityType.field_200737_ac.func_200721_a(world);
    }

    @Nullable
    private static MobEntity createRandomEntity(World world, Entity current, ITag.INamedTag<EntityType<?>> type) {
        EntityType newType;
        EntityType currentType = current.func_200600_R();
        if (currentType == (newType = EntityRandomizerHelper.getRandomTagEntry(world.func_201674_k(), type, currentType))) {
            return null;
        }
        Entity newEntity = newType.func_200721_a(world);
        if (newEntity instanceof MobEntity) {
            return (MobEntity)newEntity;
        }
        if (newEntity != null) {
            newEntity.func_70106_y();
            PECore.LOGGER.warn("Invalid Entity type {} in mob randomizer tag {}. All entities in this tag are expected to be a mob.", (Object)newType.getRegistryName(), (Object)type.func_230234_a_());
        }
        return null;
    }

    private static <T> T getRandomTagEntry(Random random, ITag<T> tag, T toExclude) {
        Object obj;
        List list = tag.func_230236_b_();
        if (list.isEmpty() || list.size() == 1 && list.contains(toExclude)) {
            return toExclude;
        }
        while ((obj = tag.func_205596_a(random)).equals(toExclude)) {
        }
        return (T)obj;
    }
}

