/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.api.capabilities.tile.IEmcStorage;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.KleinStar;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class EMCHelper {
    public static long consumePlayerFuel(PlayerEntity player, long minFuel) {
        ItemStack offhand;
        long actualExtracted;
        if (player.field_71075_bZ.field_75098_d) {
            return minFuel;
        }
        IItemHandler curios = PlayerHelper.getCurios(player);
        if (curios != null) {
            for (int i = 0; i < curios.getSlots(); ++i) {
                actualExtracted = EMCHelper.tryExtract(curios.getStackInSlot(i), minFuel);
                if (actualExtracted <= 0L) continue;
                player.field_71070_bA.func_75142_b();
                return actualExtracted;
            }
        }
        if (!(offhand = player.func_184592_cb()).func_190926_b() && (actualExtracted = EMCHelper.tryExtract(offhand, minFuel)) > 0L) {
            player.field_71070_bA.func_75142_b();
            return actualExtracted;
        }
        Optional itemHandlerCap = player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve();
        if (itemHandlerCap.isPresent()) {
            IItemHandler inv = (IItemHandler)itemHandlerCap.get();
            LinkedHashMap<Integer, Integer> map = new LinkedHashMap<Integer, Integer>();
            boolean metRequirement = false;
            long emcConsumed = 0L;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                long actualExtracted2 = EMCHelper.tryExtract(stack, minFuel);
                if (actualExtracted2 > 0L) {
                    player.field_71070_bA.func_75142_b();
                    return actualExtracted2;
                }
                if (metRequirement || !FuelMapper.isStackFuel(stack)) continue;
                long emc = EMCHelper.getEmcValue(stack);
                int toRemove = (int)Math.ceil((double)(minFuel - emcConsumed) / (double)emc);
                if (stack.func_190916_E() >= toRemove) {
                    map.put(i, toRemove);
                    emcConsumed += emc * (long)toRemove;
                    metRequirement = true;
                    continue;
                }
                map.put(i, stack.func_190916_E());
                if ((emcConsumed += emc * (long)stack.func_190916_E()) < minFuel) continue;
                metRequirement = true;
            }
            if (metRequirement) {
                for (Map.Entry entry : map.entrySet()) {
                    inv.extractItem(((Integer)entry.getKey()).intValue(), ((Integer)entry.getValue()).intValue(), false);
                }
                player.field_71070_bA.func_75142_b();
                return emcConsumed;
            }
        }
        return -1L;
    }

    private static long tryExtract(@Nonnull ItemStack stack, long minFuel) {
        IItemEmcHolder emcHolder;
        long simulatedExtraction;
        if (stack.func_190926_b()) {
            return 0L;
        }
        Optional holderCapability = stack.getCapability(ProjectEAPI.EMC_HOLDER_ITEM_CAPABILITY).resolve();
        if (holderCapability.isPresent() && (simulatedExtraction = (emcHolder = (IItemEmcHolder)holderCapability.get()).extractEmc(stack, minFuel, IEmcStorage.EmcAction.SIMULATE)) == minFuel) {
            return emcHolder.extractEmc(stack, simulatedExtraction, IEmcStorage.EmcAction.EXECUTE);
        }
        return 0L;
    }

    public static boolean doesItemHaveEmc(ItemInfo info) {
        return EMCHelper.getEmcValue(info) > 0L;
    }

    public static boolean doesItemHaveEmc(ItemStack stack) {
        return EMCHelper.getEmcValue(stack) > 0L;
    }

    public static boolean doesItemHaveEmc(IItemProvider item) {
        return EMCHelper.getEmcValue(item) > 0L;
    }

    public static long getEmcValue(IItemProvider item) {
        return item == null ? 0L : EMCHelper.getEmcValue(ItemInfo.fromItem(item.func_199767_j()));
    }

    public static long getEmcValue(ItemStack stack) {
        return stack.func_190926_b() ? 0L : EMCHelper.getEmcValue(ItemInfo.fromStack(stack));
    }

    public static long getEmcValue(ItemInfo info) {
        return NBTManager.getEmcValue(info);
    }

    public static long getEmcSellValue(ItemStack stack) {
        return stack.func_190926_b() ? 0L : EMCHelper.getEmcSellValue(ItemInfo.fromStack(stack));
    }

    public static long getEmcSellValue(ItemInfo info) {
        return EMCHelper.getEmcSellValue(EMCHelper.getEmcValue(info));
    }

    public static long getEmcSellValue(long originalValue) {
        if (originalValue <= 0L) {
            return 0L;
        }
        long emc = (long)Math.floor((double)originalValue * ProjectEConfig.server.difficulty.covalenceLoss.get());
        if (emc < 1L) {
            emc = ProjectEConfig.server.difficulty.covalenceLossRounding.get() ? 1L : 0L;
        }
        return emc;
    }

    public static ITextComponent getEmcTextComponent(long emc, int stackSize) {
        String sell;
        String value;
        PELang prefix;
        if (ProjectEConfig.server.difficulty.covalenceLoss.get() == 1.0) {
            String value2;
            PELang prefix2;
            if (stackSize > 1) {
                prefix2 = PELang.EMC_STACK_TOOLTIP;
                value2 = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emc).multiply(BigInteger.valueOf(stackSize)));
            } else {
                prefix2 = PELang.EMC_TOOLTIP;
                value2 = Constants.EMC_FORMATTER.format(emc);
            }
            return prefix2.translateColored(TextFormatting.YELLOW, TextFormatting.WHITE, value2);
        }
        long emcSellValue = EMCHelper.getEmcSellValue(emc);
        if (stackSize > 1) {
            prefix = PELang.EMC_STACK_TOOLTIP_WITH_SELL;
            BigInteger bigIntStack = BigInteger.valueOf(stackSize);
            value = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emc).multiply(bigIntStack));
            sell = Constants.EMC_FORMATTER.format(BigInteger.valueOf(emcSellValue).multiply(bigIntStack));
        } else {
            prefix = PELang.EMC_TOOLTIP_WITH_SELL;
            value = Constants.EMC_FORMATTER.format(emc);
            sell = Constants.EMC_FORMATTER.format(emcSellValue);
        }
        return prefix.translateColored(TextFormatting.YELLOW, TextFormatting.WHITE, value, TextFormatting.BLUE, sell);
    }

    public static long getKleinStarMaxEmc(ItemStack stack) {
        if (stack.func_77973_b() instanceof KleinStar) {
            return Constants.MAX_KLEIN_EMC[((KleinStar)stack.func_77973_b()).tier.ordinal()];
        }
        return 0L;
    }

    public static long getEMCPerDurability(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0L;
        }
        if (stack.func_77984_f()) {
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.func_196085_b(0);
            long emc = (long)Math.ceil((double)EMCHelper.getEmcValue(stackCopy) / (double)stack.func_77958_k());
            return Math.max(emc, 1L);
        }
        return 1L;
    }

    public static long removeFractionalEMC(ItemStack stack, double amount) {
        CompoundNBT nbt = stack.func_196082_o();
        double unprocessedEMC = nbt.func_74769_h("UnprocessedEMC");
        long toRemove = (long)(unprocessedEMC += amount);
        nbt.func_74780_a("UnprocessedEMC", unprocessedEMC -= (double)toRemove);
        return toRemove;
    }
}

